;IMPORTANT: You are not allowed to sell this code or just parts of it in a commercial project or modify it and distribute it with a different name!
;Distributing copies of the program in compiled format (exe) must be free of any fee!

#pragma compile(Icon, SysInfo Clock.ico)
#pragma compile(ProductName, Autoit SysInfo Clock)
#pragma compile(InternalName, SysInfo Clock)
#pragma compile(OriginalFilename, SysInfo Clock.exe)
#pragma compile(FileDescription, "A small tool, made in a widget style, to show some system information regarding CPU, RAM and network, along with the current time.")
#pragma compile(FileVersion, 0.9.9.7)
#pragma compile(ProductVersion, 3.3.13.19)
#pragma compile(LegalCopyright, UEZ 2013-2014)
#pragma compile(CompanyName, UEZ Software Development)
#pragma compile(inputboxres, false)
#pragma compile(UPX, false)
#pragma compile(AutoItExecuteAllowed, false)
#pragma compile(Comments, "http://www.autoitscript.com/forum/index.php?showtopic=151768, IMPORTANT: You are not allowed to sell this code or just parts of it in a commercial project or modify it and distribute it with a different name!, Distributing copies of the program in compiled format (exe) must be free of any fee!")

#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Compile_Both=y
;~ #AutoIt3Wrapper_Res_Field=ProductVersion|%AutoItVer%
;~ #AutoIt3Wrapper_Res_Field=Build|2014-08-27
;~ #AutoIt3Wrapper_Res_Language=1033

#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/SO
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

;~ #AutoIt3Wrapper_Run_After=upx.exe --best --lzma "%out%"
;~ Break(0)

Opt("TrayMenuMode", 1)
Opt("MustDeclareVars", 1)

#include <Array.au3>
#include <ButtonConstants.au3>
#include <Date.au3>
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <GuiDateTimePicker.au3>
#include <GUIMenu.au3>
#include <Misc.au3>
#include <StaticConstants.au3>
#include <TrayConstants.au3>
#include <WindowsConstants.au3>
#include "FurElise.au3"

Global $ver = "v0.9.9.7 build 2014-08-27"
Global $sAppname = "Autoit SysInfo Clock" & @LF & $ver & " beta"
Global $sURL = "http://www.autoitscript.com/forum/index.php?showtopic=151768"

If @OSBuild < 2600 Then Exit MsgBox(16 + 262144, "ERROR", "This operating system is not supported! :-(", 30)

If Not _Singleton($sAppname, 2) Then Exit MsgBox(16 + 262144, "ERROR", "An occurence of " & $sAppname & " is already running!", 30)

_GDIPlus_Startup()

Global $aBitmaps[9] = [ _GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Blackpng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Bluepng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Indiglopng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Mintpng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Pinkpng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Purplepng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_Redpng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_XParentDkpng()), _
						_GDIPlus_BitmapCreateFromMemory(_Graphic_BG_XParentLtpng())]

Global $iWinPosX = -1, $iWinPosY = -1, $sIni = @ScriptDir & "\" & StringTrimRight(@ScriptName, 4) & ".ini"
Global $iSelection = 0, $aSettings, $aWinPos, $bRandom = 0, $bAlwaysOnTop = 1, $bSaveGUIPos = 1, $bIntro = False, $bEnableStartup = False, _
	   $iAlpha = 255, $bAlarm = False, $bAlarmPlay, $iAlarmSet, $iAlarmEnd, $iAlarmDuration = 60
If FileExists($sIni) Then
	$bEnableStartup = Int(IniRead($sIni, "Settings", "EnableStartup", 0))
	Startup($bEnableStartup)
	$iAlarmDuration = Int(IniRead($sIni, "Settings", "AlarmDuration", 60))
	If $iAlarmDuration < 60 Or $iAlarmDuration > 300 Then $iAlarmDuration = 60
	$iAlpha = Int(IniRead($sIni, "Settings", "GUIAlpha", 255))
	If $iAlpha < 0 Or $iAlpha > 255 Then $iAlpha = 255
	If $iAlpha < 0 Or $iAlpha > 255 Then $iAlpha = 255
	$bAlwaysOnTop = Int(IniRead($sIni, "Settings", "AlwaysOnTop", 1))
	If $bAlwaysOnTop < 0 Or $bAlwaysOnTop > 1 Then $bAlwaysOnTop = 1
	$bSaveGUIPos = Int(IniRead($sIni, "Settings", "SaveGUIPos", 1))
	If $bSaveGUIPos Then
		$iWinPosX = Int(IniRead($sIni, "Settings", "WinPosX", -1))
		$iWinPosY = Int(IniRead($sIni, "Settings", "WinPosY", -1))
	EndIf
	$iSelection = Int(IniRead($sIni, "Settings", "ClockColor", 0))
	If $iSelection < 0 Or $iSelection > UBound($aBitmaps) - 1 Then $iSelection = 0
	$bRandom = Int(IniRead($sIni, "Settings", "RandomClockColor", 0))
	If $bRandom Then $iSelection = Random(0, UBound($aBitmaps) - 1, 1)
EndIf

Global $hDLL_User32 = DllOpen("user32.dll")
Global Const $SC_DRAGMOVE = 0xF012, $SND_ASYNC = 0x00000001, $SND_MEMORY = 0x00000004, $SND_NOWAIT = 0x00002000; , $IMAGE_BITMAP = 0
;~ Global Const $STM_SETIMAGE = 0x0172
Global $aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $aBitmaps[0], "float*", 0, "float*", 0)
Global $iW = $aResult[2], $iH = $aResult[3]

Global $hGUI = GUICreate("SysInfo Clock Widget by UEZ 2013", $iW, $iH, $iWinPosX, $iWinPosY, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_TOPMOST * $bAlwaysOnTop, $WS_EX_TOOLWINDOW))
Global $iLabel_CPUUsage = GUICtrlCreateLabel("", 43, 75, 33, 32, -1, $GUI_WS_EX_PARENTDRAG)
Global $iLabel_CDriveUsage = GUICtrlCreateLabel("", 76, 46, 33, 32, -1, $GUI_WS_EX_PARENTDRAG)
Global $iLabel_MemUsage = GUICtrlCreateLabel("", 109, 75, 33, 32, -1, $GUI_WS_EX_PARENTDRAG)
Global $iLabel_CPUSpeed = GUICtrlCreateLabel("", 76, 106, 33, 32, -1, $GUI_WS_EX_PARENTDRAG)
Global $iLabel_Alarm = GUICtrlCreateLabel("", 40, 130, 14, 13, -1, $GUI_WS_EX_PARENTDRAG)
Global $iLabel_Network = GUICtrlCreateLabel("", 130, 130, 14, 13, -1, $GUI_WS_EX_PARENTDRAG)
Global $iLabel_CM = GUICtrlCreateLabel("", 73, 149, 39, 31, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetTip(-1, "Press right mouse button to open config menu", "", 0, 2)

Global $hQMenu, $hQMenu_Sub, $hQMenu_Sub2, $hQMenu_Sub3, $sAlarmText = "Alarm clock not set", $sAlarmTextSet = "Alarm is set to "
Global Enum $id_Black = 0x400, $id_Blue, $id_Indiglo, $id_Mint, $id_Pink, $id_Purple, $id_Red, $id_TDark, $id_TLight, $id_Rnd, $id_AOT, _
			$id_GUIPos, $id_About, $id_Exit, $id_Startup, $id_Alarm

$hQMenu_Sub = _GUICtrlMenu_CreatePopup()
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 0, "Black", $id_Black)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 1, "Blue", $id_Blue)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 2, "Indiglo", $id_Indiglo)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 3, "Mint", $id_Mint)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 4, "Pink", $id_Pink)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 5, "Purple", $id_Purple)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 6, "Red", $id_Red)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 7, "Transparent Dark", $id_TDark)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 8, "Transparent Light", $id_TLight)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 9, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu_Sub, 10, "Random color schema at startup", $id_Rnd)

_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, Int($iSelection), 1)
_GUICtrlMenu_CheckMenuItem($hQMenu_Sub, 10, $bRandom)

$hQMenu = _GUICtrlMenu_CreatePopup()
_GUICtrlMenu_InsertMenuItem($hQMenu, 0, " Clock color schema", 0, $hQMenu_Sub)
_GUICtrlMenu_InsertMenuItem($hQMenu, 1, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu, 2, " Always on top", $id_AOT)
_GUICtrlMenu_InsertMenuItem($hQMenu, 3, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu, 4, " Save GUI position on exit", $id_GUIPos)
_GUICtrlMenu_InsertMenuItem($hQMenu, 5, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu, 6, " Enable at startup", $id_Startup)
_GUICtrlMenu_InsertMenuItem($hQMenu, 7, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu, 8, $sAlarmText, $id_Alarm)
_GUICtrlMenu_InsertMenuItem($hQMenu, 9, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu, 10, " About (press ESC to quit)", $id_About)
_GUICtrlMenu_InsertMenuItem($hQMenu, 11, "", 0)
_GUICtrlMenu_InsertMenuItem($hQMenu, 12, " Exit", $id_Exit)

_GUICtrlMenu_CheckMenuItem($hQMenu, 2, $bAlwaysOnTop)
_GUICtrlMenu_CheckMenuItem($hQMenu, 4, $bSaveGUIPos)
_GUICtrlMenu_CheckMenuItem($hQMenu, 6, $bEnableStartup)

Global $hTmp = _GDIPlus_BitmapCreateFromMemory(_Colorpng())
Global $hBMP_Color = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_MENU)
_GDIPlus_BitmapDispose($hTmp)
_GUICtrlMenu_SetItemBmp($hQMenu, 0, $hBMP_Color)

Global $hTmp = _GDIPlus_BitmapCreateFromMemory(_Alarmpng())
Global $hBMP_Alarm = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_MENU)
_GDIPlus_BitmapDispose($hTmp)
_GUICtrlMenu_SetItemBmp($hQMenu, 8, $hBMP_Alarm)

Global $hBMP_About = _GDIPlus_BitmapCreateFromMemory(_Aboutpng(), True)
_GUICtrlMenu_SetItemBmp($hQMenu, 10, $hBMP_About)

;~ Global $hBMP_Exit = _GUICtrlMenu_CreateBitmap(@SystemDir & "\Shell32.dll", 27)
Global $hBMP_Exit = _GDIPlus_BitmapCreateFromMemory(_Exitpng(), True)
_GUICtrlMenu_SetItemBmp($hQMenu, 12, $hBMP_Exit)

$hTmp = _GDIPlus_BitmapCreateFromMemory(_Resetpng())
Global $hBMP_Reset = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_MENU)
_GDIPlus_BitmapDispose($hTmp)

$hTmp = _GDIPlus_BitmapCreateFromMemory(_Homepng())
Global $hBMP_Home = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_MENU)
_GDIPlus_BitmapDispose($hTmp)

$hTmp = _GDIPlus_BitmapCreateFromMemory(_ChkUpdpng())
Global $hBMP_ChkUpd = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_MENU)
_GDIPlus_BitmapDispose($hTmp)

$hTmp = _GDIPlus_BitmapCreateFromMemory(_Toppng())
Global $hBMP_Top = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_MENU)
_GDIPlus_BitmapDispose($hTmp)

Global $iTrayActivateHwnd = TrayCreateItem(" Bring GUI to front")
TrayCreateItem("")
Global $iTrayChkUpd = TrayCreateItem(" Check for Updates")
Global $iTrayVistWeb = TrayCreateItem(" Visit Web Site")
TrayCreateItem("")
Global $iTrayResetPos = TrayCreateItem(" Reset Window Position")
TrayCreateItem("")
Global $iTrayExit = TrayCreateItem(" Exit")


DllCall($hDLL_User32, "int", "SetMenuItemBitmaps", "hwnd", TrayItemGetHandle(0), "int", 0, "int", 0x00000400, "handle", $hBMP_Top, "handle", $hBMP_Top)
DllCall($hDLL_User32, "int", "SetMenuItemBitmaps", "hwnd", TrayItemGetHandle(0), "int", 2, "int", 0x00000400, "handle", $hBMP_ChkUpd, "handle", $hBMP_ChkUpd)
DllCall($hDLL_User32, "int", "SetMenuItemBitmaps", "hwnd", TrayItemGetHandle(0), "int", 3, "int", 0x00000400, "handle", $hBMP_Home, "handle", $hBMP_Home)
DllCall($hDLL_User32, "int", "SetMenuItemBitmaps", "hwnd", TrayItemGetHandle(0), "int", 5, "int", 0x00000400, "handle", $hBMP_Reset, "handle", $hBMP_Reset)
DllCall($hDLL_User32, "int", "SetMenuItemBitmaps", "hwnd", TrayItemGetHandle(0), "int", 7, "int", 0x00000400, "handle", $hBMP_Exit, "handle", $hBMP_Exit)

GUISetState()

#region load images
Global $hBitmap_BG = _GDIPlus_BitmapCloneArea($aBitmaps[$iSelection], 0, 0, $iW, $iH, $GDIP_PXF32ARGB)
Global $hCtxt = _GDIPlus_ImageGetGraphicsContext($hBitmap_BG)
;~ DllCall($__g_hGDIPDll, "uint", "GdipSetTextRenderingHint", "handle", $hCtxt, "int", 4)
_GDIPlus_GraphicsSetSmoothingMode($hCtxt, 2)

Global $hBitmap_Hr = _GDIPlus_BitmapCreateFromMemory(_Gauge_Hour_Yellowpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_Hr, "float*", 0, "float*", 0)
Global $iW_Hr = $aResult[2], $iH_Hr = $aResult[3]

Global $hBitmap_HrShadow = _GDIPlus_BitmapCreateFromMemory(_Gauge_Hour0png())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_HrShadow, "float*", 0, "float*", 0)
Global $iW_HrSh = $aResult[2], $iH_HrSh = $aResult[3]

Global $hBitmap_Min = _GDIPlus_BitmapCreateFromMemory(_Gauge_Min_Yellowpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_Min, "float*", 0, "float*", 0)
Global $iW_Min = $aResult[2], $iH_Min = $aResult[3]

Global $hBitmap_MinShadow = _GDIPlus_BitmapCreateFromMemory(_Gauge_Min0png())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_MinShadow, "float*", 0, "float*", 0)
Global $iW_MinSh = $aResult[2], $iH_MinSh = $aResult[3]

Global $hBitmap_Sec = _GDIPlus_BitmapCreateFromMemory(_Gauge_Arrow_TCPpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_Sec, "float*", 0, "float*", 0)
Global $iW_Sec = $aResult[2], $iH_Sec = $aResult[3]

Global $hBitmap_Center = _GDIPlus_BitmapCreateFromMemory(_Graphic_Centerpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_Center, "float*", 0, "float*", 0)
Global $iW_Center = $aResult[2], $iH_Center = $aResult[3]

Global $hBitmap_Glare = _GDIPlus_BitmapCreateFromMemory(_Graphic_Glare_Partialpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_Glare, "float*", 0, "float*", 0)
Global $iW_Glare = $aResult[2], $iH_Glare = $aResult[3]

Global $hBitmap_SmallGauge = _GDIPlus_BitmapCreateFromMemory(_Gauge_TinyWShadowpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_SmallGauge, "float*", 0, "float*", 0)
Global $iW_SmallGauge = $aResult[2], $iH_SmallGauge = $aResult[3]

Global $hBitmap_ButtonLeft = _GDIPlus_BitmapCreateFromMemory(_Button_leftpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_ButtonLeft, "float*", 0, "float*", 0)
Global $iW_ButtonLeft = $aResult[2], $iH_ButtonLeft = $aResult[3]

Global $hBitmap_ButtonRight = _GDIPlus_BitmapCreateFromMemory(_Button_rightpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_ButtonRight, "float*", 0, "float*", 0)
Global $iW_ButtonRight = $aResult[2], $iH_ButtonRight = $aResult[3]

Global $hBitmap_LED = _GDIPlus_BitmapCreateFromMemory(_ButtonLEDpng())
$aResult = DllCall($__g_hGDIPDll, "uint", "GdipGetImageDimension", "handle", $hBitmap_LED, "float*", 0, "float*", 0)
Global $iW_LED = $aResult[2], $iH_LED = $aResult[3]

Global $hBitmap_AlarmBg = _GDIPlus_BitmapCreateFromMemory(_AlarmBgjpg(), True)

#endregion load images

Global $iFontSize_Date = 10
Global $hPen = _GDIPlus_PenCreate(0xFFFFFF00, 3)
Global $hFamily_Date = _GDIPlus_FontFamilyCreate("Impact")
Global $hFormat_Date = _GDIPlus_StringFormatCreate()
Global $hFont_Date = _GDIPlus_FontCreate($hFamily_Date, $iFontSize_Date, 0)
Global $tLayout_Date = _GDIPlus_RectFCreate(0, 152, 0, 0)
Global $hBrush_Date = _GDIPlus_BrushCreateSolid(0xD0F8D962)

Global $oWMI = ObjGet("winmgmts:\\" & @ComputerName & "\root\cimv2"), $oTokens, $oValue, $sCPUName
If Not @error Or IsObj($oWMI) Then
	$oTokens = $oWMI.ExecQuery("SELECT Name FROM Win32_Processor")
	If Not @error Then
		For $oValue In $oTokens
			$sCPUName = StringStripWS($oValue.Name, 7)
		Next
	EndIf
EndIf
Global $iCPUSpeed_Current, $iCPUSpeed_Max = RegRead("HKEY_LOCAL_MACHINE\HARDWARE\DESCRIPTION\System\CentralProcessor\0", "~MHz")
Global $iCPUCores = _WinAPI_GetCPUCoreCount(), $sStructPPI, $hDLLPowrProf = DllOpen("PowrProf.dll"), $i
For $i = 1 To $iCPUCores
	$sStructPPI &= "ulong Number;ulong MaxMhz;ulong CurrentMhz;ulong MhzLimit;ulong MaxIdleState;ulong CurrentIdleState;"
Next
;~ $sStructPPI = "ulong;byte [" & ($iCPUCores * 24) & "];"
Global $tPROCESSOR_POWER_INFORMATION = DllStructCreate($sStructPPI)

Global $aTotalCPUCurInfo, $aCPUsCurInfo, $aPercents
If @error Then ConsoleWrite("Error calling _CPUGetIndividualProcessorTimes():" & @error & ", @extended = " & @extended & @CRLF)
Global $aTotalCPUPrevInfo = _CPUGetTotalProcessorTimes()
If @error Then ConsoleWrite("Error calling _CPUGetTotalProcessorTimes():" & @error & ", @extended = " & @extended & @CRLF)

Global Const $iMemTotalMem = _WinAPI_GetPerformanceInfo(3, True)
Global $iAvailableMem, $aCtrlHover, $fMemUsage, $iMemUsage, $fCDriveUsage, $fFreeHDSpace, $iTimerCDriveUsage, $iTimerCPUSpeed, _
	   $iTimerCPUUsage, $iTimerMemUsage, $iCounterValue, $iTimerDisplay, $iTimerNetwork, $iTimerAlarm
Global Const $iWait = 500, $iDelay = 500, $f = (300 / 360)

Global $hIPHLPAPI_DLL = DllOpen("Iphlpapi.dll")
Global $aUDPStats, $aTCPStats, $aIPStats, $aICMPStats, $iTCPReceived, $iTCPSent, $iIPReceived, $iIPSent, $iUDPReceived, $iUDPSent, _
	   $bNwTraffic = False, $bLED = False

$aUDPStats = _Network_UDPStatistics()
$aTCPStats = _Network_TCPStatistics()
$aIPStats = _Network_IPStatistics()
$iTCPReceived = $aTCPStats[9]
$iTCPSent = $aTCPStats[10]
$iIPReceived = $aIPStats[8]
$iIPSent = $aIPStats[9]
$iUDPReceived = $aUDPStats[0]
$iUDPSent = $aUDPStats[3]

Global $iTimer, $dOpen, $iInstance

Global $sChkAero = DllStructCreate("int;")
DllCall("dwmapi.dll", "int", "DwmIsCompositionEnabled", "ptr", DllStructGetPtr($sChkAero))
Global $bAero = DllStructGetData($sChkAero, 1)

UpdateView()

GUIRegisterMsg($WM_TIMER, "UpdateView") ;$WM_TIMER = 0x0113
DllCall($hDLL_User32, "int", "SetTimer", "hwnd", $hGUI, "int", 0, "int", $iWait, "int", 0)

Global $u = TimerInit(), $sAlarmTimer, $iTimeDiff, $iTimerPlayAlarm, $hGUI_Alarm, $bAlarmGUI = False
Global $binWave = _Alarmwav()
Global $tWave = DllStructCreate('byte[' & BinaryLen($binWave) & ']')
Global $pWave = DllStructGetPtr($tWave)
DllStructSetData($tWave, 1, $binWave)

$iTimerDisplay = TimerInit()

GUIRegisterMsg($WM_LBUTTONDOWN, "WM_LBUTTONDOWN")
GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
GUIRegisterMsg($WM_CONTEXTMENU, "WM_CONTEXTMENU")
Global $iDummyAbout = GUICtrlCreateDummy(), $iDummyAlarm = GUICtrlCreateDummy(), $iXFixedFrame
$iTimerCDriveUsage = TimerInit()
$iTimerCPUUsage = TimerInit()
$iTimerCPUSpeed = TimerInit()
$iTimerMemUsage = TimerInit()
$iTimerNetwork = TimerInit()
$iTimerAlarm = TimerInit()
$iTimerPlayAlarm = TimerInit()
Do
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			_Exit()
		Case $iDummyAbout
			$bIntro = True
			About_Intro()
			$bIntro = False
		Case $iDummyAlarm
			$bAlarmGUI = True
			$sAlarmTimer = SetAlarmDate()
			$bAlarmGUI = False
		Case $iLabel_Alarm
			If $bAlarm Then
				$bAlarm = False
				$bAlarmPlay = False
				_GUICtrlMenu_SetItemText($hQMenu, 8, $sAlarmText)
			EndIf
	EndSwitch
	Switch TrayGetMsg()
		Case $iTrayActivateHwnd
			WinActivate($hGUI)
		Case $iTrayChkUpd
			Check4Update()
		Case $iTrayVistWeb
			ShellExecute($sURL)
		Case $iTrayResetPos
			$iXFixedFrame = _WinAPI_GetSystemMetrics(32)
			WinMove($hGUI, "", (@DesktopWidth - $iW) / 2 - 2 * _WinAPI_GetSystemMetrics(5), (@DesktopHeight - $iH) / 2 - _WinAPI_GetSystemMetrics(4))
		Case $iTrayExit
			_Exit()
	EndSwitch
	$aCtrlHover = GUIGetCursorInfo($hGUI)
	If Not $bIntro And WinActive($hGUI) Then
		Switch $aCtrlHover[4]
			Case $iLabel_CDriveUsage
				If TimerDiff($iTimerCDriveUsage) > $iDelay Then
					ToolTip("C drive usage: " & Round(100 * $fCDriveUsage, 2) & "% (" & ConvertSize($fFreeHDSpace, "MiB") & " free)", MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					$iTimerCDriveUsage = TimerInit()
				EndIf
			Case $iLabel_CPUSpeed
				If TimerDiff($iTimerCPUSpeed) > $iDelay Then
					ToolTip("Current CPU speed: " & $iCPUSpeed_Current & " MHz" & @CRLF & _
							"CPU name: " & $sCPUName, MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					$iTimerCPUSpeed = TimerInit()
				EndIf
			Case $iLabel_CPUUsage
				If TimerDiff($iTimerCPUUsage) > $iDelay Then
					ToolTip("Current CPU usage: " & $iCounterValue & "%" & @CRLF & _
							"Number of CPU cores: " & $iCPUCores, MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					$iTimerCPUUsage = TimerInit()
				EndIf
			Case $iLabel_MemUsage
				If TimerDiff($iTimerMemUsage) > $iDelay Then
;~ 					ToolTip("Current memory usage: " & Round(100 * (1 - $fMemUsage), 2) & "% (" & StringFormat("%.2f", $iMemUsage / 1024^2) & " mb free)", MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					ToolTip("Current memory usage: " & StringFormat("%.2f", 100 * (1 - $fMemUsage)) & "% (" & ConvertSize($iMemUsage, "bytes") & " free)", MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					$iTimerMemUsage = TimerInit()
				EndIf
			Case $iLabel_Network
				If TimerDiff($iTimerNetwork) > $iDelay Then
					ToolTip("Network traffic: " & $bLED, MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					$iTimerNetwork = TimerInit()
				EndIf
			Case $iLabel_Alarm
				If TimerDiff($iTimerAlarm) > $iDelay Then
					ToolTip("Stop ringing alarm", MouseGetPos(0), MouseGetPos(1) + 20, "", 0, 4)
					$iTimerAlarm = TimerInit()
				EndIf
			Case Else
				ToolTip("")
		EndSwitch
	EndIf
	$iTimeDiff = _DateDiff('s', $sAlarmTimer, _NowCalc())
	If $bAlarm And $iTimeDiff > -1 Then
		$bAlarmPlay = True
		If $iTimeDiff > $iAlarmDuration Then
			$bAlarm = False
			$bAlarmPlay = False
		EndIf
		If TimerDiff($iTimerPlayAlarm) > 1000 Then
			_WinAPI_PlaySound($pWave, BitOR($SND_ASYNC, $SND_MEMORY, $SND_NOWAIT))
			$iTimerPlayAlarm = TimerInit()
		EndIf
	EndIf
Until False

Func SetAlarmDate()
    Local $aRange[14] = [True, @YEAR, @MON, @MDAY, @HOUR, @MIN, @MSEC, False, 0, 0, 0, 0, 0, 0]
    $hGUI_Alarm = GUICreate("Set Alarm Clock", 400, 400, -1, -1, BitOR($WS_DLGFRAME, $WS_POPUP), $WS_EX_TOPMOST)
	Local $hPic = GUICtrlCreatePic("", 0, 0, 400, 400)
	GUICtrlSetState(-1, $GUI_DISABLE)
	Local $hB = GUICtrlSendMsg($hPic, $STM_SETIMAGE, $IMAGE_BITMAP, $hBitmap_AlarmBg)
	If $hB Then _WinAPI_DeleteObject($hB)
	GUICtrlCreateLabel("Set Alarm", 0, 15, 400, 120, $SS_CENTER)
	GUICtrlSetFont(-1, 68, 400, 0, "Times New Roman", 4)
	GUICtrlSetBkColor(-1, -2)
	GUICtrlSetColor(-1, 0x180808)
	Local $iBtnExit, $iBtnSet, $hBMP_X, $hBMP_AC, $iStyle = Default, $iDSize = 50
	If @OSBuild < 6000 Then
		Local $hTmp = _GDIPlus_BitmapCreateFromMemory(_Exit4png())
		$hBMP_X = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_BTNFACE)
		_GDIPlus_BitmapDispose($hTmp)

		$hTmp = _GDIPlus_BitmapCreateFromMemory(_Alarmdpng())
		$hBMP_AC = _GDIPlus_Convert2HBitmap($hTmp, $COLOR_BTNFACE)
		_GDIPlus_BitmapDispose($hTmp)
		$iStyle = $BS_BITMAP
		$iDSize = 30
	Else
		$hBMP_X = _GDIPlus_BitmapCreateFromMemory(_Exit4png(), True)
		$hBMP_AC = _GDIPlus_BitmapCreateFromMemory(_Alarmdpng(), True)
	EndIf
	$iBtnExit = GUICtrlCreateButton("Exit", 50, 280, 80, 80, $iStyle)
	GUICtrlSetTip(-1, "Disable alarm clock")
	$iBtnSet = GUICtrlCreateButton("Set", 272, 280, 80, 80, $iStyle)
	GUICtrlSetTip(-1, "Enable alarm clock and exit")
	Local $hB = _SendMessage(GUICtrlGetHandle($iBtnExit), $BM_SETIMAGE, 0, $hBMP_X)
	If $hB Then _WinAPI_DeleteObject($hB)
	$hB = _SendMessage(GUICtrlGetHandle($iBtnSet), $BM_SETIMAGE, 0, $hBMP_AC)
	If $hB Then _WinAPI_DeleteObject($hB)

    Local $iDTP = GUICtrlCreateDate("", 50, 160, 300, $iDSize)
    Local $hDTP = GUICtrlGetHandle(-1)
	GUICtrlSetFont(-1, 14, 400, 0, "Courier New")

    GUISetState()

    _GUICtrlDTP_SetFormat($hDTP, "ddd MMM dd, yyyy HH:mm")
    _GUICtrlDTP_SetRange($hDTP, $aRange)

	Local $aDate, $sDate
    Do
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $iBtnExit
				$bAlarm = False
				_GUICtrlMenu_SetItemText($hQMenu, 8, $sAlarmText)
				_WinAPI_DeleteObject($hBMP_X)
				_WinAPI_DeleteObject($hBMP_AC)
				GUIDelete($hGUI_Alarm)
				Return 0
			Case $iBtnSet
				$aDate = _GUICtrlDTP_GetSystemTime($hDTP)
				$sDate = $aDate[0] & "/" & StringFormat("%02i", $aDate[1]) & "/" & StringFormat("%02i", $aDate[2]) & " " & StringFormat("%02i", $aDate[3]) & ":" & StringFormat("%02i", $aDate[4]) & ":00"
				If _DateDiff('s', $sDate, _NowCalc()) > 0 Then
					MsgBox(16 + 262144, "Error", "Alarm must be greater than current date / time!")
				Else
					$bAlarm = True
					_GUICtrlMenu_SetItemText($hQMenu, 8, "Alarm set to " & $sDate)
					_WinAPI_DeleteObject($hBMP_X)
					_WinAPI_DeleteObject($hBMP_AC)
					GUIDelete($hGUI_Alarm)
					Return $sDate
				EndIf
		EndSwitch
    Until False
EndFunc

Func Check4Update()
	GUISetCursor(15)
	Local $iRead = InetRead($sURL)
	If @error Then Return MsgBox(16, "Error", "Unable to check online! Behind a firewall or proxy?", 30, $hGUI)
	Local $aRegEx = StringRegExp(BinaryToString($iRead), "(?i)<title>Autoit SysInfo Clock (v\d\..*\d+-\d+-\d+)\s.*</title>", 1)
	GUISetCursor(-1)
	If Not IsArray($aRegEx) Or @error Then Return MsgBox(16, "Internal Error", "Unable to parse line!", 30, $hGUI)
	Local $sVer = $aRegEx[0]
	If $ver = $sVer Then
		MsgBox(64, "Update Information", "Current version: " & $ver & @CRLF & "Web version: " & $sVer & @LF & @LF & "Your version is up-to-date! :-)", 15, $hGUI)
	Else
		Local $iChk = MsgBox(32 + 4 + 256, "Update Information", "Current version: " & $ver & @CRLF & "Web version: " & $sVer & @LF & @LF & "Found newer version. Visit web site?", 30, $hGUI)
		If $iChk = 6 Then ShellExecute($sURL)
	EndIf
	WinActivate(HWnd($hGUI))
EndFunc   ;==>Check4Update

Func ConvertSize($fNumber, $sSuffix)
	Local $aPos[9]= ["B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"]
	Local $iPos = _ArraySearch($aPos, $sSuffix)
	If @error Then SetError(1, 0, 0)
	Local $i = 0
	Do
		Switch StringLen(Round($fNumber / 1024^$i, 0))
			Case 0 To 1
				$i -= 1
			Case 5 To 10000
				$i += 1
			Case Else
				ExitLoop
		EndSwitch
		If $i < 0 Or $i > 8 Then Return SetError(2, 0, 0)
	Until False
	Return StringFormat("%.2f " & $aPos[$iPos + $i], $fNumber / 1024^$i)
EndFunc

Func About_Intro() ;heartbeat of the clock
	TrayItemSetState($iTrayActivateHwnd, $TRAY_DISABLE)
	TrayItemSetState($iTrayChkUpd, $TRAY_DISABLE)
	TrayItemSetState($iTrayVistWeb, $TRAY_DISABLE)
	TrayItemSetState($iTrayResetPos, $TRAY_DISABLE)
	TrayItemSetState($iTrayExit, $TRAY_DISABLE)
	ToolTip("")
	Local $iWidth = 180, $iHeight = 180, $hRegion, $iBGTColor = 0x100001
	Local $hGUI_Child = GUICreate("Intro", $iWidth, $iHeight, 5, 6, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD, $WS_EX_TOOLWINDOW), $hGUI)
	GUISetBkColor($iBGTColor)
	_WinAPI_SetLayeredWindowAttributes($hGUI_Child, $iBGTColor, 0xFF, 0x01)
	GUISetState(@SW_SHOW, $hGUI_Child)
	If Not $bAero Then
		$hRegion = _WinAPI_CreateRoundRectRgn(0, 0, $iWidth, $iHeight, $iWidth, $iHeight)
		_WinAPI_SetWindowRgn($hGUI_Child, $hRegion)
	EndIf

	Local $hGraphics = _GDIPlus_GraphicsCreateFromHWND($hGUI_Child)
	Local $hBmpBuffer = _GDIPlus_BitmapCreateFromGraphics($iWidth, $iHeight, $hGraphics)
	Local $hGfxBuffer = _GDIPlus_ImageGetGraphicsContext($hBmpBuffer)
	_GDIPlus_GraphicsSetSmoothingMode($hGfxBuffer, 2)
;~ DllCall($__g_hGDIPDll, "uint", "GdipSetInterpolationMode", "handle", $hGfxBuffer, "int", 7)
;~ 	_GDIPlus_GraphicsClear($hGfxBuffer, 0xFF000000 + $iBGTColor)
	Local $hFormat = _GDIPlus_StringFormatCreate()
	Local $hFamily = _GDIPlus_FontFamilyCreate("Impact")
	Local $hFont = _GDIPlus_FontCreate($hFamily, 8.5)
	Local $iBColor
	Switch $iSelection
		Case 0, 1, 5, 6, 7
			$iBColor = 0xFFFFFF
		Case Else
			$iBColor = 0x000000
	EndSwitch
	Local $hBrush = _GDIPlus_BrushCreateSolid(0xFF000000 + $iBColor)
	Local $tLayout = _GDIPlus_RectFCreate($iWidth / 2, 0, 0, 0)
	_GDIPlus_StringFormatSetAlign($hFormat, 1)
	Local $hTexture, $hBitmap, $hContext, $fScale, $hMatrix, $fTmp, $hImgClone, $hCtxtBmpClone
	Local $iSize = $iWidth - 4, $bStartScoller = True, $bOneTime = True
	Local $fArea = 1, $iY = $iHeight, $c = 0.25, $d = 0
	DllStructSetData($tLayout, "y", $iHeight)
	Local $sText = $sAppname & @CRLF & _
					"coded by UEZ" & @CRLF & @CRLF & @CRLF & _
					"Credits:" & @CRLF & @CRLF & _
					"Images by" & @CRLF & _
					"Nicholas Decker" & @CRLF & _
					"(SysMetrix)" & @CRLF & @CRLF & _
					"CPU and network" & @CRLF & _
					"usage code by" & @CRLF & _
					"Ascend4nt" & @CRLF & @CRLF & _
					"Initial lens code by" & @CRLF & _
					"eukalyptus" & @CRLF & @CRLF & _
					"mus++ UDF and" & @CRLF & _
					"music notes for" & @CRLF & _
					"Fr Elise by" & @CRLF & _
					"czardas" & @CRLF & @CRLF & _
					"WinAPIEx UDF by" & @CRLF & _
					"Yashied" & @CRLF & @CRLF & @CRLF & _
					"Greeting to" & @CRLF & _
					"all AutoIt coders from" & @CRLF & _
					"Autoitscript.com / AutoIt.de" & @CRLF & _
					"and other sites" & @CRLF & _
					"around the world" & @CRLF & @CRLF & @CRLF & _
					"Special thx to:" & @CRLF & _
					"trancexx and AndyG" & @CRLF & @CRLF & _
					"_________________________________________" & @CRLF & @CRLF & @CRLF & @CRLF & @CRLF & @CRLF & _
					"Press ESC to exit"


	Local $aMeasure = _GDIPlus_GraphicsMeasureString($hGfxBuffer, $sText, $hFont, $tLayout, $hFormat)
	Local $fScrollerHeight = DllStructGetData($aMeasure[0], "Height") + 20
	Opt("GUICloseOnESC", 0)
	ProcessSetPriority(@AutoItPID, 4)
	$dOpen = _MidiOutOpen()
	$iInstance = 0
	$iTimer = TimerInit()
	DllCall($hDLL_User32, "int", "SetTimer", "hwnd", $hGUI, "int", 0, "int", 0, "int", 0)
	Do
;~ 		_GDIPlus_GraphicsClear($hGfxBuffer, 0xFF000000 + $iBGTColor)
		$hImgClone = DllCall($__g_hGDIPDll, "int", "GdipCloneBitmapAreaI", "int", 3, "int", 3, "int", $iWidth, "int", $iHeight, _
										    "int", $GDIP_PXF32ARGB, "handle", $hBitmap_BG, "ptr*", 0)
		$hImgClone = $hImgClone[7]
		$hCtxtBmpClone = DllCall($__g_hGDIPDll, "int", "GdipGetImageGraphicsContext", "handle", $hImgClone, "ptr*", 0)
		$hCtxtBmpClone = $hCtxtBmpClone[2]
		DllCall($__g_hGDIPDll, "uint", "GdipSetTextRenderingHint", "handle", $hCtxtBmpClone, "int", 4)

		DllCall($__g_hGDIPDll, "int", "GdipDrawString", "handle", $hCtxtBmpClone, "wstr", $sText, "int", -1, "handle", $hFont, "struct*", $tLayout, "handle", $hFormat, "handle", $hBrush)
		$iY -= 0.3333
		DllStructSetData($tLayout, "y", $iY)
		If $iY < -$fScrollerHeight Then $iY = $iHeight + 10
		$fArea = -$d + 0.876 + Cos($c / 4) / 8
		If $bOneTime Then
			If ($iY < $iH * 0.25) Then
				If $d < 0.186 Then
					$d += 0.0075
				Else
					$bOneTime = False
				EndIf
			EndIf
		Else
			$c += 0.75
		EndIf
		$hTexture = DllCall($__g_hGDIPDll, "uint", "GdipCreateTexture", "handle", $hImgClone, "int", 0, "ptr*", 0)
		$hTexture = $hTexture[3]

		$hBitmap = DllCall($__g_hGDIPDll, "int", "GdipCreateBitmapFromGraphics", "int", $iSize, "int", $iSize, "handle", $hGraphics, "ptr*", 0)
		$hBitmap = $hBitmap[4]

		$hContext = DllCall($__g_hGDIPDll, "int", "GdipGetImageGraphicsContext", "handle", $hBitmap, "ptr*", 0)
		$hContext = $hContext[2]

		$fScale = 1
		$hMatrix = DllCall($__g_hGDIPDll, "int", "GdipCreateMatrix", "ptr*", 0)
		$hMatrix = $hMatrix[1]

		DllCall($__g_hGDIPDll, "int", "GdipFillEllipseI", "ptr", $hContext, "ptr", $hTexture,  "int", 0, "int", 0, "int", $iSize, "int", $iSize)
		DllCall($__g_hGDIPDll, "int", "GdipSetSmoothingMode", "handle", $hContext, "int", 2)

		$fTmp = 0
		For $i = 2 To Floor($iSize / 3.333)
			$fTmp = $i * ($iSize * $fArea) / ($iSize / 2)
			$fScale = (($iSize - $fTmp) / ($iSize - $i * 2))

			DllCall($__g_hGDIPDll, "uint", "GdipSetMatrixElements", "handle", $hMatrix, "float", 1, "float", 0, "float", 0, "float", 1, "float", 0, "float", 0)
			DllCall($__g_hGDIPDll, "int", "GdipTranslateMatrix", "handle", $hMatrix, "float", $iSize / 2, "float", $iSize / 2, "int", 0)
			DllCall($__g_hGDIPDll, "int", "GdipScaleMatrix", "handle", $hMatrix, "float", $fScale, "float", $fScale, "int", 0)
			DllCall($__g_hGDIPDll, "int", "GdipTranslateMatrix", "handle", $hMatrix, "float", -$iSize / 2, "float", -$iSize / 2, "int", 0)
			DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hContext, "handle", $hMatrix)
			DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $hContext, "handle", $hTexture, "float", $i, "float", $i, "float", $iSize - $i * 2, "float", $iSize - $i * 2)
		Next

		DllCall($__g_hGDIPDll, "uint", "GdipSetMatrixElements", "handle", $hMatrix, "float", 1, "float", 0, "float", 0, "float", 1, "float", 0, "float", 0)
		DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hContext, "handle", $hMatrix)
		DllCall($__g_hGDIPDll, "int", "GdipDeleteMatrix", "handle", $hMatrix)
		DllCall($__g_hGDIPDll, "int", "GdipDeleteBrush", "handle", $hTexture)

		DllCall($__g_hGDIPDll, "int", "GdipDrawImageI", "handle", $hGfxBuffer, "handle", $hBitmap, "int", 1, "int", 0)

		DllCall($__g_hGDIPDll, "int", "GdipDeleteGraphics", "handle", $hCtxtBmpClone)
		DllCall($__g_hGDIPDll, "int", "GdipDeleteGraphics", "handle", $hContext)
		DllCall($__g_hGDIPDll, "int", "GdipDisposeImage", "handle", $hImgClone)
		DllCall($__g_hGDIPDll, "int", "GdipDisposeImage", "handle", $hBitmap)
		DllCall($__g_hGDIPDll, "int", "GdipDrawImageI", "handle", $hGraphics, "handle", $hBmpBuffer, "int", 0, "int", 0)

		If _IsPressed("1B", $hDLL_User32) Then
			While _IsPressed("1B", $hDLL_User32)
				Sleep(50)
			WEnd
			ExitLoop
		EndIf
	Until Not Sleep(30)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_FontDispose($hFont)
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_GraphicsDispose($hGfxBuffer)
	_GDIPlus_BitmapDispose($hBmpBuffer)
	_GDIPlus_GraphicsDispose($hGraphics)
	If Not $bAero Then _WinAPI_DeleteObject($hRegion)
	Opt("GUICloseOnESC", 1)
	_MidiOutClose($dOpen)
	DllCall($hDLL_User32, "int", "SetTimer", "hwnd", $hGUI, "int", 0, "int", $iWait, "int", 0)
	ProcessSetPriority(@AutoItPID, 2)
	TrayItemSetState($iTrayActivateHwnd, $TRAY_ENABLE)
	TrayItemSetState($iTrayChkUpd, $TRAY_ENABLE)
	TrayItemSetState($iTrayVistWeb, $TRAY_ENABLE)
	TrayItemSetState($iTrayResetPos, $TRAY_ENABLE)
	TrayItemSetState($iTrayExit, $TRAY_ENABLE)
	Return GUIDelete($hGUI_Child)
EndFunc   ;==>About_Intro

Func _Exit()
	GUIRegisterMsg($WM_TIMER, "")
	GUIRegisterMsg($WM_COMMAND, "")
	GUIRegisterMsg($WM_CONTEXTMENU, "")
	AdlibUnRegister("UpdateView")
	_GDIPlus_GraphicsDispose($hCtxt)
	For $i = 0 To UBound($aBitmaps) - 1
		_GDIPlus_BitmapDispose($aBitmaps[$i])
	Next
	_GDIPlus_BitmapDispose($hBitmap_BG)
	_GDIPlus_BitmapDispose($hBitmap_Hr)
	_GDIPlus_BitmapDispose($hBitmap_HrShadow)
	_GDIPlus_BitmapDispose($hBitmap_Min)
	_GDIPlus_BitmapDispose($hBitmap_MinShadow)
	_GDIPlus_BitmapDispose($hBitmap_Sec)
	_GDIPlus_BitmapDispose($hBitmap_Center)
	_GDIPlus_BitmapDispose($hBitmap_Glare)
	_GDIPlus_BitmapDispose($hBitmap_SmallGauge)
	_GDIPlus_BitmapDispose($hBitmap_ButtonLeft)
	_GDIPlus_BitmapDispose($hBitmap_ButtonRight)
	_GDIPlus_BitmapDispose($hBitmap_LED)

	_GDIPlus_PenDispose($hPen)
	_GDIPlus_BitmapDispose($hBrush_Date)
	_GDIPlus_FontFamilyDispose($hFamily_Date)
	_GDIPlus_StringFormatDispose($hFormat_Date)

	_WinAPI_DeleteObject($hBMP_Color)
	_WinAPI_DeleteObject($hBMP_Alarm)
	_WinAPI_DeleteObject($hBMP_Exit)
	_WinAPI_DeleteObject($hBMP_Reset)
	_WinAPI_DeleteObject($hBMP_About)
	_WinAPI_DeleteObject($hBMP_Home)
	_WinAPI_DeleteObject($hBMP_ChkUpd)
	_WinAPI_DeleteObject($hBMP_Top)
	_WinAPI_DeleteObject($hBitmap_AlarmBg)

	$aWinPos = WinGetPos($hGUI)
	IniWrite($sIni, "Settings", "AlwaysOnTop", $bAlwaysOnTop)
	IniWrite($sIni, "Settings", "RandomClockColor", $bRandom)
	IniWrite($sIni, "Settings", "ClockColor", $iSelection)
	IniWrite($sIni, "Settings", "WinPosX", $aWinPos[0])
	IniWrite($sIni, "Settings", "WinPosY", $aWinPos[1])
	IniWrite($sIni, "Settings", "SaveGUIPos", $bSaveGUIPos)
	IniWrite($sIni, "Settings", "GUIAlpha", $iAlpha)
	IniWrite($sIni, "Settings", "EnableStartup", $bEnableStartup)
	GUIDelete()
	_GDIPlus_Shutdown()
	DllClose($hDLLPowrProf)
	DllClose($hIPHLPAPI_DLL)
	DllClose($hDLL_User32)
	Exit
EndFunc   ;==>_Exit

Func UpdateView()
	If TimerDiff($iTimerDisplay) > $iWait Then
		Draw()
		$iTimerDisplay = TimerInit()
	EndIf
	If $bIntro Then Play()
EndFunc   ;==>UpdateView

Func Draw()
	$aTotalCPUCurInfo = _CPUGetTotalProcessorTimes()
	$iCounterValue = _CPUCalculateUsage($aTotalCPUPrevInfo, $aTotalCPUCurInfo)

	_GDIPlus_GraphicsClear($hCtxt, 0x00000000)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $aBitmaps[$iSelection], 0, 0, $iW, $iH)

	_GDIPlus_PenSetColor($hPen, 0x48FFFF00)
	_GDIPlus_GraphicsDrawArc($hCtxt, 43, 75, 32, 32, -30, 60, $hPen)
	_GDIPlus_GraphicsDrawArc($hCtxt, 109, 75, 32, 32, -30, 60, $hPen)
	_GDIPlus_GraphicsDrawArc($hCtxt, 76, 46, 32, 32, -30, 60, $hPen)
	_GDIPlus_GraphicsDrawArc($hCtxt, 76, 106, 32, 32, -30, 60, $hPen)
	_GDIPlus_PenSetColor($hPen, 0x48FF0000)
	_GDIPlus_GraphicsDrawArc($hCtxt, 43, 75, 32, 32, 10, 50, $hPen)
	_GDIPlus_GraphicsDrawArc($hCtxt, 109, 75, 32, 32, 10, 50, $hPen)
	_GDIPlus_GraphicsDrawArc($hCtxt, 76, 46, 32, 32, 10, 50, $hPen)
	_GDIPlus_GraphicsDrawArc($hCtxt, 76, 106, 32, 32, 10, 50, $hPen)

	;set cpu gauge
	Local $hBitmap_Tmp = RotateBitmap($hBitmap_SmallGauge, -150 + ($iCounterValue / 100 * 360) * $f) ;range is from -150 to 150
	Local $iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp), $iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2 - 34, ($iH - $iHeight) / 2 - 1, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)

	;set mem gauge
	$iMemUsage = _WinAPI_GetPerformanceInfo(4, True)
	$fMemUsage =  $iMemUsage / $iMemTotalMem
	Local $hBitmap_Tmp = RotateBitmap($hBitmap_SmallGauge, -150 + ((1 - $fMemUsage) * 360)) ;range is from -150 to 150
	Local $iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp), $iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2 + 34, ($iH - $iHeight) / 2 - 1, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)

	;set c drive gauge
	$fFreeHDSpace = DriveSpaceFree(@HomeDrive & "\")
	$fCDriveUsage = (1 - $fFreeHDSpace / DriveSpaceTotal(@HomeDrive & "\"))
	Local $hBitmap_Tmp = RotateBitmap($hBitmap_SmallGauge, -150 + ($fCDriveUsage * 360) * $f) ;range is from -150 to 150
	Local $iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp), $iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2, ($iH - $iHeight) / 2 - 30, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)


	DllCall($hDLLPowrProf, 	"ulong", "CallNtPowerInformation", _
							"int", 11, _ ;http://msdn.microsoft.com/en-us/library/windows/desktop/aa372675(v=vs.85).aspx
							"ptr", 0, _
							"ulong", 0, _
							"ptr", DllStructGetPtr($tPROCESSOR_POWER_INFORMATION), _
							"ulong", DllStructGetSize($tPROCESSOR_POWER_INFORMATION))
	$iCPUSpeed_Current = DllStructGetData($tPROCESSOR_POWER_INFORMATION, "CurrentMhz")

	;set CPU speed gauge
	Local $hBitmap_Tmp = RotateBitmap($hBitmap_SmallGauge, -150 + ($iCPUSpeed_Current / $iCPUSpeed_Max * 360) * $f) ;range is from -150 to 150
	Local $iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp), $iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2, ($iH - $iHeight) / 2 + 30, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)

	$aUDPStats = _Network_UDPStatistics()
	$aTCPStats = _Network_TCPStatistics()
	$aIPStats = _Network_IPStatistics()
	If	($aTCPStats[9] <> $iTCPReceived) Or ($aTCPStats[10] <> $iTCPSent) Or _
		($aIPStats[8] <> $iIPReceived) Or ($aIPStats[9] <> $iIPSent) Or _
		($aUDPStats[0] <> $iUDPReceived) Or ($aUDPStats[3] <> $iUDPSent) Then
		$iTCPReceived = $aTCPStats[9]
		$iTCPSent = $aTCPStats[10]
		$iIPReceived = $aIPStats[8]
		$iIPSent = $aIPStats[9]
		$iUDPReceived = $aUDPStats[0]
		$iUDPSent = $aUDPStats[3]
		$bNwTraffic = True
	EndIf

	Switch $bNwTraffic
		Case 1
			_GDIPlus_GraphicsDrawImageRectRect($hCtxt, $hBitmap_LED, 40, 0, 20, $iH_LED, 127, 127, 20, $iH_LED)
			$bNwTraffic = False
			$bLED = True
		Case Else
			$bLED = False
	EndSwitch

	If $bAlarmPlay Then _GDIPlus_GraphicsDrawImageRectRect($hCtxt, $hBitmap_LED, 20, 0, 20, $iH_LED, 38, 127, 20, $iH_LED)

	;set second gauge
	$hBitmap_Tmp = RotateBitmap($hBitmap_Sec, -70 + (6 * @SEC) * (140 / 360)) ;range is from -70 to 70
	$iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp)
	$iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2, 139, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)

	;set hour gauge
	$hBitmap_Tmp = RotateBitmap($hBitmap_HrShadow, 30 * Mod(@HOUR, 12) + @MIN / 2)
	$iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp)
	$iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2 + 2, ($iH - $iHeight) / 2 + 2, $iWidth, $iHeight) ;shadow
	_GDIPlus_BitmapDispose($hBitmap_Tmp)
	$hBitmap_Tmp = RotateBitmap($hBitmap_Hr, 30 * Mod(@HOUR, 12) + @MIN / 2)
	$iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp)
	$iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2, ($iH - $iHeight) / 2, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)

	;set minute gauge
	$hBitmap_Tmp = RotateBitmap($hBitmap_MinShadow, 6 * (@MIN + (@SEC / 60)))
	$iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp)
	$iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2 + 2, ($iH - $iHeight) / 2 + 2, $iWidth, $iHeight) ;shadow
	_GDIPlus_BitmapDispose($hBitmap_Tmp)
	$hBitmap_Tmp = RotateBitmap($hBitmap_Min, 6 * (@MIN + (@SEC / 60)))
	$iWidth = _GDIPlus_ImageGetWidth($hBitmap_Tmp)
	$iHeight = _GDIPlus_ImageGetHeight($hBitmap_Tmp)
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Tmp, ($iW - $iWidth) / 2, ($iH - $iHeight) / 2, $iWidth, $iHeight)
	_GDIPlus_BitmapDispose($hBitmap_Tmp)

	;set center button
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Center, ($iW - $iW_Center) / 2, ($iH - $iH_Center) / 2, $iW_Center, $iH_Center)

	;set current date (day only)
	Local $sText = @MDAY
	Local $aMeasure_Date = _GDIPlus_GraphicsMeasureString($hCtxt, $sText, $hFont_Date, $tLayout_Date, $hFormat_Date)
	DllStructSetData($tLayout_Date, "X", 93 - DllStructGetData($aMeasure_Date[0], "Width") / 2)
	_GDIPlus_GraphicsDrawStringEx($hCtxt, $sText, $hFont_Date, $tLayout_Date, $hFormat_Date, $hBrush_Date)
	$aMeasure_Date = 0

	;set glare
	_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBitmap_Glare, ($iW - $iW_Glare) / 2, 18, $iW_Glare, $iH_Glare)

	;set button left
	_GDIPlus_GraphicsDrawImageRectRect($hCtxt, $hBitmap_ButtonLeft, 0, 0, 12, $iH_ButtonLeft, 5, ($iH - $iH_ButtonLeft) / 2, 12, $iH_ButtonLeft)

	;set button right
	_GDIPlus_GraphicsDrawImageRectRect($hCtxt, $hBitmap_ButtonRight, 0, 0, 12, $iH_ButtonRight, $iW - 18, ($iH - $iH_ButtonRight) / 2, 12, $iH_ButtonRight)

	Local $hHBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBitmap_BG)
	Local $hScrDC = _WinAPI_GetDC($hGUI)
	Local $hMemDC = _WinAPI_CreateCompatibleDC($hScrDC)
	Local $hOld = _WinAPI_SelectObject($hMemDC, $hHBitmap)
	Local $tSize = DllStructCreate($tagSIZE)
	DllStructSetData($tSize, "X", $iW)
	DllStructSetData($tSize, "Y", $iH)
	Local $tSource = DllStructCreate($tagPOINT)
	Local $tBlend = DllStructCreate($tagBLENDFUNCTION)
	DllStructSetData($tBlend, "Alpha", $iAlpha)
	DllStructSetData($tBlend, "Format", 1)
	DllCall($hDLL_User32, "bool", "UpdateLayeredWindow", "hwnd", $hGUI, "handle", $hScrDC, "ptr", 0, "struct*", $tSize, "handle", $hMemDC, "struct*", $tSource, "dword", 0, "struct*", $tBlend, "dword", $ULW_ALPHA)
	_WinAPI_ReleaseDC(0, $hScrDC)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_DeleteDC($hMemDC)
	$aTotalCPUPrevInfo = $aTotalCPUCurInfo
EndFunc   ;==>Draw

Func RotateBitmap($hBitmap, $fAngel)
	Local Const $iW = _GDIPlus_ImageGetWidth($hBitmap), $iH = _GDIPlus_ImageGetHeight($hBitmap)
	Local Const $aResult = DllCall($__g_hGDIPDll, "uint", "GdipCreateBitmapFromScan0", "int", $iH, "int", $iH, "int", 0, "int", $GDIP_PXF32ARGB, "ptr", 0, "ptr*", 0)
	Local Const $hCtxt = _GDIPlus_ImageGetGraphicsContext($aResult[6])
	Local Const $hMatrix = _GDIPlus_MatrixCreate()
	_GDIPlus_MatrixTranslate($hMatrix, $iH / 2, $iH / 2)
	_GDIPlus_MatrixRotate($hMatrix, $fAngel, "False")
	_GDIPlus_GraphicsSetTransform($hCtxt, $hMatrix)
	_GDIPlus_GraphicsDrawImage($hCtxt, $hBitmap, -$iW / 2, -$iH / 2)
	_GDIPlus_MatrixDispose($hMatrix)
	_GDIPlus_GraphicsDispose($hCtxt)
	Return $aResult[6]
EndFunc   ;==>RotateBitmap

Func Startup($bMode)
	Switch $bMode
		Case 0
			RegDelete("HKCU\Software\Microsoft\Windows\CurrentVersion\Run", "SysInfoClock")
		Case 1
			RegWrite("HKCU\Software\Microsoft\Windows\CurrentVersion\Run", "SysInfoClock", "REG_SZ", @ScriptDir & "\" & @ScriptName)
	EndSwitch
EndFunc

Func WM_COMMAND($hWnd, $Msg, $wParam, $lParam)
	#forceref $hWnd, $Msg, $lParam
	Switch $wParam
		Case $id_Black
			$iSelection = 0
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Blue
			$iSelection = 1
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Indiglo
			$iSelection = 2
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Mint
			$iSelection = 3
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Pink
			$iSelection = 4
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Purple
			$iSelection = 5
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Red
			$iSelection = 6
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_TDark
			$iSelection = 7
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_TLight
			$iSelection = 8
			_GUICtrlMenu_CheckRadioItem($hQMenu_Sub, 0, UBound($aBitmaps) - 1, $iSelection)
			Draw()
		Case $id_Rnd
			Switch $bRandom
				Case 0
					$bRandom = 1
				Case 1
					$bRandom = 0
			EndSwitch
			_GUICtrlMenu_CheckMenuItem($hQMenu_Sub, UBound($aBitmaps) + 1, $bRandom)
		Case $id_AOT
			Switch $bAlwaysOnTop
				Case 0
					$bAlwaysOnTop = 1
					WinSetOnTop($hGUI, "", $bAlwaysOnTop)
				Case 1
					$bAlwaysOnTop = 0
					WinSetOnTop($hGUI, "", $bAlwaysOnTop)
			EndSwitch
			_GUICtrlMenu_CheckMenuItem($hQMenu, 2, $bAlwaysOnTop)
		Case $id_GUIPos
			Switch $bSaveGUIPos
				Case 0
					$bSaveGUIPos = 1
				Case 1
					$bSaveGUIPos = 0
			EndSwitch
			_GUICtrlMenu_CheckMenuItem($hQMenu, 4, $bSaveGUIPos)
		Case $id_Startup
			Switch $bEnableStartup
				Case 0
					$bEnableStartup = 1
				Case 1
					$bEnableStartup = 0
			EndSwitch
			Startup($bEnableStartup)
			_GUICtrlMenu_CheckMenuItem($hQMenu, 6, $bEnableStartup)
		Case $id_Exit
			_Exit()
		Case $id_About
			GUICtrlSendToDummy($iDummyAbout)
		Case $id_Alarm
			GUICtrlSendToDummy($iDummyAlarm)
	EndSwitch
	Return "GUI_RUNDEFMSG"
EndFunc   ;==>WM_COMMAND

Func WM_CONTEXTMENU($hWnd, $Msg, $wParam, $lParam)
	#forceref $hWnd, $Msg, $wParam, $lParam
	Local $mi = GUIGetCursorInfo(HWnd($hGUI))
	If Not @error Then
		If $mi[4] = $iLabel_CM Then
			If Not $bIntro Then _GUICtrlMenu_TrackPopupMenu($hQMenu, $hWnd)
			Return True
		EndIf
	EndIf
	Return "GUI_RUNDEFMSG"
EndFunc   ;==>WM_CONTEXTMENU

Func WM_LBUTTONDOWN($hWnd, $iMsg, $wParam, $lParam)
	If $bAlarmGUI Then
		_SendMessage($hGUI_Alarm, $WM_SYSCOMMAND, $SC_DRAGMOVE, 0)
	Else
		_SendMessage($hGUI, $WM_SYSCOMMAND, $SC_DRAGMOVE, 0)
	EndIf
EndFunc   ;==>WM_LBUTTONDOWN

Func _WinAPI_GetCPUCoreCount()
	Local $tSYSTEM_INFO = DllStructCreate( _
											"ushort dwOemId;" & _
											"short wProcessorArchitecture;" & _
											"dword dwPageSize;" & _
											"ptr lpMinimumApplicationAddress;" & _
											"ptr lpMaximumApplicationAddress;" & _
											"long_ptr dwActiveProcessorMask;" & _
											"dword dwNumberOfProcessors;" & _
											"dword dwProcessorType;" & _
											"dword dwAllocationGranularity;" & _
											"short wProcessorLevel;" & _
											"short wProcessorRevision")
	Local $aRes = DllCall("Kernel32.dll", "none", "GetSystemInfo", "struct*", $tSYSTEM_INFO)
	If @error Or Not IsArray($aRes) Then Return SetError(1, 0, -1)
	Return DllStructGetData($tSYSTEM_INFO, "dwNumberOfProcessors")
EndFunc   ;==>_WinAPI_GetCPUCoreCount

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_PlaySound
; Description....: Plays a sound specified by the given file name, resource, or system event.
; Syntax.........: _WinAPI_PlaySound ( $sSound [, $iFlags [, $hInstance]] )
; Parameters.....: $sSound - The string that specifies the sound to play. The maximum length is 255 characters. If $sSound is
; empty, any currently playing waveform sound is stopped.
; $iFlags - The flags for sound playing. This parameter can be one or more of the following values.
;
; $SND_APPLICATION
; $SND_ALIAS
; $SND_ALIAS_ID
; $SND_ASYNC
; $SND_FILENAME
; $SND_LOOP
; $SND_MEMORY
; $SND_NODEFAULT
; $SND_NOSTOP
; $SND_NOWAIT
; $SND_PURGE
; $SND_RESOURCE
; $SND_SYNC
;
; Windows Vista or later
;
; $SND_SENTRY
; $SND_SYSTEM
;
; Three flags ($SND_ALIAS, $SND_FILENAME, and $SND_RESOURCE) determine whether the name is interpreted
; as an alias for a system event, a file name, or a resource identifier. If none of these flags are
; specified, _WinAPI_PlaySound() searches the registry or the WIN.INI file for an association with
; the specified sound name. If an association is found, the sound event is played. If no association
; is found in the registry, the name is interpreted as a file name.
;
; If the $SND_ALIAS_ID flag is specified in $iFlags, the $sSound parameter must be one of the
; $SND_ALIAS_* values.
;
; (See MSDN for more information)
;
; $hInstance - Handle to the executable file that contains the resource to be loaded. If $iFlags does not
; contain the $SND_RESOURCE, this parameter will be ignored.
; Return values..: Success - 1.
; Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ PlaySound
; Example........: Yes
; ===============================================================================================================================
Func _WinAPI_PlaySound($sSound, $iFlags = 0x00020010, $hInstance = 0)
    Local $TypeOfSound = 'ptr'
    If $sSound Then
        If IsString($sSound) Then $TypeOfSound = 'wstr'
    Else
        $sSound = 0
        $iFlags = 0
    EndIf
    Local $Ret = DllCall('winmm.dll', 'int', 'PlaySoundW', $TypeOfSound, $sSound, 'ptr', $hInstance, 'dword', $iFlags)
    If (@error) Or (Not $Ret[0]) Then Return SetError(1, 0, 0)
    Return 1
EndFunc   ;==>_WinAPI_PlaySound

Func _GUICtrlMenu_CreateBitmap($file, $iIndex = 0, $iX = 16, $iY = 16) ;thanks to Yashied
	If FileExists($file) Then
		Local $aRet, $hIcon, $hBitmap
		Local $hDC, $hBackDC, $hBackSv

		$aRet = DllCall("shell32", "long", "ExtractAssociatedIcon", "int", 0, "str", $file, "word*", $iIndex)
		If @error Then Return SetError(@error, @extended, 0)
		$hIcon = $aRet[0]

		$hDC = _WinAPI_GetDC(0) ;thanks to Yashied
		$hBackDC = _WinAPI_CreateCompatibleDC($hDC)
		$hBitmap = _WinAPI_CreateSolidBitmap(0, _WinAPI_GetSysColor($COLOR_MENU), $iX, $iY)
		$hBackSv = _WinAPI_SelectObject($hBackDC, $hBitmap)
		_WinAPI_DrawIconEx($hBackDC, 0, 0, $hIcon, $iX, $iY, 0, 0, 3)
		_WinAPI_DestroyIcon($hIcon)

		_WinAPI_SelectObject($hBackDC, $hBackSv)
		_WinAPI_ReleaseDC(0, $hDC)
		_WinAPI_DeleteDC($hBackDC)
		Return $hBitmap
	Else
		Return SetError(1, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlMenu_CreateBitmap

Func _GDIPlus_Convert2HBitmap($hBitmap, $iColor); removes alpha backround using system color and converts to gdi bitmap
	Local $iBgColor = _WinAPI_GetSysColor($iColor)
	$iBgColor = 0x10000 * BitAND($iBgColor, 0xFF) + BitAND($iBgColor, 0x00FF00) + BitShift($iBgColor, 16)
	Local $iWidth = _GDIPlus_ImageGetWidth($hBitmap), $iHeight = _GDIPlus_ImageGetHeight($hBitmap)
	Local $aResult = DllCall($__g_hGDIPDll, "uint", "GdipCreateBitmapFromScan0", "int", $iWidth, "int", $iHeight, "int", 0, "int", 0x0026200A, "ptr", 0, "ptr*", 0)
	Local $hBitmap_New = $aResult[6]
	Local $hCtx_new = _GDIPlus_ImageGetGraphicsContext($hBitmap_New)
	Local $hBrush = _GDIPlus_BrushCreateSolid(0xFF000000 + $iBgColor)
	_GDIPlus_GraphicsFillRect($hCtx_new, 0, 0, $iWidth, $iHeight, $hBrush)
	_GDIPlus_GraphicsDrawImageRect($hCtx_new, $hBitmap, 0, 0, $iWidth, $iHeight)
	Local $hHBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBitmap_New)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_BitmapDispose($hBitmap_New)
	_GDIPlus_GraphicsDispose($hCtx_new)
	Return $hHBitmap
EndFunc   ;==>_GDIPlus_Convert2HBitmap

#region additional embedded files
;Code below was generated by: 'File to Base64 String' Code Generator v1.12 Build 2013-05-17

Func _Alarmdpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $alarmd_32x32png
	$alarmd_32x32png &= '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'
	$alarmd_32x32png &= 'fROwKqCkpASjJ0SBzSCVSqGnp6fpRW5FhoYvOiYhPfTzleTgwUNsQcEFotPdJwPQaDTk+PHjv6gGjAxBBwSjQcsTS7KFoEgsx0Ty4UeTubVrN5CAgA8+sb6yfu0JNit4zpxjx38i+BJik5OT+TJD8E7U6mzS0NDAE7sg6e3tJYOB3Y6327bv5AIDg3Cd2NvOzi4yax3+yjNMgCET491flHoqnaSkHGbv3r1DsItZhRgMBp7t7e2kv7/f6riq6gYKa+TH+Dghq9esMy0KWUbmzV+8weJc+CKvERtq8Ob7ODfvovFkqoqK4AoLC62dEEPO0wIqwjqXkZlJMpHXrlWZp04LJuuj41p8fPycXuaRKkAR9mgVn86YvfPqtRp8eGjZdVFfcUVFF2nI+Y5XW1tLEHwHrLhyhTq3ftZqy83hEWvZ1ZHRJDT0i3WDdv+8MrSWW69CobDX67skkZERyUCE/YsWhTIXi0rMWVlZ5srKSkBa/zNwLAtXr14DjA3RlpebT6SeQT3o0Gw6nJZ2fKelyXHwEmCQcsxJd7QBjo5OCbt3J9dq8orIsf+eNn//w7/Jjh2J5pycHK6ktJTLzDzPbdv+N3Pid3/HkMeSmJhN7Pr1sdVOTs60hkXYfUW8iJeEEKnA4/DA8NEn9vKA9yYc/sfuvbeycy705eUXkbTTGSRx5x4Sn7CFxMf/lURviO9duTLy0siRoxaOH//+lpkzZ39LN4O/V/Jd9xVgg7RDEW7IAFqhyBX29m/8BRPrwKRJf0ydMSP43JSpQSpf398fcnAYlgAAi5EzkB9Onz4rzdNz9Gc4tkUR0leIgvU4pMhhKMIL+QGOpyPnWpwto6Is9gt0FI7XPh0HOju7hs0KnrsPxxKclzwl4CUUCSxCxEgZOrGjpHmCVkYIofN8RSINOO5FGtBpD1o9znFoWSTa1wdjORoJUo60Rw5F/sZihyCVSFukxHKMzLN39noQPGctYrXPwf8ADCu3Z8cbYxUAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($alarmd_32x32png))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Alarmd_32x32.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Alarmdpng

Func _Exit4png($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Exit4_32x32png
	$Exit4_32x32png &= 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAG9UlEQVR4Xr2WDWxV5RnH/8/zvufc03tvv26D2otQkA/LRwBr+JiiHSxkzllZZBCNc+LmxDhB0WoaZLAKg4gLm9rIRphjiWaOSNkHjVa2uKlzgyEIgclIClIRC5R+Ufpxz3nfZyX3JC2W3txNt1/y5uQk7znP//yf8/zzkojgIuH1/woRQQ+8GYACQABsuL4oCAAjjQUgOvx6tLe3gwAmZnT29JiU7yMScRFzXYIIGyvmv65IpMAsKRHb3dtrLDPiSiE/Hk870NHRgbKyMjrZ9KlwYDBr/LiZ44uLJx9oOHZg36lT77PrmjzHYZPukyBLFKAMke0MAmO6unCV4ySmjBhRlvD94vqmptd/U1fXDBFBW1sbx3JzkYxGJ9SuXPFW6o9viOyqs51bauyri77x9qR4fF7Ypn4LM6MG7NNlrntrzdw5vz+28qnUu/d/t/eORGIzgCvq33wTEBE+3dyMCcnkqBM7XjsrRw+Lqf+D8bf9KrBba6z8fIP0Vj0o6yeNfdkDrgARNJEiInx2MRFpZpXWCcz2vPnbv1y+L1hTLZ+sXGEemjLlNQ+4HpzWVl9fD40QUspLtbRotDRDujthO1qBvmVazhrqbkfVzDF3l3P3jfcc+uTbDYJ3FKANECCE085QIGJGEU2uLBm58c7ZN87zEgk8u71294YPDlS3AruYOdAABUD/+LW1tlJufj5yiUqfrbh1R8dP1xnZvEH8NY+a7mV3md5vzZULX5voy+ykNI7J7blJ0WKEPQZA4RUKcO7zIqv3Tyzt6bj9NtldfnPXTTk56wAUMTMUM1HYydCBtIDW1lYUFBQQQkq8yNxNs6f/qXvJApHv3SJdFVODjlnD7ZmJhaZ1fJ5pSnpSoagSAJyweAlh0i9z3D3HRybl5LQp8krJyJPFwCIApJhBACG9cFkB+X0OAGCtNYcb9GTHWVBbmjxobiiR85OLzMkxucFHSc80XhkJPi50ZD7TCgC4nWnJ3z3nwpFYjhxNFMq63Pj+CDAdRAh/CELIZwVoXIo1xoAA7sMeCvztdxw5Vf91Vz1cnYhUjVWS35yyJhUIaSNYHeGVc1Jy2zzGLGOMGAu82Nux6/nALGGi4yzCBsg4ugMdGJSITFCKiAEgDyhdE1GvN+ZpORpXdr/H9gOXzRFNsofh7yWSe5i2ARgWxihjEIMcyCwghBTAnNbFM5gWv+XyhYMOyT+Y7HuE1GFAHif6M4CoHlQ8o4CsQkUsICRwANg8QLQR1zcCa0VYwD0E3KJo5jVENwRpAYQs4SyynAggA/gPMD3zImFrzIoyFtYhcI4iBUXBaA1vfYS3uMAICxgC+HMK6P8SC6CKaWsl8GSLkSAlsDEmfproF9WCF/Jd1r0Op8pjquSJHPVC+GLJUkDm4iDwWqZt3xG595wVXwAqVKSeA3b+1kplrZVlj6Tkh57LrvE4tWyYO7/c5UcMIGFAZYQzFReAniZ6daGVBecEPgiqSJP6HdGhzX2FGWjTgKoLbPWDHcETpNkdVqCxYbi3OgpMMBlbkVkACyCVTJsWWflmC8FXTDpfE/+L6fxaY5cDOC7pTLcaULt8++Mlp3t/0CWEGQmn8LFCd204yoKQrHJAEykAWMT05IcE2U3w92qSizN/KEfJ9UxVoXJCP6RDN++P6+dlSp6cuTYuk5kWhntVtmPIAWAmEM2uBNZ1EYnWrFiTKYowbwqk7n0rNWrwOU0CQBSBtnQGy59p7KkbFlGoKoo8BSBPCAYAZWwB9Z8B1eNMG/MYCpqsdgh9L1N/E5z+mW9XAei06b0yKC8EBIJZ1ZZ64I0zqYY7C92pX9F8nwigAM4ogMPInePohTfnRqd3O2w8h1Q0wujUhOous94A+xggGWLEBLAsUCng1GOne77flrJYWuA+BKDQ4vIu8KXPAxVXXXlX7jWjEMmLQXvaFOUo+nWvffewlZdC6zNiAaMA'
	$Exit4_32x32png &= '9aFI/dozPTVfjerxM5gqJF2MhxJAQdr++HXXjrtOjx2N2MgkeYUx5EQ1zgAnAJxHv/UZsaHOmq5g1cELpvnumLM4bLMFQJd3gAgEROJXJ6Pe6JGIjhlF0ZLh8BJxiOIwlJAVEoZQALSubO9d/iWmGS4w2gBCQ7VAEUGAc03GfhwfNxZ6eNLkjC6xKE6iIWUbkIaQJQYwDNCuwL68vSuovZpoDAAM5YCQiAKAl97+6ysoKkLutKmITZjovHdBtf+lO6gDEaxAkD2wYbs2+ubhEyJ7Q3csBqAv3Q/s+KjxuaU/+sm4pRXz7j12+J9nH33nwCqfaI9mghUSwn9GONvnLSA8IIiMMSCiIQ8kDKAUQAm+GDKfCePxOHbu3Anf90F9MBEMcIQJICuw+NzIoPZYi2nTpoFEJNNZQcL1P+PfYFsHCyDHfS8AAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Exit4_32x32png))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Exit4_32x32.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Exit4png

Func _Alarmwav($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Alarmwav
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= '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'
	$Alarmwav &= 'TcEh7UFTkECJQQOUQgXDKsEN/cEAmMIHw1PBScNuQSTBFo1DgJlEP8EhkgCeQAT/QQxBBsFUR3tBC8MlQSjDPv9DbUMDQRLBC0EnwQ5BP0EM/8EDQUdBCcEFw05BXsG3QWNXQRtBdEF5kUAgksABmP9CU0EGQRDBtcV8QyTBAUNLv0NDQQBHG8VtwZ5BCp3AGvXBF5jAFJdCrMEOw1bBB/3BMZFElkE1wS5BEcMUwR7bwTRDNJZCJ0ExksLnQVz9w2yZQqnBQsUNwwDBg0Fc30FMQSfDXMGIwWuYwj1Bh/9BA0NjY1bhKSEKoWhjLKEAEeEgnQCJoAKkAGgAAA=='
	$Alarmwav = _Base64Decode($Alarmwav)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Alarmwav) & ']')
	DllStructSetData($tSource, 1, $Alarmwav)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress, 25644)
	$tSource = 0
	Local $bString = Binary(DllStructGetData($tDecompress, 1))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Alarm1 @16kHz.wav", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Alarmwav

Func _AlarmBgjpg($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $AlarmBgjpg
	$AlarmBgjpg &= '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'
	$AlarmBgjpg &= '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'
	$AlarmBgjpg &= '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'
	$AlarmBgjpg &= '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'
	$AlarmBgjpg &= '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'
	$AlarmBgjpg &= 'KyTccXXCVkQrMGyz560LGu6AAMzR7wtAKzMiJayWXKZ+fkoKIZ+CEG0wx+UdLQk1jn5wKsRw38KAm15SBesWZQ+vmoH2lEcLgG8/BIKw3MYa6qbjvPzVF5l4vmIxs+CDJdqa1j/qAW6fMtYYZQwEBsH4XkwjiYLZlLVR2PHyyF4oxirdM8+DbD2K8TTjHNJNbSH2D7yHKF3MmXVS6+PkKBa1EtG4uak8afsIhVXIzSClhLdAvbGgMm0CVGKwstyYU35gDD7btYJJlSltr5GDJE4uKhrVIqdn3EmrfmJUFGyANQIxOALiKCm8w+DZ1QSmOr+8EJ7RtniYwtuy+3mA0+KCJQQ0y4xxLTFuYZTzykjR2iAIzNuiWR8hsZlRihYkbpq8XBsvqVvtL8wuoNgntYNu1HcxmS48j4qq2jjiZbJYQOYBwdAoHaEw8xVhQUwoLzhVEphJNlUdbZC6TXeb6G52gAcMUd79KG0JqD9xtqx8Rc0qedAoNBiWOZGDaYQuGCPw140yoNBSwYcADt1IBGJZbtuVZJBmaleggCTBcsrCajEx5IHaL7w49tS+h7iVBFlxOFgwB1bCPzHVLe8XaqeILBDvD6YBKBKO0AEMkTVzlgBawh0XZwy9Vp3mIunzBHTfwEItLEJoA6hEAJylaxD+lpn0eeiOQVUN0UbS1B9ImWipQB+xLb6VA1aEIAAeYmIFGWER8bFAUF8sxXM2wv2GfQpWZSsgpCFyqJ3R5lZRMp9gmTKOpSSyyYXMjyRT7INlnt+CibP00dUTUBFwONYY2fZuGk7HoclMJhVo2V+RED5ipguBMVABCBZcL7xtkO9zPvXFkxUCu2EiR+4ctH3ClCk0xQTFE9rjYxGQj8S1MTYg6ggU9xuBUUJe0h9QNgWccE2ND2uOEePbKkdp31SYPEj26b5Ui0HMFL5hGcnR3GBuTO3jiXZbTHkGZ5S+kh2kslhoHMxE9MVOJm2GTnBUWt/dHL/pDmSHdgwjPMRpZi0stw4lEG+8pVURoVBL5Z9MRaLY65NQ7frGvioOZREAxd5QIEvPtoIMOe8WRQnusLqw9IBkBvMtnSQWsCkR2wUDaR5f3BQzC8AjWq4lpaUvlasUl99yKI20tDa5fCiAZbe5pGDGAq7GYYcr0C65lgtdovIGsRqsjB6lDU4dfYgKzTzHVze6ZRLckDNPD3ApxdTDj4jawsAMCocvRBtBI6xFbMApLhUTRECNMAWy7YQhVChcQPrFosdXzag6mlxP2kQwFhKjVUwU9XtuIxKcwrDTPoNdK5IGbXvvPq3LDvVLq43WW1BSEBEElyISXy12Bw59oG0ETMlVipEhEYhZiDuAGj0AaRmOV7lQMn5Sqz1xEJtqU9DsuAvuBdxPeip/EdCIgJ9TQXVzLHqNRxnBPHMJgidWIYCdE5upwUdxgEwpcsSpWIGyBeYlvt0rxgYY0RKazDYfZNtDKUFzRA9IdgQY1VMM092VRo4uGRThY3cBmbFPMNy7hgsG8pYhqoRXtW3mDDoOhtO8WZYlegaYJ0qXLVYFYGexiH8EK2sOSKUqQodkqrmOy73CiI6mRFfECg6OSoxuu9S5EAA59t2EIFYfuUCaiqYgWQZuT5Z/yKGVPsiZDIBblROzE3LS8Hc2DkIW6NZ9AE2alpHMFPoSNkfiiTwvBWcKgRC04Sp3NYiE5hx9IDDUgAUFegGi0IyTVMoE+0oeiUYR4laxZdEOIHPpkHYSyFcRuNeIkCwNVgysO+UPI/RKWCXUuTaXUyHUwKA7eg3y8RG4VFUqLOIidbl3FZRGZJOhYZWxhskRY20ANeryITB8Wxg7hgPYViz67pKWVe0sL/JKUdQABQTcTSvGBxK5elBCZdHIELU8xjEUxcuxtEPkr9KWVCQm4gIWW0OZjiIpxFEe4jAokEeLFhwiPb2HUrdJUVMjcnsAKZoh+yD0/wDE/nggoFHVBKYKivhFus4agyrcAtju6WAKtqjiJ4yqK7xn0kyd'
	$AlarmBgjpg &= 'QkGiNWtOZ/EqKZfUvv8AiENOXecbzCiKhCTszFsDVl4uHWb+fWCIghdmDZftNzjGl9KqnzjExR1DoQOjLQwIOIuIJzFKu/QhEYkbtmYG4tsTYmC5MuaI2aufUtaX6iS3iKSrzACRPMHA8d2EAVwYrU4yTXiaIRtIIUQpJYJYPHwUvSkE04HoOszxLV6RxcMl9BYeJcG0pW+YxD49KDJcLQpdTI1akWiKo4MFsSCRIWo47mgUCq7FHcwanaMN+1Z7HajslnHDZKYIWGY09CeNyagd6PRzHiWMwGzvDQHb1qEuyE0h1xGGCGOO4qVhCQWmXVmWSyG6go6Is9q1GIaetBKY9JXsipuGNebQ6ICsZQRs8SomAlINR1csz9hLyePYtwcR6RLiJTBqZoQVAI2ZfWY7qG6mkNTZ7QwfcAuzmeYYaGp5gnQ+lEdjLO0sy2Wh11EI2QgW2klyJirYCF5lYjDXro3joFyBpegxSAw1EcuYrqHUOJoiDe/tIAz+HohRrMLXghV2ekzBKllVCA5tOpVW4h9axmKEgBeMwLCeXD10Dx0SiAz1tcDZErcxExEOOhLHPs4EqECLsIrMsgI0JUN6TMsQ5N9QuVEMq4gVVcEMCCJY9VJA94cAnEtYo5qWBZTKrFJeAT1bIJIBJmpTBXGvUNgRyVKgxK6gUQeQZ9Wezh6KY0s5mTW7itoqqio5LdurLqRSwq2sM5CA/QQQWa9DcNvEWZF6YO0UAK7wQEB3QmlMG0ksmyAF0x1g3EewowZzGXKViKmpQRURSXRAor2mhOqEbGOjAS+EGFhMlvfVWWdolxmbjiWjyww0vM1CFt9vUJQM/wCVozYhy2kFysvVlIbiwaBy1WGP1X6jtr9TBtfqWi/4lT0yLhABGkXEy/b7ZaUYlUw7joCLmPrCZhFJXjqCliTPIayHhL+ID58YgNJaEESvaodkU2I7g/Udj9Uf/jR4h+pRoRPQgtEQcQDiACKiU4QC5HuWEIlrq/Oxl+FuPRfkK4q0kahWUQkbj0MAghLvUB2B+CSE6CJQMtYyqbhg2X7aWVB0tewbhYxtpszEqloaozRhKhIM24PuZDFt4+AuhVcEHMbwQigcMy9x7LqGvZrpdbi741C6trEejyoKB0eBgYlMMjDTa7QxFu9e7UdAC8wBzL06hxAgS9Tr4YEXtAqINPqGQ3uKwnRLKYOaDuU+cdth8Qq/yg2HrZLPUoQwhF5hWzHSkQavJkgghAlBbDBsv4X8sMBoh1MxLcdTfLaxErymBlBlIYSkGzDWyCwgZVl3cTSWMx6lpmC7iG2c9H4GayW2YLoGnmN8FcxlBUci4IEJ9uT68+Fe5eIAuLYaOiVb0Wn51QEFxuzCFgs30JYxvxKrfqOho7wbAM2f2oHov5lTiYkBAtnX3GbkDiFDZkgKhCbsytEpCO7QIHQaRn1D3efQCLHIWMEDReSAaeo8bsh9xHEDIQLohWf1lhS+6Kl3xLxbITRj8zEH7IOZc5DhtrMCObmHTVEGdTns0KJHQZUCHW59nu90Gz0oFJcAUesVb5RTFBHGxirKy3mEkD1BDDDE5sgpssOdgtnEhBBL6Mr92Opap290K7tVHQ7IveL3l1dMuoYYYekTJshKWDNEIHowRwSZnqx4f//Z'
	Local $bString = Binary(_Base64Decode($AlarmBgjpg))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\AlarmClock.004.jpg", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_AlarmBgjpg

Func _Alarmpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Alarmpng
	$Alarmpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsSAAALEgHS3X78AAADMElEQVQ4y1WTy28bZRTFz/2++cYztmccN56JrZpM7D7STQQxalVFqIq6YcUG6L5/ATv+AqgAIbV7hARiA5F4r1CyIzwSSDZtivLqw0mdOk3i+pWHPTPfZdEklLO/R1e/cw5prUFEmJmZQbVaxcDAgDE8PHzTMIzXhZASBMRRzJZtrZZLpc9s2+4wMwFgADBwrGazKev1epzJZN5/8qSWJaJPwzDsEkFblpWy7eQ7vaOjW5VK5T0ApwbixECZSpimif39g2BxceHr5ZXlh0/r9d1a7ene8vJK1UyYXz56/DjNWuNlnRhQ2A9DIUQyn8+/Nnn9+sd7jcboyuqaflSt8oOHD/x+v3/b9/1re41GiYg0MwsAMIiIAHDCsrx3b9z4ZSQIKr//OacvXRz9PJPJEADVarU6DHpjYmIi0Wm3f2s8f/7mmWx2iZkFMbMBIFpbX/9CmebNrVptv9/rWcWzRRHrmFhrRFHEa2vrOud54dli0er1erOjF89fIxJCMLMGgLt3761OfTP1s5KGNTY2Jg1lsOu68ZnBwdjzPH35ymWh48ianp6e2dzcnHvBEVqc0FxaWvpoyPfzQTAsm82mJiLRarXk1taWlFJKK5HA+QsXkB/yx86VS58IIcDMJI4jQRAEr46Pj1+JtYaUhlBKIQbQC0NoIkQApdLp+NLoaP7g8HDyGL48gQjbtgfjOIIQQpumEgmlsP33AvYFoey6OGi1IXyPE7aNo2YzdxojMzMAtNudXdtOwrZtoZQCAyiVS0h6HjpCwH2lCOWkKWknQSR2Xu4BA0Cn2126f/+fe1EUwbQsjX4f2XIZlatXIZRCwnU57Wbkxka14WbcP47vTyFKZta/zs7e6nQ6cFIptrPZyBwY0JZSulAoRE4qFe3s7GB3d+9OaWSkzsySiPRJE2Pfy0nDkFPffvf9B/Pzf0nWmgwpBdEL0PNz82phYfGrycnJD48/j/83piHfi8+VS4oZ9Y3NjbfDMHzLshIVrbUMw3C5vr39QxRGg8+ebdtBEBwyM4joP4O04yCfLxhuxv3R97xtx3F+chwnSUTU7XYPcrmcrtVqhUajIYMgOB3Tv6BxZbsBdrtTAAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($Alarmpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\stock_alarm 16x16.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Alarmpng

Func _Toppng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Toppng
	$Toppng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAC2ElEQVQ4jaXST2hcVRTH8e+9773Je5nMvNhOokmaSUpoJVAT/xQjmFD/oG7SRRB00UhbKAqSVS3NsrHr2KVgNxVKOui2UBWKKI0QDQpJCza0moyTSYY4afsmM/P+zrsupCM2deVZXjif+7vnHqGU4v+U/rjDy6UPxY/VL16IVXwIQAp5a6Tt3Z/fe+rTXbeJRxN8cKv9qLtmfdKrDh+wVRYpJBVZIM9Pd8y++kefHXpw9T+BEz+kTydLg7OvZ48L00j+C/aCGtfzl1S9e+XM5y9XLuwCTi7YR7RCz7dvDZySRjrGtEyEBKUg9hWe5xG5kq/uXozJll679JLzPYB8KFU34/OHs2/IVF+AkQ55srWPTCJLh5Gls7UfLRli9wWM9L8pq5vx+Yd9EuDYtT2ZvYme0X0DaZRWRyZc8o15doJt7nubFOU8ibRLrNXpHbDZ29IzeuzankzzFwI33N/d2yWl4aIALwwYNN5mMHMEgKXSdZbcy7S0RSS1DvZ1dsmlfHE/UJYAkYevGQFIl2rk8Kw1ydPp0eYAn+l8lef19ykWSjxQv6InIiIPv/kEU9krW06hElBC6GUW/Bk26rebQP7ebRbis7R3BBhayJ/OesVU9koTyE2u+2ur96/seGUsI6QtsWu36LBtOtttGqHi99+2r+Qm1/9JAOBty5lv5m9u1HyPpGGx7Rcp1VbZ3FmlXCvSZlh4YcDXN25u1Mti5rGL9MrHyaEnDoqrz73Yne1OZbCNJCBw/BqlWplfFot/3FtRR787V1veBSwvL5PL5cSN6sV2o8s9bfeLd1rS4gCAX1F3nDX1ZbBhXRhJHHcmJibisbGxv4Hp6WkxNzfX4jiOFYZhaxzHllLKVEqZukUrQOTiAr6U0pVSurquu6lUqj4+Pu4JpRSFQoHZ2Vm5uLgot7a2pOu6WhRFstFoCABN05Su67FpmnEmk2kMDw/HU1NT8dDQEH8BqGdHBP8mUFkAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Toppng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\top 16x16.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Toppng

Func _ChkUpdpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $ChkUpdpng
	$ChkUpdpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsSAAALEgHS3X78AAADD0lEQVQ4y12TyW4cVRSG/1N1a+xyj0677cQCy1LLYpADJBILJAxCYhF2rHkFdrwDa96CLSxYsYKIEEWmJUhIcIzsjqfu2NXVXdOtuhMLsEV8lkf/+fTplw4ZY3B9jNEWF0VYVmlPG+27zJ+H3lLMbLe+nmXXF0pLdr443hifP/40F/H7ju01A9Y86DTWfhh0Nu77TiPVRlkAjG0xTf830FpZJxd/vzE6fPDljCefhYG33F2KrIYXVbJWf7T9wTfdaLC7yC/67Whl70br5ukrBkkWLz/867cvxonz+UrvbqcVhmRUDGPKkBz1zvHi2VcvZk+OLMOmzXD5a4BgXR5LKdnjg6M7v+6bewKbneXWLeo2V+GyHiquoKEdOOrtirIPfa+RRGH7nIjMFSAtqujRs2RnkvVed52AbGgk8xPkxREMFKSS0EZbBHveCVd2fSdMXykxK8v2eVpuwQ58oTSSrPrPLMKsKCGMhJAwEXPH7cHqE9ty5BXAGENCzXqD/mnfrgIrcBTKugmpHQjVQinaSHkXL6dMrTfqsbvVnhCRuQIoLVkhp8P1W8XN12xFrmVBihyTGRDnXeSyhUUO5KlVNdrdfd/9V/8KUIkimpfT92zHdH3XhmdbmGQC00WEGWfIyxJ1PjdLdnyytbH6MPTd4hJgGWMoLeLBLJsM45ezuMx4ahMzRDa0BHRRQi7O4FbPuVM//cWq05EQQl0ZGKOprDJP5vZPuz/uf9++MdnZ+aR7b73falqY0+HxAimb8+n4z9GDn3//Lj9YxP3OGobDIYgIzACmE609v73x0aG5061fnO6Pzg4uZkFr/rFC2YmCWYaSP0pr59u7b31w//b2u7zRaEAIAcYYaDweYzQaWXt7e9bZ2Zl9EV945/HpalJM3ySmVkQtE5eWnjbc9tFyr1/2ej05GAzU5uam2t7e1qyuaywWC8RxTEmSWHmWa1nRxDPdmARsl2AIJLWCKoqCGGPkeR7SNIUQAiSlBOccZVkS5xycc+Kck9YaAOjyw4kIvu8b3/dNEAQIgsB4nod/ADr/rx2P4qaWAAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($ChkUpdpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\system_software_update 16x16.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_ChkUpdpng

Func _Homepng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Homepng
	$Homepng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsSAAALEgHS3X78AAADXUlEQVQ4yyXTyWucdRwH4M/3t7zL5J0sbTJpQhectFS6GJVcKkVoRQWhpRW8GfDmSfAmePIieG1FEA+CeOhRoQEliYKiXdDUUtKY2CRkkhAzySzvzLzzzjvvb/Pg8z885JyDdQq5jZmzhF5qrPPily1vvgNHF4lIOtgKswNzAY7/kPNt1bN7DE7Ycf9VkHMOWmuWtFOrnRo+UL/eCiP9bijGGIMEiOCccn0TkzZmKeTH3tdaL4EUnyxeNuSco243dVuVzdF89JdFP1DTw+Kicc7CupwsDCQbcJwC6uh1luTVfth64zrlw/NTZ45zBoBU3+KQfv6qY5anmTqSp3mdt/sVbo1g0h1hAU3wEfkic6qgM1Xz695331ZrlUmtjGEArPaqV2M8vJmlyqR506t3NyDdOE4MXsVEdAlD/hloo9Du7YssM6qtVkv94O8PVU5gALDTevh2nOyh0zt01fYKxrwZnD56DZsbW1hYWARnEpw8pP0WGt113urE0IX1a57PJAOA3frTC520iSRJ6FThBsqjrwMAiAi+HwAAjGIoubeQxj4laQPt/s5Jx3unBAAcxtth3K6DR4KWt+dQLl2B4ALlchlTU6dRr9cQ11MsV35C3WyB+SmyXkXmOg0FAJAtHPxb2wORckZLcCYhBMfjx39hdXUN584/jyS2qLbWkBQ2oFpA5AUdjxXrDACmSpd/i2OLuN12WU8hTXvQyuD2rc8xOzuLne1dVPeraDY6SNLEtpIOxgZeeuLLwp4AgBdOvXanKE98XD3cGSyg654sLxFnDI24BiE41p6tQGUMdaqCF+GK4iyeG7v0tYUGOef45v4jc2/1zgff3/vitu/nZkBGTApQP1NQuUEhkmDkuSAo2DAc4ZPDM3dfOXfj+oWTbxI55/DN4ifsx6Uv7YA/+FmaxR9pNF0YEsJQusALwBGS5EV47CgZ7d1/uvXnzfLE+eqn782TAIBO2rAbe9XJ0nD8YCQq3Y3k2SvkKGIZJ6clSHgwxNVB1lzdPXy2oK2a+eOfB7/fX5mLBQAwRggk+gTSB/HOvBT+o4JfHPdEMEQgrq1Ku1m7nuVpQ3CRcMaTKCA1FI1CAMD/pdEAMC+4jIzRYatbE86BAyAAjjNmpZA5gERplY5EJT11bBr/AbxAzh+4PNbcAAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($Homepng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Home 16x16.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Homepng

Func _Aboutpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Aboutpng
	$Aboutpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACXUlEQVQ4jaWTO2hTYRTHf/fRpGmbpkVabbWKpSpSF6GIUPABKlVwFETd3AodRUEoOKlzwU2nqoiTIuggFkFwUZcSan1X7fuR3Nzcm+Te73yfQ2KaUfBs5/X7/zlw4D/DAjh++fZu4A4w0ti0LYswFgBamhy0MX9bL4DRqbtXv7sAhTC6NzZ24djgYH992bUhVwTXqeZKoLMNlIZs9tvIxMSDSWDYBfBDNZwPMjx6+qVqy7IoBBEdLUluXapCr0x+xQ8V7a0OfT1b8EN1GMAFWPel6ceiR64Q19QtvFCYX/XrjuaXS8SWoaKaiGSDdV/sOsALYlbyFfJ+hOtYFEPFcjECbbH9/BSpVoedfWnSKYeVcoVIDF5QEwNQXowfRHh+RL4odGVc3owfpCOTBODo9ff8XinRnUmgjcGxqzsANgBLIXNrihUvohwLuUJM5+nnfJjNAzB6qpfPn/LkixGrXsTcmoKlcNMB2rAeRJRzEbYLa8ZAoGjvbQHg4et5iDUbXkQlMpSwQZsGB1qRNAobhS2CtxrSPdDGQDoBwJNXP2nudJA4xqE6i1aNAI0SQYtgjMBqwLmTOwB4ObMOH/OkXBtEEBGUCGjdAFAalAGlsZSBQoUzR3oAWA5i2NVGWwLKocJWpj7b4EC0VgojgigFXSmu3XwLwMWhbUw/PoG3UaIUKYxWaKVAi948olRmyosLg6mtVdX+/S1M//KxDt2HVAIKQnpPht6EizKG8uICSCULtWeCvWfhwDgkh6q5AccGARCwnGqt/kuVd5C9AbPPagCagX1AJ/8WOWAWKP8B7pI9rjfgOq4AAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Aboutpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\About.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Aboutpng

Func _Gauge_Arrow_TCPpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_Arrow_TCPpng
	$Gauge_Arrow_TCPpng &= 'iVBORw0KGgoAAAANSUhEUgAAAAkAAAA7CAMAAACe/VCEAAAAWlBMVEX///8AAAAAAAD///8AAAAAAADVAAC5AACjAADKAACVAADHAAAAAAC2AABwAABKAAD////EAADYAADMAACHAAC3AADBAACDAADdAADEAAD2AADkAAD1AAC6AACcvv43AAAAE3RSTlMAAgdmAQ9h/QjP/oAE4HwuPOsuId457AAAAFJJREFUeF7txtcNhUAMBdFr442BtImX+m8TgbRV8M7PDC47hm2Mfum7Iu5wIgCRNW9jiRA5tG8LHMEq5U9OisGLr7/qFwbNpfdeZgLW6bLiKf5O3+MC2TCXtxkAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Gauge_Arrow_TCPpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_Arrow_TCP.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_Arrow_TCPpng

Func _Gauge_Hour_Yellowpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_Hour_Yellowpng
	$Gauge_Hour_Yellowpng &= 'iVBORw0KGgoAAAANSUhEUgAAAAcAAABbAgMAAADCcHfMAAAADFBMVEX///8/Pz/63GThvCp8YcOiAAAAAXRSTlMAQObYZgAAAClJREFUeF7FwkEJAEAIRcG3B9kEnizzIxjNyHYQwWEAHnwRNe+Jaee1BvZ1FIJYx5InAAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($Gauge_Hour_Yellowpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_Hour_Yellow.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_Hour_Yellowpng

Func _Gauge_Hour0png($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_Hour0png
	$Gauge_Hour0png &= '4LAAiVBORw0KGgoAAAAADUlIRFIjAXAAGFUIAwAopegEntQAGEVQTFRFGP///wAoPAAeYacC6QAMF3RSTlMAAAoCTzseVgEAAAMHCTQbFB1NAEYnOlQ5TKvyBFB5ACJjSURBVAB4Xu3SSQ6DMAAQRFG3DenRIwCQ+x81mA1SXwAhLqkWb/9DIABCxHifKNxCFgAFFcYpZCi55gACjFNShl02igA80mz92y3rVACEerSzHRXiowB9S5+07f+jJQBXgSvE1/OW5QCq80Wurf0AqYCQCmNgQcgsgUwASUVORK5CYII='
	$Gauge_Hour0png = _Base64Decode($Gauge_Hour0png)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Gauge_Hour0png) & ']')
	DllStructSetData($tSource, 1, $Gauge_Hour0png)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress, 272)
	$tSource = 0
	Local $bString = Binary(DllStructGetData($tDecompress, 1))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_Hour0.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_Hour0png

Func _Gauge_LSecpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_LSecpng
	$Gauge_LSecpng &= 'iVBORw0KGgoAAAANSUhEUgAAAAcAAAApAgMAAACEmtsGAAAACVBMVEX///+uAQD5AgDoBNquAAAAAXRSTlMAQObYZgAAAB1JREFUeF69wDEBAAAEALBxCCGNiCJrYYIavdKzA26ZAPRP7cg2AAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($Gauge_LSecpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_LSec.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_LSecpng

Func _Gauge_Min_Yellowpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_Min_Yellowpng
	$Gauge_Min_Yellowpng &= 'iVBORw0KGgoAAAANSUhEUgAAAAcAAACDAgMAAAA8HemOAAAADFBMVEX///8/Pz/63GThvCp8YcOiAAAAAXRSTlMAQObYZgAAAClJREFUeF7VwkEJAEAIRcG3B9kEnizzIxjNyJYQxGEAHnwRtdMT08zLGkwXId7TE9O6AAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($Gauge_Min_Yellowpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_Min_Yellow.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_Min_Yellowpng

Func _Gauge_Min0png($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_Min0png
	$Gauge_Min0png &= 'AbEAiVBORw0KGgoAAAAADUlIRFJFAHALABiHCAMAKPcIAFO3ABhaUExUMEX///8AKFEAsR8EWKgABh50Uk5TAAAHAiQTOEABAAAEEjQMFQ4KAB4uDyMiAzcXAAY7Phg/KIsOBAbbACl4SURBVAB4Xu2TVw7DMAAMxSQ56ZNiOwB7dtz/ml0ooADeoCjMLx6AJABViJkJVElh3ACljg1KWLjNlwDc8gKCpW26TQBbMpDsYz/EoQAfdyHhZo5HnAAbfnlYz2t4ewAV6msdqo+ffgDeixf33fqefQDnvn//hf/FfwD0/ZcqnujD/wCUQuEO/aAPfhC9FkvjgVpJRU4ARK5CYII='
	$Gauge_Min0png = _Base64Decode($Gauge_Min0png)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Gauge_Min0png) & ']')
	DllStructSetData($tSource, 1, $Gauge_Min0png)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress, 321)
	$tSource = 0
	Local $bString = Binary(DllStructGetData($tDecompress, 1))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_Min0.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_Min0png

Func _Gauge_TinyWShadowpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Gauge_TinyWShadowpng
	$Gauge_TinyWShadowpng &= 'ubEAiVBORw0KGgoAAAAADUlIRFJFAHAHABghCAMAKCIIeUHKABi0UExUMEX///8AKBsAZ1giFgMQmYMhAAp0YxAZw6crABDStC6BAy7evjB1ZBkAEAjmxTIACu3LNLIgmCfxzjUDHfXSEQEI99M2Aw5xaycRAAW5oRQABb2lFATzzwRlvacTV1MGHgAIABFXUh8eGQAA99IA+NAA+QDRAIt3APzZKAEAGox2AIt1ANYIstO8AAwzdFJOAFMABAIIBgEfAA8LKBAZWwA2AIwRSccr2QcUAOZqA+819q76AAk4/D3+Ey9NACG1ILH0MiaxAGQd82SIz00NAQFmSURBVHhetQDFVWLEIAAFwAAHAeLuuu5SQQCStve/1/YSOwA/g5AknwkJwQCdVKUOB/UCHQB4FLRqVFNRtAB+rGK/BbmMZgC8ELBHprMHAwDLC1PkDOWh1gD1oYR170x3twBg9YMe+v+jyQBMkYXVeqM26wAVnO3O7LYO9gDfi1o+9jidZwA5n09wb/JH3gBciOef/L0K2ADH59f1aIPYwgAVNgGnhBHK8QBmLyXVDtYygwQeeYGKSUVORK4AQmCC'
	$Gauge_TinyWShadowpng = _Base64Decode($Gauge_TinyWShadowpng)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Gauge_TinyWShadowpng) & ']')
	DllStructSetData($tSource, 1, $Gauge_TinyWShadowpng)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress, 465)
	$tSource = 0
	Local $bString = Binary(DllStructGetData($tDecompress, 1))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Gauge_TinyWShadow.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Gauge_TinyWShadowpng

Func _Graphic_BG_Blackpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Blackpng
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= 'POcqW+tpSz3wK2u1x3NGkMsB9c53vjMJn8suu0zHS/JLWvNeeb/E8PC+aQt7/wf4dyjvOHgBN0h1WZ0mmPnxGVhqwRhYyzHXJwrzm+boPc7NP9WGp5cxw1s7Mm6KFdpPpZrpvTysB6OmJiQ2Gd5HABC2V5Nmm+gj0a0v0JNkQcw0QUZe8VQDF4GgVNLC+WXb1n44cLTYs3QK7LgdgJO7SVwLdmLMpXBWPnlmpBnST59sB/AEUPHJSMjxDPlNeHlVh/BOKu1LZxLQquhNaVvzzv7gD/4Ax564uzi6rGNKMoGSqkoZziZ7/23dDIcT/1QZQTV7ps2YBnbAA8CfY2bI5+BlB2s55kaPBLetEVpZDsgvfoQ5IT5hDXcYgONFw9sY1lTuzNvLcaKg3PzoRz9K5SfuM4kO4AXKAPKY1haDsuI+/FZFJ5Qk4I9XoVIvsSRVa8N5vUMIcKqKGICFnqg4p1/IUSUZ2y8qePr85z+fYCkC2VQ+AqtHI24fdRLZrmNSBULHxw25pUqa+wmFizqWfvNJ6TiTaB8UT1IaoTnUmPFRqyobCJVDoOHB5Tf0t/VGcT9ju9xl6/K85N0AjyUas0+BHmLMCdg61KjEO214eZkScRl68T7yotsK6KDAxO9IS6QzXBunDdYWKSfsB1gY4mMjRqmjBiybarybmJTGiiQBaDwzXj6ejedC2v3whz+UTtFJ9V2GbErZUb+FDgkgoHWcs6ikRjeZR015P4Cr/D1Gn9LZkeTqREjwRYsWUi2MamMkmkDnoHFgxEetqvAU1E51eMDE9XY+yt3dk1cT2Ag7UkxMR+BtmsmvGol28/NyBRQgY+znZRNTIbOfJDEKmao7wdf4jR4LyD0FYSQgjQwuHkFeBfy6JAqtdVSg6b7QIGzGSF1oCJ+AlOhEOkATSwi+BqgAYbsABMnG33QiaNZIzJxFvzcxxUYhUhri7GPuL774Yt6jLwrVjrdftgJMQOmgbeABXIg+QefADfgBR+CJc4hmHmP7znNcHQz2CZedAbi5NCf3c96C4xdcZEX3zwRyTIB1lKVaLTppUZLaPnJtlM3R03/wTBuuxiQNfeWKlZZLeC+OIR+eq6yWpMCde+65id5I0WEpAX4Tj2BV0NVIrBd4/hiOsR7BxSWddJ9Ns4I0lYzahJeOKx1ui2RvQmE6DgKLPD2abCOFk5T2x/H5u7/7u0mh/spXvpL95Cc/SfcvAGuf44zCzD/q6Oxwq9tOASgoFeED3pEo/DDaw+83rN8AShGSt5qQxGN6d142Y0MTqd4zAml+ALURLcb8JIDDpFMoobP6Z6VeKHOiuNf4ieOt545HkifOuWnzJkXmRY2fHpw6wx//8R/HjH6BoopD1oGqylrSVGJC0wAmNn6ULgBQq7BGsMft/hwAnhdOaIT0H7Z34UiquoeytvFgrqxpAwXlvSGg/AjAKv1pjb133j/J0kstqX2CgVq1MrXu2LmDbJ1UEtxMjExsAAmnAsSRtu9hCFow2FSqt0YgzQ815eIi4+EvSFaMg6ZmZtxnCIeLJV7pa3Uri+iHFvW2fuMGKzZ0GxLKOyNYozITCw6VWVSKGt5vi8foBXQV/8Jz/v7v/z5/Y2LjmbtwENXqAJTFAwSU5IAWVkvw5nw9fnpAlwoRz9tZJZWjMYH9fDk7RkCwYpMc2+j9XPlLfCgHz0zHQaqnFLxNm6DkGYk3t9639L5LcsV0dROp3tfUC2rgnWXSfJGm5iZeBccIPBIPpxqAKlmT7IZHj+4z5WJptnHTJiaEgp+1QZcxGiSQl0mYJh69OtDH3+OxlWXh4j48L3mXmOwuuugioikTLdvHCzSOZAYcLlAjqAyjYh09ie3TJM4n0pm4veicpRUHfKyShBegBi/sRqkSyt6lZJtNm5WCBysAT+yHnpKAzqVtJvDD7Tr91nEeDkVLB7uV6C0nzafSIU3huMBoyiuYJpDk5WOPOzY7adFJ3GziVgK6quBusW0/Mb6N5+v6669j'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= 'r71m4H/AhrAes6dPRbIjoQQCeB3AxSxF/UWoRxkgcKdDE6S48OmnX5Qy2u0iQHc6xQqfKtksFanK5FcXtx47iU9d9Nu4HtctLzdXT0vYuWMnmd4XNXMoKQJdgz4i4T/96U9nn/3sZ5mpD4uLCilRZpDv8Vz8hoWG9062P4qmngF8GE6mIxRTB39o7UPMU6TflWxBPii4E9Tw6QyZ5F8uoIufNwG6dxxBX7Ya974ZzVZKI9Kci0YzGdu3WDLGIwboGcyzM3MWVhjMbQICrnIkonIFqyQf1CfWSa+Tjg2iHyvnrC+dSeONb3xj9rGPfSz7kz/5E9ZoOy+yqJTpC4WSNVpuWLkOPJnrnnfeef68RQqzeGwndKXSAIDUZvSFLrJKV7r00kv5njqBBM4PLXYGamlUIrapckPh3iizgZtPMao6HSXfOsCjpnw/ptksVENHwJalRVW/ttq1llKRGoyC1SJHUWXtRVZnT99GrzHufZ/RjX5+aqXyX8yAkPd+tiUJxJwzu7K1pHRZgNKBUw603jotAb/P/umlypZetsgJBBem/gd2a7fQ+7HFSjNv2hHitrIy00V5n0gx6JQvXV1nkuRcVZKzLlwZSaiwAOzXRccXRTgWGwKqhUFMZ6ukfYQ/4KFmXilQIfOxlhixqA7kOyT4gLpgcbnzzruY9E2FH2XSVkK+bdHz9mB6JcNmk+PnuyTNm0h0z9NB0xYbbn5lN7G9NayGHMxvWi7mXLLYtkeNp2P3JaIPxZOwgKgQ+QX+h+dPAPvmN78JNYKrMzVf9IoCMuiDQmFZyyhJVTkKrWVWjFLuSweETrXqC/aUlWMOFKR2lmWux3UjDYqhw357oXUsK08PbByAh3lR9A2guoX3yXst7diytPBMs/v7k+Bav2F9tP3zBzgjelaeeOYw2mN4vIsqhWATjAZ+Xi/RI30RTzd77r2W0rTWStAdxY+uxiJgdzXwUpIqvCy5rqeYgjHdlEY0aeUGCmCYCVFoiACEAzJU4lL/+Mc/XhrlF8GKUiswRbtvPJbQVClL2o6iyzY+ceuTaxnBGCtT4TDixTDytNx+NcncTeukq001iRXtJUtWEXAKz8mEuG7Rc+pTwFZ8emUnjKMu74kVbKEgjhs7TrPmUeGMdoKqoI/hAPQ6CzhIxoSDbLQeb8+01PQ1agX5a4m+7bZ9XfVtlNBNJtFXItHFzz1taQJ0iX/FvTwOF0IptRd9uAG2FxBgRhINiRMqoXDY/mYSm5kdsnFOtt7oC98Vf0wnQKEB+PA6OBrg/N73vhe5e5lU7iTLiHMCcD79y47pc9HyUKYskg3EM4hedWzHH9Ey3PJ6EBwXgDStCwOoJWUBWgQ3f9PZGyVZqF6P0KIwEc7/hje8gRh9hBujOkFcCDT0M7Ux0pzfkObggmcrqqamYrZ+xB0yobs8l+abwaaLbxluItGjTX23eLplh19jgHyWSZX+KNXjBE2a4IpkAnoutnEv1TEdUotRttWf/OQnaPdVHrsq+lMmgYt+46VWXafKlY4SRGQlf0tK7dOEBH8+FB+VbIYPM5Uh7cb3AIoyS446tABfF5pQ1sEr52EadvhiG3Es2PwBOwtmR2rkOAoHHsAFgAcLyraK1DIWIkUvwzhyG4V8HT/fHW3nlRy9JhxggF5kQ8Zd7sLRW+UVDVy5SGtc19AUpLaXKDiDsNGSKIvCBW3ptM64OlaTDBsBV3b5TuLVI5DprDS2lCsASDXZSmV3pMupp5yqDHlfspnvdW3k+TnPygrgy9pEnSeu1dGgvrK16wSYhsnw/8AHPkApa4SY1xtwDsHvkeiM/Ozv/QWF2NJChYoc5Bs9bekG6FEphb5sMil9lUnrTR5wUBiF3iRTYv6J9KNsAulR9HAUD7KQtOAAwoFA+Ca8DvB0US+kysWszzoOzfDOWmZXRxGmziFmNWZCZnJggF8npascNaXA4rxnnXUW5atxspCwAGWq60wRMHqmqnvrssJWDhVnYdHs1h/6'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= 'jC9OKeGzzc122zCGx4wXzgs5wRoNUE3NE6t9oBCLvndgeovfKRmhDCGK68h+XHUOAMjU64CFjkbnADBIWUk2RgcyqnS//lPbKLfs7z3uRyenliPbuCeugxQlthvFDsnJfXA/tXHvbumY6xO347fHto6cHEWV97TI7nvKlMnoORTvZ798GqCQPD+czgEeALxo16BRtKWGGXLtHgRDUkAjZdkfEl1LzC2Fwow1e+t3sK0bb1sIojUx714D/CirtNsLWJN1JfXw3OxoYF+5CuAxBBKum6jO0nuXZhs2bvCAUIhArGfCMUg/+GqphKccM6ZEwl9l5oz7xoAruCsAl3QFcABP7nxACUWJNb9jtn7IzooVwbgngC0HEk4bflfRfDya3A88HulM3IiOjcnOcYFuycJSCHJSBFFGiXuPi49C1N/Tp003SX6UtTlJ8AeakFpswoNgrdzzmSxuebBWHra9e+/upLd5Z8Kj69c/aELnp7mLf23CUMwF7XLRG+36PC5BAw4wjWoIeKVNwl1onG+eXq6kp5TTkBInEx2AYSjEGoCUgA4YB38Eni9w+IwkWVxIyyMZAlpRGOtCVhA1x1EasX6koKwDJvESigrvACisDFAoylXDnflbypTAooTpuoyi2poscfX3or9JxJD+AoWifQDXK1/5yrRWLHQkSj9zjK92JmWS9kPPwNKieywA+RBJ70hyBbPhEIIKAvKiupJqLx+0JV1mveln38qnZLkfsAvo0Zy43yR6NDcGK8wYVpN4lxlvPc8aYybgEP0QUGM6lxxKNBoLQIMOqDgOkphjZXpUx2Hbq1/9agKOADH7R8mcwPD5z3+ela/i3TLDeGnO8SQSQFUIWUDRRSIiNalIJRBEh4d3mqgaGavu0fsIuH+AoU/WCHQf2MZxjFh0aCxF8GGoDu2DYqtnq7Orc06eO5bJgP9TOo4aOrQh1hW1s3g2ILcRbTbFTnk3WKmgbFhh2K/o/lkBudqI7dJRBoz6/cy+rMq5+cPeyhJAvv+BriXkl3LuUWZrvc3AOdPA+HLT4id776iv4OTDe/UdDs1+eplMxT769tHwVq8YcQwKEWCEskiCaB+oBvPs4NoHfDXVBJCefYAcMEAjMB8CAgorkeMKdZCyGWd15sWj2EI16BhcmxGBDiNvIoCAPvCisUxY530IeztgSeBSKITO6dPqXvKSlzCVO/sA1raXcsJ4YoegVbF+fWHCODz83HPPhRaho/jED3QOQnN5Zu4JcLqAhTaFWnjiwuxoc+1zZnQHhE+YrEtTK6qTsnoKx/Nvt+e9ySw5S5DiuQd0Y5Dk+2zpzX4zyzCrlAijH48ZAMYbcOaOsiWkrPmQ3Dicy2vIsApokGJQBIDCpxoOioMiq0q7vgwzBexJdMBUJzNlKdD5CsiJz+AlAnQ6B+fXtIhKPIh5kZjjcPicffbZ6AHweO6HDgiAbNa+u7O7rOwaAGIboMYUh38AEyIWHJ4PJVdhu24BoHRyaBxAwjwKdUH5A4Dcs/h9ad1FBAa1zjUlO0DnWlrUPpgQJX2lpM6z63GfUBae6xbrWDxHqAIhkMuiJJD7kOTdJjjusA5CLPPyEH67s6S03P7n6FpivDqmRlunIlQJxTZnwmvNBn6aAWcsABPINbRHy4qXaNh2AQLFSx9c85BxzNuzlQbYTRRFAtROKrH60mi8WDoLwMJJhM1e0iaCHSUYAABsAMUL5/rReqJV36kGQFAYz4K0Jy7kcesQw5xb0hk9IPcK6x3yHfsylRIYKQA7FIZQXyQ3146rwMtzD+aWD6gEQIfyQbWKrCqyd1NrnmvQWdFniFbUIg7tazcShXj4YYfDx1PsitFqLEN4Rv35Y7K7KJlPpADkewzgd1tnvxqVIY8zX9vMyrL/gR6V01G5cnoQJmLAbkA6d9as/lP6RvWOTgmxOdhH940iKUMFJZP5KT7phIkTCBRKkuwxA+5dBqilFkdBqWEBQI2tBmcOIDx9AJbQ24svvhjp'
	$Graphic_BG_Blackpng &= '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'
	$Graphic_BG_Blackpng &= 'PHzu3EOzzZTrMNMofgMoi7i45jtVuIZAzu/RRq6euGnjxoHlK1beaEDH5bockHuvZz3In/gSXUsrmB5xKpHJO8vWQ0yhPMnstq+wyLg5IK7lgvXb88ibZM81fqQ6pizinhk2PXjgjqPHjMbBYbz6CFzwbeXSbNP3mkTERk1o8NQpU5D2AABbu1eGvVQnWAoei2Lm85S0v9/Etq7zO/kauo8WFEUD76MW7/Itr3/4e6dj8zx0ZGiPAX50e0LeY441ST4bxZP2wC6eJlfbsXOnRiQATqeijdGRuAbtmT/vIKZCJHlO2eiIyYQ4/Oij6zcYpfsFFdxygKMgPKxaic04+RMf6BHsRDwiwQ8keSe3tR9qlOJ1JmXnm9RVyIDAzioKQkNj2osxJx6wSVnr759trvbDkPKS+gCcEtbEwSPlffmFWMKBqD5Sw3LgBUqh4T29c3k7c9nMhtycqPhrUKR92EmgFv+JdvWWu06+szmUTrY814tjeprui1EQOkKiMp090RMr9U1bwNspJESMDbb29rO2ge1S3tCLWr42jyS5d+nL24mu9aAJgR/kAF+t5AkXpLU7gvx/OtAj2HtysJMJPDl3LM22da55/F5uHscnT2IaavZ0LwHuzrCMd7WtXMGlh9H8wYPACnAADHCBfuSzbxxqVGUG51IJaiQ1oOdvJhvz9vNkjXih1VO8gyygYQE3dQJZIaQ4Ami+V/Hs/J7ae8m7GBfOJXu8/i87PN8XnbjIQmmvtviZewR0BZUls2C/jT4nLHgS4EY5hWpZANkGM0+usNm912e7YiyN7OL2iYc6eTpzRxCVkuHjg4mPD3milm01Pm6WlaVmhrwmB/gDOVXZoIJD3k6ug/83AT16UPsAu1NSoTJzjC6cblaUM2ye+FktFtmPk/JJ2EDu7pd0JzUP5SgfVn2NQQ+GAycfmB1i/HT27FmqWksiBeY7JD0Sn8RtputmhjXOwT51k/c2oydxRrmIgpgIwn6uehkd/bLLLktRjJPteWbOmpHNMelNrA7WJPZhpIKm8VybN23CFp+PFsDajUZZT87FrdMgzRMyact2bqdS3zg2fdhiE7BtXrFy5Y3WVrc4Kf6wlE5VvI128v+NQI+BYH0uZADePkPSfeHCRa+aOXMGVGaspzJSkERntHhrSUyEiFOQaNoZpgLEjf3YwGOWw/pItmb1g9matQ9mzz/zTHOcLKPbiFbkn/ZdQVveuCJJDEjTvrKw5MdCa/ib/9Kx+jsEfLG7v15LHuIETmJcTKpbpVvj3HPmzmW0ajvN9jLT3wY6LIooVE1Ko+84MWbcW28UdehNkl7h32OOrAfMmvVDeLiT4o/GmeK8x/P/A92BPfD2yc4EOce8ds8x5eo0G5qnUxHMOYCiZcCb0/xLLuTwinpEsmN9AfgM9xyL9QYqQMDWsCSspxeq7S2Qq7C9MK3u4aQoSwjwEp8poStpEWXS/gR+mcK5USUpNCrhTQWMSpiIHs2icFqtArY8nKx+ZOH8W6wDLbYUxOuQ4Kz/p71z+22jiMJ4xpfEW7uxk15CAlRUFS2VuD7wguAB8dBHnvhreUJCSCCkSoAQlxJxK02bGpqE2Ca2d/lm5xx905ldyVISQmA2/Tozu45kVb89PefMmRnoQfXhtoQ8gV4fpLahjlj3deiqAo+swwcA8iYCq8yzTLUWHsCGqj0HSAGApS8B0v0I4crwbE36ygI0oS5CV8V4cabc0z47FG8L9AXvgUyMyQ1e/PJFRJxhc9c81yk+KjEEnOK/UWjBVbrO9MgGnKgZ+jAA/BH3RZTz+MOgM4Fe/50CV6brWfcNaMtadkx1vwNruwn4mg5aggpVAb+QlSccsW+t61211RwzA1AGqHQ5AteGhV/6EijUzoKXfX1DDFfpzKEpNHMKVmbVbYWt8meYqwCvzFzh5cmRphzCx78Ld+WuAP4b9NCz4oeBq8LkVAJ9QVeGWZmOBKoD6LJY9y0UY93BtPdr67howWLgVbjq'
	$Graphic_BG_Blackpng &= 'FlCoFg0wK+vftW3Ye6ypqT1zn7KQPb1iSfuq2is+Oa/Seus9f4Y5BpxuCgDfRyB7DxmVjx3cEDcWesKt4iSrErgqCfTFZSoC1QxaFXfmimRnNlGY9T4yDTfhW/cq/FEfdgVgEeiPczzM8Q/VJbi196FF4fZjFlVl3AI3aIQg1gabH3lw70C7/vn7ccBJyBPoxw9UW1CH7gyBRzB5HbOqd+C/v4DUWg+oytmVsFAA29gfnekzaFtNHixWGLQCOIH3JnkUCNsy1aeTQn5Zl2ErpHPEh08Hn6x19GvX+RljfIutgakJj1aRvVTcPfkShBstyiygHI+ggvU5sj53AsDvoxDrEwSzPwncBJxuygSanWTAmUCnTJSZYbDqA78ByG+gSOzdS+uXrvcH/V7JZEPxcTAYyYC04Gc3FQ4NzgqtIrTAS78EH+OCQC6VY6YaC6ItkLp+LmNwxjJjAGwcwAwa+SvuO+oLIZADX+2i15Dpedyw/YZvudXtkXYGuC2LchIJKyPBqJs0Gz9+tHsfi0g+Q9D5o/jfEAFnsBlkVAh5Av0UMzMtzqrSwosPfxWriawP/x4mm270V/v9pqOi7r97+tcM2Kr86WAc3We7uOsSZkfCloqn/MNA2/fza78fnhcoBThAuvBXFHN9iqBT8+BWjwMLrrObs6qMSgL9nwtW2wHwq9CaZGmuWKF092348LfB++Vuli0LeuISFKyIFIB0OZ8uF7OPGu6v0IbVvgBcWJHH35yPpXHfIz79Wft+9brO+C7JkrVCLTfBtj+5+zRwVzfG7lU+fYILLso2VuJ/LlDvioYy4bMfAD49o2AzgR6nImMLzyyNQA+hqu/W89euvYmqxWdXcSFF2Ki1qPanQQsK+LWiz70Qwe8Vp2M5uBiDC7Tt/oUchxabJb+amsxRznCIXZl3UD77FcqRtwXwocLNLEpswc86ZZhAp0yNS9OBLqiVD6BfxzYYb2Ah8G348dav71roHVDqIwMVv/a97NvWgY/nztrjJheL6Gf4IpBYBqRBsRekfSu3a0BeqDsy15ICKY11sQL3iGHQ6/AujzLM9/f2xzDeQ1jvewD8a+uOiAg3rfcImlS7KAQ8gf4vBF60LMoE+osCfd8Df4DJp5fh2rw0APTdbq+HWde2WGgl31/PSTfH0S3BpASX5S1IalwMbWGw64XLqBByzmhCrHnXQBetS8QYgTxnYIsHo/F4hhO6D/cc3NuoKvzGwQwR7D2B+wAaqfUWzc8H4An02KWBIitP6Ls++CqsHd3AzOsr2KHqOZQID7qgvpNl7YXy23x26qfPWbBxTP4Eq4L2hr8PH9hyWfjguoH+nsgH+5BwR9Y7P28uSgKdMhWBa8sLXlc88LuinoOfgkszAPi31uDXI1e/nmVZN+tkHfxpGeu3cAo/rF/h2LDL8oDgY0GQasR6F3lejAH1ZDw+AtwjgP0HXJIdgP0DsiWa+jvwJfcORQr2X15wOYsDTAKeQD//bk0MPcHveLoQqCvScYbld5uIZ7egNcB/EenMDFpB7cuyrb9B2zS40Bd33ZR/Fe4qwQKo5QAB4xz9OdrpES4UkmEh/ehP5LXLJAkWhDy0wIpGIgV5FGiiItgx3BSvBPp/0crH0DcD8Fc8dUTs+2N+vk2Jy0T3yYjCReK550JMKbHAao0VXo7Zp3yw5zHcsfX+/4KeoKdfT7UDLfstJS8M24YnU7+LGaRgsvWhP/LbQDOK/vbCcCfQE/iBmqEisBVutiaAnBbdh53tnC3BZxspPymwE+jJCJhIhJ99ylSq+iqqVAMw+7GWTgXuBHqCX1uK47rPx4ohja0yxwnqBPpZyhzfkMTgJqBPTn8DcuLPRc5VY+IAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Graphic_BG_Blackpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Black.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_Blackpng

Func _Graphic_BG_Bluepng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Bluepng
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= 'm3DhQ2VlJSorKqQxc/9AfwrlUQYPiVakVXniqYdRjPDIo3/QtrhMuvn5qVIXuOzpYxR3cIxSmjqDwZAKB1T9jOwZxlJAEtdtY2Mj1q9fT6O1ECWlpegZ6oJpVdAFa4sAx8D86xevxZlraoTSPL21HpHIOL727V+4UsTUjzY9jh4zq0YACkUJdPSiJxbkgWcaOGpPzw6ShNDMGTacnCBRfQ8+1wEoLmg6E6NlQKEg7Mey2hx0c+lqxFV0oqZNDDxF3zXd8qTx6VgXJd39ntgTjRFTBv6y+ZnIC0sHD4UGdV5X0SJbDzCSuOHSSgdPNylEtxU3XlZF2xaK2pzv5O50L+ohb91Jy142IG0xv/qtu2iFakchzbl4CWea+Ph7N2BJXQl27GvFl773POpbhuxBOAUDMwgmulBaWoai4mJkZWfjeH09pqWkhTMR3AY24UzPcuKzGSKJ3mxL9DGX/RynA3RLVh33MgFgmJVSmmIWmKbpowtgW6ckCtB7T0MlGnHiLS0vL0P1YBX6OeRypBsRfx3fJZy3vo7zSMXT1TcUQXlJPm4kp8R/PnqUa8G4gCGSztPraA6xQyBu4GNK/LlOuEjyw1YhuvJeS0RXTLfdhtsZ+7LraL84cGZi1hxyQspiaBC/sUXubXMXF9mcTi09J1LcFX2oJbyzPTsBfL4q8u8AdwO/VvdHl6GYzc4OiCvfl5enz23Xn7do+9kPn43VSyvkuVZXFuKBH74ft/7jA9i2W5RaZCY6UVFo8IzP0lxw0tXVlVJ5S21VMVsACltJErqNtjQfZmzq+BZNW+amLl6belTx9Pb29hfIdtnnKIWhCj06L05W+h5aWlqQl5cnNvWysjIEkz2SaofEJLa+th8vbTuE1s4Rqb335HOv4ZEnd84et56MO2mEXqH4sCP1S177vZF4MESqC8iNdBHvcjxl+9YrvR+bMrBxZRG548PiGU2/WFo6nvIiwD15yeYarhxWgPFJUSqVW11ew3GdCpjOZ6TyR2WA6zuU1rZu2QnhKuFCPxM9O2pB4w3J/eW9W/DkC7sRmRShgfv+sBXbXj8og8y0JpFh9TAeGBdibWlubuZKXIwbtTKmFNCdg509oWwc2QtgwMHPox7b+ekDXdMXAIM0ZRx2tWXkVV+k9lqxK1eiGito1NbW1qKyJJNHs33oGH7/x1dRf6IZn/jcN/DP33kAIxPC35AWPk6JrtzcvEK2LE1Sq+Wa+gHqJAUTkmHzXKvnFuj8TP0gFXdWwO0fmhEbv5RspmtYUpONyzYWpzffWVo/mnXxfouPy8e3m8dCkqz76PwErNnd6yKw4yqEgX5rB69CzZTTTLdDD6aYGXXsuVh1XMiJexRYr1nVkJoyH/r0v+PvvvxDbNuxH089v0tl+SMr0YF5xQHMnz+fJbrM/D09PQCgAH5SbKmFK1TYIB900pY3AHSPUjoBYIik9BMkrYdgL6rvo4Kn9C6yt1xGrKmpCeHsMMg8KYpH2DeEIEbl+/c+vhcf+NSPsefYOIzMSrareylJenriVai8LmZPs1hvIVKfBrhIvxrisDVMlTS31jOClK7ee3wUBXlB3P6uhbjluvkYn0rMGYogq64B4+lsYdHqAhAdN07Hr8HtN85HcX4Q++vHpDZ9eoeXFgi6yL4pXFxoi+4rqqlPMqEU29NsPePzWG4sW1hI4F5mFV7e04fPfvW32HW4R8AasIaQ4x9kuiLSPCszE8ePH+fZX/eqTapuh6qBrh5sJM0jxCp2AOi3+fmESwk9zQxX7y8K2plHFQAWL1u67PaS0pLzlELkM31cDJK2pgBfPFe20MgIZWDdunXy4w4dPoTde/aisTOBMf9K6XZmmVl20rQEO6lIPvgMKXLvyiyicyUnEJ3sY2VIugzzIjc2WIJgeB6S/nwGlaYg9t/pjB5oKaY9hSkNZdV3DUts2s7udfJZOAP43M1LMTyewL8/2IRY0mHGsysG6MHlaZCrP4MXXNomHqQtx7fE8Ykb'
	$Graphic_BG_Bluepng &= 'OFozIPVaItNW6t/rTB+tFyhJTFukOKSk9WKKEivvrdSYe5PucSzSjeR0LxAfg5j0AmFaixDMLkbcl68tVTCBRAymFJ9VOolU7xKnkwTj8WokkRfbj8WVSaxduxYrV63CAEnzXbt2YXpmGnIkWwEnDVCsLDPTMym5oZ1dnfVNjU0PADgAoAFAN4BRBfZZQXyaHV79DHq6sGnyeq4ji0umKXRFgm6k34zm6rRCt2xkM2MwGBT37vhIL/04C3F/kbjZ4cvUnBM+nLuuCpeeU4t9R3s00Bk80x103xuRmGhEcqwBidFDSEZaAAK8lZjkGAsxYYo31fS7rTTKUqP6Z7rs34bOueQHK5LelX8pqyWlqrv6mcIkhDP7fbCbBPjUd5wFNWXVwJZ9pxRLnhf2SRFVftavHRxGz+C09++RdHfO1FsBbjKVlhiQrT6OuraEvLem2xAfPYrE2HG6x8eQGDmIZKQZiI1J5zkrNikeTAQKUqLSPvSOlcjKCnFJQJWxr8tiI4HMZAfKs/uweNECLFu2TIoU7du3TwrVGtCU1/RJvRrVHVr9VGYHk8QOXqD99QBaAfQBGHPz89OnLuljX4apIlIjXeAx5SXlJWGHBSh7uslboTYWB+mwuVEUjwW1C1BZVoQMqxu+xLCMeiRUMnWMOlmspWCvjTh+olXs2WrxTbcTyJsQpxsf73+FwN7A3TNkTYw3IN73Mn22n143wzfT5uHLukKt5u4KNF7lDHOWXmton8B0NI7LzypFVWmGtBPUkXaeFLRT4ugBvy5exHHn5UUhXHV2KdGVJBraRtMcz0jXxcKloPrVb0kXiyP3LUECJD68n+7nS3Qv62XW1Pd4Cw2CQ/S6Eb5ol85VTURxvKlTgrc+ddM6eW4yU3CqI219iVFkJtpQWV6MmpoaobH1x+sly9+CPfvb943xk0xIlr8jjc7A6NhoB4G9xQb4cJrYljcKdFnjDqV0gDTlP5Ddk67UEH4nFydmILv3KHQdax6dLc3NYkaqrKrEwkWLUV0aQlaijYEuAPebcXzy/ZtQUZKDv/7bH+PVnSdg2JIo0zeF2MwwgfsEEiRlNm3ahK9+9at48cUXeeXXsi8xeoQGw1HEpvrpbyZOvfKAFU8HyfQNbgFOWpaqu1nch7QsiPywgA7rluRS9a2SlPPfeGmFZ3UuZy7Pww2XVMixc7P8FNOSgdxsP0YnYjjRMfFnauZopfv9cr9iRAnjIsUPpb/HIu3r6bs9yDQnmMIIEF95/Rj++rN3orI0m57jBvgNO4jOiiI72YaaUh/qFtTxzC7OoZbWFsRibFd3NAEUIQnpV6TiWgyASx9G2lrbtgPoZew5lFAB3BsHenqpPkSjq5k04P2GHU2mqic5K3o568KMT0yw4iGlxmpqquUHF2dHkJnsktEfmxmlil7b8Xf/8muMTZlCZ9TlJaMjsKZ7GcgC6FtvvRXFxcV44okn8Mwzz8ixbr/9dmzevJke0gHmlvw37p+vbc5zS9u546rp88HRKF7cNYDCvCDOXVOEgpwgcgic77tyHnqHZpxRgmT16MQDz3cDAG9ldR6ruWsKm1fmY1FVNoIBE2csyRUr1cu7+1ShT73o46YftN7PGJRpldjkzIhk4yeG9891j4UyWjP9dLgxDSNfDsam/fj8HffQc3wdsegoLGuGnm8nirOGBeC182ulvPiRI0ekiQQYN9C2c+Wb0eUP5TNmBK1kfmyzgT50utJcA/30pfoogH4C7kN0wT3qIi1LpLdcvHB3KHuo/Cb09faxFUZsqIsXk1SfVyqu4IA1Km7n7r4RGIFCDhiSNjAqrzSWsJCMtMrriy++WLjd9u3bxXT5yiuv4Be/+AWOHTuGq6++WhxYSeLwUenpExc+LitwGhI+wZxfvZkN7BK2u/vosEj36tJMvP+KCrT1TmFf/VgacHpXVRX4iVd78dG312BFXZgr2nJ1XD7+6Ujm2WctQ1Mj+n0qIUbex+IW37dTvsdWhCRywkgt'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= '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'
	$Graphic_BG_Bluepng &= 'zI6Eva/QJQkDbd/Pr/18uL9GKcAJ0oU/oJjrIwSdmge3ehJYcF3dXG6TUUmg7z5YbQXAH0B9ydJct0Lp7tvw4e+B92udPN8T9MQlWLMiUgDS7Xy6Xczeyty30IZFIKm4saKMPzlvS5f59eweyDr2q9d1xReAyyFKYrkJtv0q3dN4Ut0Ye1b5+VM0uChH2In/iUD9WDSRBZ/jAPDzCwo2E+hxKjK28MzSCPQQynXvvjAevzXo9587QEOKMKu1qHp+YJYp/FrRJ7UhfJb++c6bgGsHLGnALnvOQ4vNkl9NTZY4h/4UpzI/QvnsZ9hQcSSATxRuZlFiC37RKcMEOmVqXJo2dEWtfAD9YDwev3ljdOMe/Hjr13cs9A4o9ZGBil/7Xo1t78DHfWftcZGbRfQZ/iGQWAakbFo7omOrsnq2XKs7stKSAimNdbECz4hh0Ovwrl5lWB5Pj+cw3hNY70MA/rl1R0SEm9Z7Bi1CF4ViS6D/y4AX7Ylygf6qQN/1wO9h8elVuDav9AB9p1MUWHVtiYVW8v39nHRzHN0STEpwWV2CpMbF0BYGp164jAoh54omxJp3DXT1nBhjBPKSgS1uzObzJd7QfTp1cB+hqvALBzNEsKcC9wk0U+stWl0OwBPosUsDRVae0Hd88FVFUYyw8vpar997HiXCvQ6ob+d5a8P8Nu9t76Jsdc+CjdfkL7AraDr5dfKTLZeFD66n0U5FPtinhDuy3uXlc1ES6AQ+DlybXvC674HfERUOfgouTQ/g3+3Dr0eufpDneSdv5238axrrt3AJP6xf4dxwyPKA4LEgSDVivZEGXM8B9WI+PwPcM4D9G1ySRwD7a2RLNPV34kuunYoU7D+84HIZB5gEPIF++d2aGHqC3/Z0JVBHpPN8OBzeRDx7C+oD/qtIZ+bQPmpf9mz9DfqGQcNY3HVTfVu7VoEFUKsJAsYVxiv052doKCTDRvrZ78hrV0kSbA752QIrmokU5FmghYpgx3BTbAn0/6KVj6FvBODve2qLOPbnfL5FictE98mIwk3ipedCnFNigdUaK7ycc0z5YK9iuGPr/f8FPUFPv55qBdrze0r+YNhnnkz9KWaQgsneh/7M7wMtKfrb28GdQE/gU41QEdgKN3sTQE6L7sPOfsWe4LOPVO4K7AR6MgImEuHnmDI1YqPWNYoA9seR2HYLdwI9wa89xXnd87FiSGOrzHmCOoF+kTI7MCQRuAno3elP01KKNfcOKO4AAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Graphic_BG_Bluepng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Blue.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_Bluepng

Func _Graphic_BG_Indiglopng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Indiglopng
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= 'vQeK1iEVuETghwG0ofmIjDvgngCH5tkxvAb+TevJ2dNH5AgsHbe+8yMEHwCrFDt+3kh/lzz6gy9SAm+67FUSsABKWwjAuZkp7JMEJagKgeURebSdB23lkMIKkkzzcDSUW6YQslAi58iNaUfkNXW04jRoxuzUpMSLiqHAlogILUC097cf3StP3nuX3PzW34DFplnsYIhWKHGEK9NjP/ySNK+5UJrXXkwldgoSfmZmWjIuxMYnpwDkKamPImTZnpTk3DQl9KZNG2XLlksloYTFQpL6jZvS51tRwckp2WF9IeVqB6XpgG4ECjULJXjn0WNHlb39DPazbvjApJbsvywFNfgKgrwRy+RvVVVV3xiJhuNtkA4trW00p0HJIT/XNl/PxoEsAlghyQnIY8eOyR4oVxhYggPKrEykItI7B3BHSiQKSU2gxWKQZCUK6K4ymARQi0BRJqUP/Ldt4xbNmSkxE5C4l1x1C2LVq8Vyj+EJ35sAuFHnAs8hPQPYLdvEywQsiYHqJGJB2rx3vbRfWlavlZrSmHSfaZdcG23yqbRIrFymR8ekHKuG5uCJInxeLEFdwHa9q7aoaEaHZtGLr7wJgCync8udOLTDjw72yPhQn4Q2biU1igRDlMCzswkFeNKSirJiKcFvGRlHcNp8WBoxPjPTw/LCCztgVuwD2LeQOsI4QCECauiNo+H9wb2gohoJRyDNO3B+G8ekvaM9Bm/tdsu2grD2fMsrWH/Zkj34S1M8/SD/HQRj3QguF22l+bBVOW04YC3NLYvCW4X8mFRFSXHerDlQgBd37gIXPwSJMsHjVjgOmgJTWbAMki8itHuHIwR4IDUBcMYVdyZgHJuAlcraBjl16EVpXX+xBCJhghX/aOZbDfArGhEOAbTBgP4mlOxBK+TJ5DcKcUVxRBYg7fe+eEB+9tN7MZGm5EN/9kk53dkr3/rcP0mhrXZFs1x+453wgM6QxtDZhM82ceucFHpU8P1XUEnFpNXcnXvGStM6VIQJW1FT64YkhASvUAoHMvMEKILSANw5qamqgPc1IadGxqQC3LsuMqlMh4qSMM7n0ksv5fn4DL7HK4AyTobHV61exYwmOOIgtHAPLQH3b49gdb5MRGyA/ZvZ5rhXQf1VpS52DpD/NiTvzQQ5JDl2SqC169ZSkoOPLzUdMpS1zOWMyqKyc+dOOXL4CK0blVXVMgkpPpwpETtSxPMtsYU3Jjkm86NnJW4vSKp0tVQ2reINt0SocHafOCgdx/fLdXe+l/zalJ6gNKVUtlzvJv8ZUGug+x4f/v4XpOPEYdHbbW/7ELk5NvJmtYWjMdKlWDxBaTl89pR860uf4mvbb7xDVl+wla+JaICbR2/iBjyqfLQC/HbaWytzkL5P3Pt1qaxrlNWbLpNEeSUnCZ1Ek2MyefIZmUlaEq9uFSdWaXi4WDI2DiDPTUpjbEasmUECYAOUz8u3b6eVBfeHdAWP3u+iKSUVW4CdEwrPucMEugA7/i446xTY27F3e2mMDhn4VZToXmdQkWtdaYBm/8HKisqbEEcSbW5qVjSFgFq3fh2f6xhyYkbIVSnBoRgRSCcwgC+++KKc7emhjTueKJX+hbhM2aX4m1IckjtBHh60HBk5sU+mRvtkX/sZmV7YKXd+8E+xxLp8HJK+oW2d1Da1Mb+SJkROEotu96BoAPuBjT2riXNqfFTe9N4Py1GYJx/4IQUYwd28eoP7m8x7QwGbVCcMiT0bj5uwTSZlcCc4PZPI/ZtgJ7CcAJ9jN5PAEmXatKGgvhbvs5VUpwWIcTPzSRk+vVtCoG5PPPywNLWtkstuew8mVbWiMwR8RUUpgBmT06BQNVjlyp0ROQJv8jh4+rbLttHhhMlJye51MqG4ngK0ElYci2MAO+4pFWqAPQyjwlacm8Yk+HaW+pDzmq//KgHdG4EYd+3k9fDG/RqsK7fAbR5ramkSLm8ish52XGT9EORGchFgNHXRepJO02y4Z88etZwS+JlQkfQkwdXD'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= 'pKv9OEp0f4Qrhmlem+HKA2cPE5gXFF0ZGJHZ4W4hyKsrmBZ3ALpWe3sHuTchToubG6zlhm0vpBZId7wRZwODg13wvD4hImdcS8uQPxcU2ysPdG7pJRQmtn///q9eeumlfwATVavjcpi0pZRTi8qp7Uo82yQMUAuHN46z/uKLL1YAZgDRiqYMwJ6W+ViF621VYI9rJwilDWs6fucLsh1mQlyHQPcURmLsxf7nX5QBty5My6r1dN3HlKLn+Es8YOLg3G6ZnZ4i2H78zc/Lu3/7jxh0Vlu/QpeKw7XZIZs3FO3VeT5c7MY27O+8bRQz1zmDyU0+34zvBEVVXZcooGk2YIPGtSr7Pm3Vj6N+fBMmmGUHlDRk4FdSAtKDxIYfff1zebKBCHJSIXyuBrkOCyYtOgGl+JF7vo1IxHfQYoQJQODC46ksMEyJ6+4fZmJzeBz3pa6aJmI4hJgjDGHFMcyS/8nrUD/zjMXQ8NDQ0SNHHiTI/ZSFFpZXHuh+27rXChNRO0xF3127du37MBi1OhxAJ1TDbJU1QQEg56BhUzSGk6ITkXVNzRh0DPxkulKKCKA0zY9wVLEzM+LYKQ3b1l1omooZXVKZ8Cg13/zej2ppTROetrUbOsXMHiqC04hGrIbkLqmoAtjaGHT1tg/8ngApBB3OI+dOAwCQwrzRBH8G3JuTjNQJMHQMZdO/OW2R0qXwmQ4BoWzrIVph4NRiYgpWEVo9YHcn6Pfv3SH9CIW9410f4jj1gd71AoxoGIZz8Nve/9FcTigDF9tmBw1z2CEYy7E6XAbH3EvPPYHJcB1XC0wkBXJSy+nZedCVYXGQthkab5eW5kY6kl566SVUcTjD7+MFuNfFn0yaiY/jOv9zAs6kn4lIh8vN+7xWFr8p8ZUHOrfF+aW8dghBX3vQ7qUWoH4DHEqlmvvpQcFxzf98DVOxnPG8S6CgKg9qe0e71NUuSLgsRbAXg6uTywJcQz1nJFaUgBJ4GZXCEG4AZgLhOzU2KD3tR6Rt02VsKOBinMpRtqUpA3rVC5CnWTVKmPG/GWGob/q135HP/N0fyUGYDlE8iU4g2L65oxsfQIvz2V/HkaiVlHjIYU+mWCQksWhEIuEwAMXJDqfYAtuBz8ynsGdkNiXgvWHsSVqbwOO5WqUjUWZgBRk7lJGffP+rAPlvMvJwdnpI2e05OaaQi7kSExwTOS/IubKBZp3a+7wUV9bQ+UOrSDBE82rr2o00l6JLHqhTiWpPTtoyPjkr/YMqQ6hLghPd6DoCX4UIIxlxfwlij0NIr1K6oi53r3ccXH8Gk+NFJPAccKV5D/bhRXmgL+MW+IVVcTOKqoNQyzHM/Dg4e3MIGwfDw4MDbvqdOWYGDANBjxy4vgrzpIcunJmliXA6afMmQ6pSdtetaKOJsJRBYCEcsuiZ3PfUPTLafUKOIugJ3lcW0wHgdHKIr4nXQE8XuzfXN7XRIgNJDcWvlHwbNdlZRcx2lVLsSoEjeNLJOamKZaSlukgayuOSRqz9yFA/uHEHvYOHDh+UQyi7Bv2FZfvGEGnInj3xkNRWJKQkYuHvOYI/qcCxOC6bPoWmtjVQoDcTuF0dJxgHXlHTIOMjg7TS6NAFcXz5pGzL03fmmBx8FhVyh7tQ/nqXNK7eJCEqn6STHLdyWJHiRaUAeIbWov7hCRmEzT823SGRuUFUblhNSb8b+Z5QIn1VIDTIvXVZDG1j89uF7u7ufZggKsLulAv0/uVTlldeohPcnrh1W0t28O57Ib2LYYm5EpIqaioIGMnuLVojRtPnYO7YsUMuvPBCYcRjdw8kXrskquZkOrMgwXg5cxDjsIJE4sVsAchCqKkMwgb2SHJmTPbsY5EkqW3dKCtWKbt+2I2fypiQUUdkaKAHk2uUnk44j6isMsjLUtdLsZLuQnCObn5Kc7r456Wu2JK1zfWShCJ68OBBxoWg8wcpiXhCWek+4HNjP3YsYVzPxo0b+RtXR2Jyoqtf+iZTQnuzu0ejMeoV'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= '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'
	$Graphic_BG_Indiglopng &= 'FuzhfevbzCA1i2BZeSPgyyrMC2tHOLeS4+LwVbojI5YUWGlsGSvojBgFvTxcD/X0453tnX0Y7wGs9yYA/9K5IybBLes9hA6qXRQBnkD/BwJvWjDlBv1Fg37ZA7+DzaeX4Nq82AH0rVa7jV3Xhiw0A0L1cwJ+wqzzZ+w8Ge6Y4lWrnBQq6tXQURiCXG14kGreGejynJgsM8jHCmzxBo6hOMYTuve2S7i3UMz1VQkzJLC3De5daEjrbRqdD8AT6LFLA0VWXtC3fPCpdrvdx87ry51u51mUCHdaoL6Z543Z8tvxeyfPt1e/58BGs/MBuoK2B78OfnHlsvDBeerVNuWBvSe4I+s9Pn8uSgJdwMeB67wXvC564LdM7RJ+CS5NB+Df7MKvR66+l+d5K2/mTfydz5zfoi38sH5F60xTlQcEHwuC1MysN9KAk31AjfNkDgH3EGD/BpfkHsD+FtkSpv52fdlreyaC/bsXXB7HAaYAT6Cff7cmhl7gNz1dCNQycZ2vrKysIZ5dh7qA/yLSmTm0iNqXBVd/g7Ge4cLcIcxa+mxSXgVYALVYIGAcYT7CeHSIC4VkaKQf/h957SJJgp7a+w5Y09BEkIeBDiiBHcMt6Uqg/xutfAx9PQB/keINwHm01ucbkrlMcp8yU9gkPvZciCOKFpjWmPBqrTkVgD2K4Y6t938X9AS9/HqpEWghGCneMBxrnrKqU8wogqlR0BNgjoGOKd44Tw53Aj2BL9VDRWATbo1ZADlHwUcgCTtHAa8x1vi0wE6gJyOQRRL8mktZpaqvSaWqAdY81txTgTuBnuDnKGk97fOxYkhjq6x1gjqBfpbKTm5IYnAT0KenPwDIMoYO3yvsMQAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Graphic_BG_Indiglopng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Indiglo.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_Indiglopng

Func _Graphic_BG_Mintpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Mintpng
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= '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'
	$Graphic_BG_Mintpng &= 'vesSZkf81pXvkviBtuvn134/fF6gFGBPljaimOsTBJ2WBxc98iy4zW4eV2VUIuj/XLDa8oBfgnqapbkkQunuW/DhN8H7WpamC4qeugQFKyIdn96OaLfy3cbkl2/Dal8ALqzIK/KH1qeFduvZCbL13ep1m/Gd0yVrhVlugq2LoROd4TQ3ZjQcHT3GBRdlGzszfKZQP1QNdMJn1wP86KyCzQh6mIoMLbxlaQg9Jj/Xbj539eobK73eM0u4kCJs1FpU+WnQggr8VtGHG8HxjcXpWA4FVzosacAqe459i82SX0tN5tiHfohdme+hfPZLLKjYVsAHBjezKKEFP+uUYQSdSmpcmjZ0way8B/0KTud4/Ur/yib8ePHrM4F+ApT5yEDFrX0v+9IK+JPPxdrLs1wsYs/wRSCxDEi9Yi/I+qK8fDYvzB0ZW0mBbeNsVZIMlkUWLM+VRxnmuzu7+zDeA1jvLQD+lbgjKsJN6z2CDqpdFAIeQf8XAq9aUKUK/UWFftkBv4vJp5fg2rzYBfRZ1ulg1rWlFtrId9dz0s2Z0K3BpAaXmhnBXa2cJCpcq8GtMAg5l+FBrHm3QBctOs6W2DkDW3yAbSiOcUL3cGcC9zaKub4WmFUG9o7CvQeNzHqrxucD8Ah66NJAgZUn9JkLvqnT6fQx8/pyt9d9FiXC3QzUt9O0NWV+m5/N7qLM9JmAjcXOB1gVtDP4bfCrlMvCB7ddr3ZEHthDwh1Y7/z8uSgRdAIfBq7zTvC66ICfqToCvyu4NF2Af7MHvz7LspU0TbO0nbbxbz4Rv4VT+H79CscJuywP8B7zgtRErXeR58U+oMbe5IeAewSwf4dLcg9gf4dsiaX+9lzpvaHKwP7TCS6PwwCTgEfQz79bE0JP8NuOLnjKVDZOV1dX1xHPbkA9wH8R6cwUWkTty4LU36BtJrjQV3c9KX8Vcqm/AlDLAQLGMfpjtEeHuFBIhoX02ORiOCyTJFhTe1+AVY1UBvLI04GJYIdwU7wi6P9FKx9C3/TAX3TUFrHvjfl8i1KXie5TovIXieeOC3FEqQU2a2zwcsw+5YI9DuEOrff/F/QIPf16quVpwW0pfWHYNhwl9buYQQYmWxf6Q7f1dEzR354N7gh6BJ9q+grANrjZJh7ktOgu7GzHbAk+20D5SYEdQY9GIAlE+NmnkkpVX0WVagBmP9TcqcAdQY/wW0txXPd8qBDS0CpzHKGOoJ+lkqc3JCG4EeiT018/Wldd0JWRmAAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Graphic_BG_Mintpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Mint.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Graphic_BG_Mintpng

Func _Graphic_BG_Pinkpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Pinkpng
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= 'uP5dvFQwWKUGhiRmaRTEYsIwSAIDDGZYwHHumV4NuZ6IUHNgDiEV4JaqgKrOTYdT04+fxiajEdWMIEcnlEP/3qP75Itm6TBgxGCjvuIwwC5+Hmk4Sl29XVLCWHLOsi+gV5Gxzxwy7vHhK2BIY7UC3FqbRe46d+PZmBKSAYkJdaGXLz70UbYDRpe9RqFTtIMEBoMHqhY7bPD7SOMR6urrNtoxO9gze2mtsRSmd2VWMSHtwY3bHHq1Lr/mwSzTHCIAfMnKC0xdQzBhjiqXwCMZerrLHZaqyxygUyagu1nyhs1lGGwpTjPOINcgATUBXOjhw4hHT5A74RKpTgCz3WHDvJXf/fWd9Mgrj1MfU4RY5nF0KPMMr7P2Kll1cjTAQy8+ioJC7I6G7oyYFEhGVGhFaC1fGftW164Eo2CzCSnjBCgefukxmkSxoEVVi5YLXsrNl91AJYXFVkmbHa+YTeLai67BBArWAkrZL4ARKsHt8MIjnGOKdhAJ1ggIW71kJUYc2Q56OY0Qt8MqtAOSl+0OtMOj/L64WlgGsFt1cXxY3ik2WdRPxibw8PArj9F3fvU9VOdloYiDfLkBckeFnp6EAGV8SccRbEAAPZ6EUWqUyQPNKI1R93xAt5v1cxOH7uY/PIekLofYZKgtyH5Ppixru92J3jgyPIyb2qdVchd6ZEQicjeD/iDtP3mQnn77OfrAeVfTdRdcg9majWHNUgrLooenA7miD79COqNKls/j5Zf8KH3lT/6Sh/46PDNZpzyHpJTSclXtCngeuQouDEDm4dFB+GAcY5y7IFpQsi2WjvqtH/8bmZevfuYraadj0SWumaPOWENUqmMM6IgANob7Bxnsoh1WynbQF7Mjx2gHjYRAwAj7KNqhxWgHWeh0ls4OUJg+8Mz6T3OUGTYIACcljBCl+Nirj9Ojrz0pqiNjjSdQvhtnewNecg47SLMnIdFZO0AnxLNoRLFpxL+A2iXjrkJP96R4dLeJS1eNp7By6A4OiSzni3vlLMSQ0JiOL4GVmRdeNWyTGUbgr6cU8gVRhgxu/iVl1aLEHKLWPsvceV3VMpxvACBz5KySBeRSzzzOIaQ9g710/qbz4JjadmCHAXKTznrHV/7dglKbaudz++jVXa/Rh1jlYImBwv1sYGZgJeRqNQQN1ka16Cxf/ezfylX8ZvB/W7aDecX5acIH0jwT6kDC/9Az0Ms1HM8XaolsB4tRfudXvjO3GdAOvaIddr9OH7o81Q6NRzF9o6W3W6gbiwS3TIBmjttZVrWcPnfTp+nKs66gDSvWoRqZVI09OT5SJ/QLjY6M4FzGIvAmwwFYs4CGYczUgTgsp0ixm6O6qGkkOn47mRevNh0kSz/IQBpIdsm4xKJ6EqtTdZBtWgF/Tgpcs+TyuOHGjiXj6PMc3GU0vJVOtBYhUtLGqmA4nohOgpOtKK4QkgkS/WMf+CgkkqwlZVzTcn35gdIVF55xASYj4Cg7qDZlhSXcaYYFI2BIdiUdWzPP26WsRD0D/ivzH6dZmBWLg0t3xOiSfJJ1+lAgF+3Auj3Yn49fK9qhFada2UPVwr/LdrhoywWo4It2CISQpoh2cLitJaxnSW/IdSkY+XMWly6/4/2XFZTwc08i/MNhc4CgUDUGNo2Q2+8me8xGbsXJTiMk3QNnptxZ6aeQHLvEksLESDE7miDR53Dp+KHMdf+zIVpqbiCptvBFcXE5LiH6LBrBdg7kEmwBhhqboiJcE15TlxdFbWxyniFVAsxaKCg75WeANRqP0omWk4iHriwph0TiBTXJebiWxy6oVPRZ67ai8fgnYnRYV8bcoG1dbVCBPG636cx5Ded3tHzrR/8GsGcKqzSQqhm/Te0Qm5btUAxakoEka66DCcqk7xiANLVDAmHTUDmZWECh07buNqqrrrOoMFbm0UwwKrLigDlJG9KZ1UwE9TGmZNEi7JNeUg8LS6/ClGNiSheiTqc4RhqlUrJbnHKYdcWkupixbZXoYBLt+Qql'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= 'JkyQxs6kVga54DnbAXAdW5MWA/Q9B7oV7FFex1IeKx8zKveKJGo2QCpnaKJEHJy4zQYjB15UxJbo0Wqo8MW8LcBeWlFKTW3tpA4ppDbaqHhpCfG4CDXGw/+CDh9dx9Nqy+m6FSnU+DrTkWmAHEv6WTVQfeqlN16hPQd34/e5G85GXEZlSXkafwvOlVfDPJ59g30oA6HYbMLZA0/eX/zLXyE0lalBJASzhAaIL956EVQXJA1jVMOFWc+9CGoKewLhQuf5PAGEnzzwX/R/ONunKL+AWrvahPubAv4AmCQAfp7F4XCxwb5uPkcRHFAuv4c6B7oBdL2cRJoQxCmNcpwBjIxoY9PIoYmpESeiBsinpgDy/gZ26PW1UKPaTmWV5ZjdZMf2nUh2RlCWALieEyxBDho3YRiguM8AxwSwb+b5FMi7gCkdW1EzyN8voEvDdDQVh+Brb+94ktWXP2IvWA7peMacRqoNJekwdEmqQPLu3V1ddPDAAVq7bh0lyzVqYZ1QHdAdT4W1xQT8KgRAxsemDWNGMeIP7aoNoOR989cpF7+dNrygB/RCpiIBGLHepQUlacS/fFQNpZt7BvowE0XAF4BX9IVtL+NcdvhAGrP7H/N7blyzAfdnFQV6N3/HMM3DM3/i+bGd9+P7ptM24rbs1QX4l1UtgUF+rOE4XbDlPBqfGGcB0IQJArhMHVQaA59IZraA3OoAXiAoNBslxmOyyeT/8KEmFTwXQB5PMMh76WRnIzXY2ym/vBAEwx5mWDjSkMEsgrsMO0ZVpCNRg0FsHpUmmHfu6GjfSUStALqOpVFpgL5/QLeqMNIwdXd3d73JRmkNJ1xc5ORFDNeJuMYHxeQ8RoCSrt1Ad4fEa25pQfQj044Y8pu624n69FYqqClK6flEHq+bVFLRSVRVIh37zAzPvOyI4lDo7be2QWUhhVjV2AjQQlJajU65wNHE4avoXDwjhdBxkYCxqnaFOBIS/ez1Z/H07C9g7qJkEn8XgG12Z9/9tTvhlZzFPshAOJXoJe44Z6zdjL+fpSbqquSHwlh3HNxJg6NDNDI+hhgYfgaja9oU+c0CckU6ZShTSC/sJyHtIUzQfnNAntR5cvH8yPvsO8nhvF0Mclsb5ZblseEqaMT9KN4vGRZjwltVVt3CPiRiaJqcaCvBzN1xNlzFENsGaS4NUIvK8v4Anay5pRhu3MyiPCS4daam1kkCOgELOwFDzSbAAQ5VkbEyoKeam5phwK1evRqgau7uFFeEDlxYU0KkRMQtUVrYZhdWO4AMwLOKxDzwNsRRf5gdN8wqYJ904St2/fO5155LFd0pE9IRq1zmATvm2Oe4bKgAPNMeDDaujY6Cm3U1ywVAAP5zN57N4IMfAADn7fLTDHYLyNUZx4kNdgjHfItYd6hAa1echvOPNh6Hx5SNZjxPS1crWJ2SwpIZm6GxuyVTqQMURuUFQJaoMbNFT7z6FMoFcolujBgayTmD0JEx3+e0APk06+QM8oaeJh3k5fkM8hAdZFurqakZujcgDsaNdJCrgDxGRVO6JPpQb19fG3teXyaiFjAtwJAlF5Tef6DrS2KOCuM5cODALzZu3PgXTFFVaykdJqEI41TRk6pTLIxqBNdhWGdvHHr92rVrAYDGjnZKDmnYVrykFA2W1AB2sDWkqdAF61tOsH77M7rq3CtxHQa6ib/XvaM79m0HpcgLSuJ5XV4KeAPz/kUJLU5tXR2CScH9fvCbn9BXPvlXVMPccEVJmWFQwVkyCbCyhEdAk749gVWmhM0pAiwdM1BVeEWbrFiyHLq8DCewpY6pKa9idaZWbMesd8u4Q9hUO/hvZB7FbNTf1Uv33PfDTJQ8QH7h5vNxP9MBsCdyEQawn+594n669ZpbEDOe1ONPhLqC6l2xyLROIQ6xTm5rp4LKIlDE7BASOcIQVhAq1vxPtAnsMxNf3j/Q33/s6NGnAXKrygKG5f0HupVbN7MwLrEyVfSb5cuX/zE3RpEMB5AJ1fYZ'
	$Graphic_BG_Pinkpng &= 'JkIzrQA0Go0XqDGOagc1NLdSYoyBcyxBRUtKyJvjQ40YV9JNTpcTdR9/+tAvaHnVMtBmfC+LM4engcFo8Wcf/VPxUzIS86k40J15ZIDhWZxfLHRwGJ33P/1b+vOPf5GUpMrgiMH2YI4Yx0cZBAxEGJdxBrgmqzql1CtFNdL0tRkLR87eABsDxitLUxHUhu8OBz4F+PHs2/btoFZW6T77kU8DVE3tzZiykYsD4Zg/uxUe0Uzpdhg5zDNLa2CWVJQIvPzMS+nFHS/TRVsuxDGxVIkKOIOGIyzJu6hhvIWa1A4qX1IBR9KePXuopaUF780EcLOLH9eRTiHeLvM/R5lSfoWImlO6ebeZZclEJb7nPHr2SvPoPG5eBYKKea3hwKAr2Cl0AzuUckwNAAnGYJdxEmb6UbrTER66bh3YBAQWlcTzqcZeRsVVZRQszBEufKgUDWwQPfzy43Tm6WfQurrTwFDIROL+0X463HKMzlixCTUAreXtzEo8hmnEg/PLEZIMtOH5m88DmP/qO3/LU6zcyDmu6wBw1ld5nZIAx/w6mqpRTImT5iJS3Xayuxi8HifSBhVVgUSDg2VqGskniWgCdW0cmh1OGBuhbeDk4lREjEwOuxMS9vNf/zMG+adoC9OYnJiBUYxj4nHtqrKqbDmlAPVkdJLeOLyNikMF7PxZJe0aUJqN7Y30xt63aTVHT25mNSk2DQoQbv3uxi5qirdRu62Xqmur0U/3C8Ozo8MSno2RCu0PnRxAN6twHKY7ySB/mxPoXyWiel6bTECfskQnnuJio/dm0UyGqsahlsPc872ss1c6eJnLijAgAWrzNnkMZzLBI8e6PsI8O8e7aSI+ScnBGNmSKrmDnhmPaw2/6MriCiF9UWSer4KX+tDbj1N910kwIm6WQEW5RWTM4mHt90zpYfbmmvIaKswrEMYSHDgMBhQP4rBcqBSR6BSMN7lGYlMUDxB5S/3kyffReGwCsfTNrc10nL2Dh44cosOHDsMLzOmIYG+i8Sg5fE7y5fOJHhVOrNhUHOCQEjDV/THVel31UkwxLjaeaD2JAk4lRaViFg7o7KFAiNKkTEENOd5eT0/ueIZaB9vZuN1Fa6pXiZkoAFCnw87t5gSLBH9EKr9wsKWfWk6yPk5t1OcZpqXLlqJNdnO+JxuRlioQEuTmuixm+4QN2un29vb93EEEyBtSaktPJpXl/VNdslOOEV7V1D0crHc/xtI7wEzMWSx93LMqCCiKVGPMtTykpEdjbt++nU477TQ94rGdnRNjbTTZHqGpySkqrCoCm5MfDFPAH4RU00jPetpdz3HVkRE6sP8AtbW00urKFRSrignVwIhIJMMA7ezthgOIPZVwHjH1CIOTrwcjihkaDOVMh2E+H5b4WJU8OxXXlGPboUOHEBcyzp1U061hY0p4UP7GO4QioxAqJaxatQp/o8fpoZ7mbooNTqTmjQLnDAqxrqZOPAek+2nL1gBQvUN91M9AZ0DBUC0ttGYlaRoSmMGFd/R34fk62F9RGiimT994GwSDllTI7XRDDdJExhiPNj2NvdTax1Lc2UfJXIVjV5ZRf38f7d+/X581zqIWqeagMKxmSc4gj3E4wVFWTV9JSfE2k14eWRyV+P5LdLkkjRVer05WXwq9Xl+xalNs5mmvVVKkFOA1VaTSkOxgMthwgc5aWVlBCadGXRMi73SalMEEOVlSe4M+gIpS3swJluYvHnyVevt7hSSFB/Tqc64EgBkolhKgQ0zd9Qz0IIWNVQV8Z6CL3QAXqyfwekJ6T6WkOEUptCxMzpCLtu3YRs888zQP5Z1gTTSE9kn93wC4ecE2XllCQgXYs2c3Ok718hpyhzw0OjhK2nTCsDRSLAZWFUa4qP0CVa04vxDPzJ0e8TOztRdQnSItDerJ/sMHBAOG48/ZcA4S1JlRgVGqCiW5f5xd+h3UNNFGzc5uCpSHqKS4GPHkTDKIhAj8febQCptuR8BPwu2F3FGj1DNyYhMM8hO8'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= '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'
	$Graphic_BG_Pinkpng &= 't7u7D7hHAPt3uCT3APZ3yJYw9bfjy64NTQT7iRdcHsYBpgBPoJ9/tyaGXuA3PV0I1DLxPFteXl5FPLsGdQH/RaQzM2gBtS/zrv7GuqNqmDuEWUtfy8ujAAugFicIGI8wP8J4sI8DhWRopB+hi29YJEnQU3vfAWsamQjyKNAeJbBjuCUdCfT/opWPoZ8NwF+g+ABwHp3r8w3JXCa5TzVT2CQ+9lyIA4oWmNaY8OpccyoA+yiGO7be/1/QE/Ty66VGoPlgpPjAcKx7qlX0zVIEk6OgJ8AafR1SenCODXcCPYEv+ENFYBNujbUAco6Cj0ASdo4CXmOs8QnBTqAn6DUPJfg1D67FmnzkFYoB9uexZk4F7gR6gp+jpPOqz8eKIY2tss4T1An0s1Tt5IYkBjcB/fT0J/AYC/kCjSdRAAAAAElFTkSuQmCC'
	Local $bString = Binary(_Base64Decode($Graphic_BG_Pinkpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Pink.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Graphic_BG_Pinkpng

Func _Graphic_BG_XParentDkpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_XParentDkpng
	$Graphic_BG_XParentDkpng &= 'iVBORw0KGgoAAAANSUhEUgAAALoAAAC6CAYAAAAZDlfxAAB1/klEQVR4Xuyb229bWRnFt+0cJ3YSHztOfImdhLZJOx2pFEaF4SIeEILHEfPAAxJvSPxt8MQTaIQQiAfEIFE0U1KJ3pubEzux4zh2nPgSs9bu+dJP51CrilpA4Wxpae9zU3P5fctrf6eJmHC8C0XGnn97jcadD3V5XR70EOiIzCJ9POb+cRCPZNZr//H7K4AQ9BDqoKKUXutzfo0D/Q0692mk11qXhT8EPYRbw6wVC8pM6JlS96pCUC4fdG8N8lDN1EDPQQULgnpb6EPQQ7AFXpHjU1zPIj/4AadXI+DcQbD7Sj09+zRQGo4DPwQ9hFvA1CBPKk1Rep3NZpfS6fRKIpFYdBwnG4/H0xMTEzOxWCwBTUFONBqNUZFIxILOMcLAmtM5xpADcx/T2WAw6ELtfr/f6vV69ZOTk+rR0dFGo9HYwTOnSmd6raQKQQomhD7y/wV4EG4f2FNKSREAdkul0t3Z2dm1qamppcnJySzkYp2cnp6OAnRD4fhCAN/gOSvAbwD7hQD1hQC1AdBWgNucnp5eqNvtWnU6nfMuBu5pnZ2dNQB/5fj4+FmlUlnHM00AcKKlC0KD74deFIJ+ldw7CHdcuXMCmvY0g1EE2N8A2B8A2jI0n0qlkhAvGplx3YLMQZPWs14T6DcNgo9Bq+ckaz3bIgDYpt1um1ardTHD6bsoiAZqoILjp7u7u/dRFFU8cgy1oY6nrnL+XhD6q+/ykSsNeDBvxxXYSQ/sWSi1vLz80dzc3L1kMrkK5TOZzLTrugbRRESXJrxWiBmcxZl5LGu5pqXAD8Kshbgjzq/Xck3us+7fbDZFhN7U63Uafw2wv8T6i52dnQcA4AhqEX4P+hMFfs+f668q8JErHE9inuKUwC1gQ+7Kyso3kbM/RvxYg3Lz8/MOADeYDaAXsAVizowahIxrAmjvQYwxeN5GFhSJrOn2EmN4r0QYHVskrtC17QxIDaKJrCXW8H6CzmJjFJIisLOAjxxvDg4OzOHhIecBnL8OvcD679vb2/cBQFODr6DveRpSVzHWRK4o4Nq9xbkJdzqXy31QLBZ/gNjxIYBcXFhYcAC7wXnDWYNNeCRDE2ZCy7jCYmAh0OV57n0PQk/XJsh0bornkNdlD8AC0ODT3U2tVpN5gKKpId48Rq7/M879EwAceuC3xOm1y1814CNXKKJowBMqlqShzM2bN38IQL+NbH0DQM8AcMJNCdyUbAoJMJ3ZQi33EqZLjkAO1zn+MoNFSJD39/fp4HR/wi+bYAIv0PM+uZdO3wHwW3jm/rNnz/4EBuoCvYo3XQ38fzfShKDrDabjAzwFZeB2BQD+KZz3HqAt5/OFWKGQN/l8Dl2SKTMcjMxgaOODBVwyeT6fN4VCgcAoQEf/g74gX9YI7t4zu3u7platXWT2uBM3Tvx11GEHp7pXNdXantnbqw4Ra/YA/PqTJ08+Q+FUFPQtH/B9vXENQf8PxpQ3OLgLzaErcg3jUzflfj2dcQu5XN4UAW5xcdGcD5G1z+HcAOO0d2Yy3GjOpU2pWDLFYt6rG/POnRuNdFIiGf31bDDjis/Z5fjSQgfG7O7smkazYcGPI3pNAvpYdMKgs28quF6l4PSNxmH96Ki5/uLFi98B/ud4/ABqQEcK+ECkCUF/v4BLTJEMPiOAI5Z8ZXV19Scp1/0o7bq5QqFoFgH3/HzWQjWEc3fP+sjZSbQIXcPrSyvLBhf9PT8Pd4umgKlBpiQTU1zrWd+j4A+2HWUtHRwdo/RarlH+YQsI16VGz+WkV1gbm5sW6iZbk51jkwD0sRgz/YQ5qO+byk4FDr/LCNRA/n/49OnT32BD/BKP7yvg25LhJc68e+BD0CO+HD6lHRxauHPnzs/S6cy30mkX6SRv0Ae33ZMhAJDOBo8XoPLSEvvg46tKWZa09mTTh1lgHgcpz8nsd2kpAimAQIFwra8L9LrzI90bwwII'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= 'pmL0KCZggPVdbn9wf/TxUV3gc7jagedgc5Z94QigyyCVeoLm0BLizfrrA4tDjllbki4tQ6tCDvXFqBpOT9K7seC3pHRmHTE6eYqezb60NLfILRzuTJCfl+cTCzHP0dPzRSFxrMDOWJbV0j7qL47SAp+jv2U/B6TwE6PxOWTjgCJLBcpacuJcQhwhzX1wJc1BJQ9Vb9F4QOnWeWltRx3nACrOLtH2RqonXWznkujdRJRtw2fUKUiaIAIn/pdu1o32jnZFoXmlY0pD5oXAtRnO8lOAjlf92c9+9lj0u0uIXruarT0W9uVMGt0FPkd/yWb7HCju2jDizyF3ixDntFB4EC6uueaaYymOVC28WLV3PDginzPc2WL3nt3KG5VEdxRhX/8279R8VQaIY7TWO0BP9KWjx+kxijm2RouidlMml5w37tdQmZdDwZs9ezYxCXnaRGmio58XjB8/vmLmzJnTly5d2gTn+8K6detqh7KirjJueivo2dsxvQ5W1Sxbspn6heOVLa9E4nvvvXeNvInKzFHSApP/DQqxVfShAqRsyWbc6x1yxogfF3U40Odg73dfn8MQ16Fxm09tyA033XRTB4JvxuLFi2fwbFoEUAPKSBk4UhHRouIib0ftDkXMZp3CMC5OA68CeKdVXfrS0ZNmNnQB4t1ZYZSuh9Qe0w4XCuySJ0tAL3HUoXyWwe0M7FJm7WpAvqsvinEoC3q6x169patzg1Wv+/Js7Otw7HwhPICLVcTJLBVOhBfLuAhHsHghrrA1bP6Diz8X6NZb3y6gW4m+N9Yl7Uj0Llotut78fwW3k3ltLF0GTZJdejoc7JgoYJ+E6rNZgBfd44Db0ZtGpmVLrldu6eqBP4cBg3rgtRe7bI1Ew6gU0VPCj3JTS0vHeDoufGUwKPDY99ZpZOAEXvcIa+a8cRdrewN6jOVPoZin0a2TyIREYunq1QTWiOO0O/0SWukTe7wYoG91DIH2kQL3cCzHtmQzrUI1CpHIG1BR3qaSzfDY6/a1ZDOrwDiVbObv/ogU62L/zSMpD1GGsb9arMeoew4Dr7+YMN2nl1hpPrV66uJCDFGEpvRzkR0mcMvEnQciQiTRUy6s9L06vbiqS6+eUVeio5I8z/LQ+U9JFDIvZhaF3GUm+YLvSqKr/oaMsJlODE3BSEpv2/fle6+d0tXZz2bkm+P6j1ZWVM6M5OVJcApXkuqSqoZG1LdsnEsqg+I4DWG7yVkpHKDTswzDwFxwrKmONe+wwxZ+i1gDlZ0wZaLzoREL9FZWbyaKbPq0ad5xxx3vrV6zxtuwfn03eufXHE/oTmdm+TJAAEQzsRNNgyDp88xNjUiDUTqEmiaT0cXX4sLOFBMSwPenmq27P6lc8SrZ/M53vvNQ+PE6UzFrNLdiemwv3m+f1WwcdWHGwuhscTFBn2xIjGJqMH5mzpzZ+fPnH+pBYnjbtm7rAbWfEbEh5djVDZ7TVpq3Nz/33PM38fYp+loT8dpsfk8qV4ZRyqouAioVkWp9pxCAYtEt5Rj+Z/jM5qZmqTDQQWUaoDwSJw4xNxClF8IozIDuegcc71VsqHoelWAn9eVQIujndUrQ6K0r4N/odeUjAQC3ZDOtZShLNmvi6HqjDdnuGB1MMypIby3QuGv8hQPhQbgQPgxOfOEGSZ5XBq3I89QeRj3cuUMjqifTScDjGxwK6GFVrzZXdckmPXJFLyYs0AHvhvBkpof175ziRTZxugOek6VDINd2edLTFznqSwneupmAPAbgl+IsuBeut35vNCN004fRUa+ExXg7+u+FuToRb1ey9L7e5BwOa7Mlm0kUXiAwDmXJZqlDCnfW9aBqAcWINp8e5Bqj008/fWpff6tx1/gLB8KDcOHo51HhBi+7D73oNdQ3yNNpjc+ebmCKcDUg570f6ucKNmt1gJ7Yl8SLpAU64F1BUP95gLpIVxGlk+QigZ/K1HThuHQkZQR5fFfx6dqrXTcdMTOrCN54rVnaEjqvmX2pvQDp'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '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'
	$Graphic_BG_XParentDkpng &= '6H2ZlP4bjM0MG/ZNrmf6T1FuChZA1QNZ+xz7I4w7d7GhkQwt8Jv/Ql5bkySYU3tDgDXbVCPIm8G2aQZ2Bdw0bjXoj6aXj9A3A/hP0uwC8P14zPMnaCaZKJ8U+DhJPCz8v0MzD+zemPDG4ztuAexRhLvKez++oNfQU9fTJoJNhlHNLxgfw+fMqp4BRTMwORJ6BZhjsF0a9fZ+4a5Br8En/NEi2A43xyyFnCPhI5AGO0eCzzFa/nHBrkGvoed+NMLPfVpWadVbUWVVAIf9aI0HA3cNeg0/xywejzs/WjWkhDfCXENdg/4wLbsfjiSCWwN9/+zf6hSx40rN/s0AAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Graphic_BG_XParentDkpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_XParentDk.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_XParentDkpng

Func _Graphic_Centerpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_Centerpng
	$Graphic_Centerpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABUFBMVEUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJCQkAAAAAAADi4dw9PTsAAADGxcNLSkecnJoKCgoAAAAFBQUJCQmop6TZ2dWSkY6srKitrKizsq6SkY/a2dbR0cvR0MudnJewrqt5eHQEBASLiYVjYl9oZmJcW1deXVlMS0lQT0xQT0tGRkNEREJDQj9FREJHRkK0s7BMS0oCAgIAAADMy8asq6aOi4dNTEi0sq2Pjol2dHDGxb+Fg37k4t6amZOAfnqpp6Lh4Np5eHTh4Nx1c2+rqaR9fHeZmJOMiofNy8dcWlZ+fXl6eHTX1dGsqaXg3dmBfnphYFxmZGBpZ2NraWRoZ2JjYV6LioaLiYWMioapqKS0sq7BvrtMS0dNS0dNS0jDwb2Yl5KenJiamJPv7em5uLTX1NGfnJiYl5G/vrtwbWh2dXG7uLTQVfgZAAAAN3RSTlMAAQcGBAMUDSISFR4aC/2MM+6sqxspPRrN/aPm5vmj/fz8/v70HvXT1fX1hvX11fL+8tX5hkEcdfeuxAAAAOJJREFUeF5lj9WWhEAMBTvppgcYGHdddzdk3H3d3V3+3xeGs097HyvJuSliBQSGiEwA4gSoSw5NhmQXdQggD/o9Lx5/kCMM5zyWLdf3m+V4jNs7gpoY3dWKD8X+20hGFQhhclL7vNav9NyNlpIZITSaft17ev7ovrd/1qOUEHSP1Sr584vLfKU27kawwETPKFW3D0rG45QNqDL99d0otAo71c6MYp0wvjE7ODw6Pjk9m5vnzK4VAwvm7d29uRgQ7VqgUti7tLyyuuYNS8PnASXRF9mM+EQJ4U+OK1sKd+T+6f8CPNIdtjVm9ZwAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Graphic_Centerpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_Center.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_Centerpng

Func _Graphic_Glare_Partialpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_Glare_Partialpng
	$Graphic_Glare_Partialpng &= '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'
	$Graphic_Glare_Partialpng &= 'LACEUikt3XZnNwCFQhfZSpNa2gDJMJnVgCiKqADxkkSTCCrjLQDeUL9k8yaEEwDCjNfk9wUe/gDvWR6fQIkLuwBLKc3DnponjwBAIZe7v7++LgCkWA72prxyCAAqIBEUniIu7QDuYskMgUPKHgA5ImcLLnF3cwBze5vVeDiw4QAvSqCw606egADElV0RncNL7QAdQQlPKBYKhQBqtZxU4Zj46gARI4oovMHKZQCRXcJx6RdUCAASnuARKDSblQBKJSYxAhzbMgAfHOEjXIESMQC7bDbbSK7hhADU2J4RlGg0OgCdTjyeVwZwUgDM1Y4RlIhjkgD08KBt4MRmSQBKBEd4hIREvQCeSCREZQEnJwCLu0fUHSKRzwDXarVShsAZqQB1+tiBER4higBiyo4x4LyG8QBHR7hECptM2gDt9ohdwJkR5QCpERMkRqNR0gCuNN3C2XHmowAjUECiNB6PtQC0SiCE5l3RRwCMfISmaWlM5wAJhJLQ9Y/wEwDdrmmaOsO3IACkZNO7kycgoQDrOoP1LITCogAY/wgUsNVKUQCUHmsQCDF55QAbsUKi1+uxTgAygVATWHcEJQD6/f5wOJziogBwm0+9Ea4wnQBmMGMGoTfYUAACW69VVbWWEABBnOUKDrHZbAB4njc4iKSZ4AARmGVZMgcR1QAaGI5gGYYhywCywLUgspZzGQAJty1CkUW2CwBhbrdYDJYIRQBrcQPnow6hqAAtMiMkDOc/LYAXRx+XCeGz8G8AAElFTkSuQmAAgg=='
	$Graphic_Glare_Partialpng = _Base64Decode($Graphic_Glare_Partialpng)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Graphic_Glare_Partialpng) & ']')
	DllStructSetData($tSource, 1, $Graphic_Glare_Partialpng)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress, 2368)
	$tSource = 0
	Local $bString = Binary(DllStructGetData($tDecompress, 1))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_Glare_Partial.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_Glare_Partialpng

Func _Graphic_BG_XParentLtpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_XParentLtpng
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= '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'
	$Graphic_BG_XParentLtpng &= 'kKcUyFs2sRvoOuzKdQX8N2jdi+K7gVVhcSqBPqaVYVWmoYlqG1rU6L6CNtlrWBl8aQGXAFkFvMnAhcIIbxo7wQQw0WYDG2vyGhvTIhgNJEogo9WS0eamf7oMXMIdR297zV9hjgGnTQHg29I/jkT8Y4FbtcaH2epRcayqHNKqJNAJe5yo5tCs2pklrc6cRV/1O0jILsJbtw7yoz7sBsD40FM+DGNdfO+DyuCsitbjwu3nLKYD8xbYoB6SWEk2PzS4+cQJPn8/TDgJeQL9oRNVBb5BO0PgZTMyVlWvwb8/jTJba/SImZGvzSSiyS9b6RsdhccHi5UZRgWcwHuLPAaEjCz12aKQ39aVcVTSeccv3p98stfR713ne+xQTva0EWqM+rzXmp6l4l6zb4JwY0SbBVS4FJntKaU93vweAL+FRqxPkMzaFjcCTptyDxocdcKZQCciBJ52phUA3wHkF9DA9SYe9fjMXHuu5ZissV4sc3tGzhR89qTBYclZaV2EArzOHfi4LwnkhLtnqbEk2pgxkSz0vnATTUYBcKYAc2MJiXHfo3l5hRz42hSzmi7P4wWZ1/zIbbZHR2mfFRb1SSTsjHTlUUlm9+5u3Ll14+aNz5F0/qj+GyLgTDaDigohT6A/wsrMFFdVGeHVwy+jZCge/m0sNl3AAtHcJKgIbI3J99dBwhb56eC+smw5vnWJqyPh6Cu0JGGi7fv8yu8PXy/RCrAjWxvRzPUZkk6rg4vuBhHcVjcHFRWVBPq/lKzWA+BnoXmt0iyJ0Lr7Gjz8ZfC+2MzzaUVPLUHJjkh6eomYtl1MD8l0f4QxrPIDwI0VRRReGLoZof1+doJsc7973VZ8J3TLWmmRm2DLr6K0c8fNxsgpBP0tXLAoq2j8+kKhvqPa1AWf7QDw/nElmwn0uBQZR3ir0hB6LH4uXnrq/PlXFubnn5zFhRJhrTKiOqvACAr4raNPe0P4XvrzI7+4GYNH+Mn5hbwPIzZbfq00WeAc+l08qfk2Oh6/Rp/9qgK+aXCzihJH8OMuGSbQqazC0jSgUxblA+gXsDn46pnOmcvw8eLrmwL9CCjzyEDF7313cxnVOgAqF+3xIjeL2Hv4QSCxTEiDZi/I5pAek1GUZkeG1lKgrbGFdUma52bS6/B2jzIstrvbewjem4jeNwH4N2JHVISb0btHD06LQvFKoP/HgFdNq3KF/rRCP+eB38bi0/OwNs+1AX2z2Wph1bXOCM2EUPer0uaM6NZkUpNLrYzgVe2cJCrcq8GjMAg5t+FB7Hm3RBfjqBCTKeQFE1uwiGMoBnhI8W53BPcqmrm+FZidCHZX4d6Beha9VcOTAXgCPbY0UBTlCX3TB9+E3u4OVl5faM+3z6FFuN0E9Y08r49Z3+bXDm9RDvU1Abs3Oqexi5bdNWmXhQe3A/S7ogDsXcIdRe/i5FmUBDqBjxPXKS95nfHAb6paAr8vOUcR4F+ah69HrX4hz/Nm3sgb+D2ViW/hEn7Yv8L7jFO2BwRvC5LUTKN3WRTlHqDGiaT7gLsHsP+AJbkNsH9AtcRKfzu+9LVdJ4L9l5dcDuIEk4An0E++rYmhJ/gNT6cCNZ14n2ND8lnksyvQPOA/jXJmDs2g92Va+m8wunOiMVe7nrk/SrnUrwBUd4OEcYj5EGN/HxcaybD5qfcn6tquSIL9nusCrKrnRJB7ge6ZCHYMN8Urgf5/jPIx9JMB+DOeGiLOg3u+v06pZaJ9ylThJvHCsxB9SiOwRWODl/ecUz7YwxjuOHo/vqAn6OnrqXqgaX+k9APDseYpqz7FDDIwOfrQ7/tjoAFFv31IuBPoCXzCHyoC2+DmmAWQM6L7sHMcciT4HCMVRwV2Aj0FgSwS4eecyirEiyorFAPsz2NNPBK4E+gJfhsp3le9P1YMaRyVeZ+gTqAfp7KHDyQxuAnoo9Pf7w4XX1CGY00AAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Graphic_BG_XParentLtpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_XParentLt.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_XParentLtpng

Func _Graphic_BG_Redpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Redpng
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= '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'
	$Graphic_BG_Redpng &= 'DD6dcu3R2nU+41xosX0jqNHa917nbC+V+hpfQnCjxTILqMQtqNL6HKvP3QLg17EQ6xMEsz8Z3AKcbgp3z3qEAWcGXXJxZobBagT8BJCfwyKxd1aWV86OxqNhzeQc8WlgcCw4hp/dIxwMziquIvTAW78GH+eVgDxQnyvVWAlt9BRIlnYOzrTMGAA7A1iFJSKmfkcOCIMc+LLb5L39oIVwB8CHlptuj7U7gNuzWPJ9uTISjDaTZpurt+9cv3L1yucIOn80/xsS4Aw244wKIc+gP97MzEHNqsrCmw9/HOVo3od/D5NN50aLo1GvoaL9x7386yRgg9oC11hdro363YqzI3EbKnZJ4kA79PM73w/3KxRT3EO68Fcs5voMQSfz4F6rkQXn7OZOW0Ylg/7PBavzEfCL0JJlaY55YenuW/DhL4L3o4OiWDD0zCWotCLSAGI5H8vFcImLnWIb1jkAVFhRpm+u29Y070GwBTL74ep1zvgesJK1ipZbYPtfZfM0nqQb4/cq376LAy7KNVTif2FQ3zFNbcJnPQJ8+0kFmxn0NBWZWnhmaQg9hIKMC8+eOfPG8tLSM4s4kCKc67SotasgCwr4ccV2A3YuWcFYPR7LoWIMbeHnq+x5nlpsLfllarLEPvQb2JX5JoohvkZBxTUDfEq4lUVJLfiTThlm0CXX4dL0ocO08hH0y/g+z2snJicuwo/3fv3AQ98ARR8ZqIRr31l+Z8Ee7jfWHhdVLMJnNBBErALSqKgCYt+rrJ8tK7ojnjVnsYLFDpU2Jg1GBL+iB7i3y/W19U0Y7yms91UA/o13R0yCW9Z7Bm21uygCPIP+LwTetGAqDPojBv0oAH+MyacX4dq8MAb0g8FwiFnXebPQJD+s55Sb09BtwaQFl6pPtZWTRCXa9cImkwS5ZjRVeodzBrrcJ8Y5g7xUYIsbs83NHXyhe2Otgfsa6jW/bWCGBPaawX0PmtF6m3afDsAz6KlLAyVWXtAPQvCp4XA4wczrS+Ol8WksER4PQH2/KOb3yG933dtnvr37ngcbn8nfQlXQ2vT36Q2/XBY+ODfQX6MCsDcEd2K9y6fNRcmgS06tdmAOgtdDAfgD07CBX4JLMwb4F5bg1yNXv1wUxaDoF338PuictuxVErwl8HTqanlA9FgUpDqz3lVZVpuAemtz8z7gngHsP+CS3ATYPyBbwtTfvVB2bcNEsP8Kgsud7l2toQz60+/WpNBDtPbS4UgDE8+LlZWVk4hnT0FLgP8I0pkFdAgVUAt+/Q3ansOBvrnrrv6jao4aLIBanyBg3EV/F+32fRxYSIZC+tmfyGvXSRIUh9zywJpmJoI8i7RFCewUbklHBv2/aOVT6HsR+IcoDgD2k3M9Py+ZyyT3yZniIvEycCG2KVpgWmPCq3P1qQjs3RTu1Hr/f0HP0Muvl+YjLUQtxQHDdi6QaysSpwimWkFPgNlG2qE4cB4e7gx6Bl/qxUrAJtxqXQQ5W8FHIAk7WwGvNlX5qMDOoGcj4BIJfvUl16r2o2pTB8DqpzrwWODOoGf42Uo673o+VQppapV1nqHOoD9Juf0bkhTcDPSj098D+MRf8OpVlwAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Graphic_BG_Redpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Red.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_Redpng

Func _Graphic_BG_Purplepng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Graphic_BG_Purplepng
	$Graphic_BG_Purplepng &= 'iVBORw0KGgoAAAANSUhEUgAAALoAAAC6CAYAAAAZDlfxAACkNklEQVR4XuyXS28jRRuF37bd7VvS7UvituOZRAgmGn0bBBpArBE/YP4tYseCZRBCWSBCCIjYbTtx+xLfr5y35HKVumVpsCaA/HVJj97qi7166ui0QdF6Hxh/6/5u1u9wP2IP9hc9EtpQE4Suw++/g8RrNdU+eP18ByASPZI6TIyR+wBGmN2i72AVYK3vdfaUPxI9klvJHCAehhKBycS0aWiT1FQJHRB5qaZgEZhBVgFC6R+xW/RIbCmvwgxg6VMSFD+c9GqFkjss9lxjps8AC41lJP5u0SO5lZi6yEmNFKPvi8Xiy1wud5FOp89M0yxalpVLJBJH8Xg8DVLAjMViccYwDCE6rzUW9jxWWEtemHOM6WKxGIPBfD7vz2az9mg0avZ6vT98368R0URjqu8V6iCoAxNJb/x/CR6WOyB2SiMjgcBOtVr9+Pj4+FUqlXqZTCaLwME+k81mYxCdGFxvgfgE8QWQnyD7Fki9BVIThBZAbppMJlvG47FgOByuMMd4pz+dTn3IX396erqt1+vX+E2XiEYBJgolflB6SST6IaV3WG5LS+c0yG44wqpA7M8g9mtI+wKc2LadAfyQ5MRzITIWx7M+9b0QeteC+Bgi6nmovTYhOEFsGgwG1O/3txNJP8aB8HEG6rj+1fO8KxyKJhE9gQEYbhhryT8LS3/4KW8ctODhvm1pYmc2Yh8D+/z8/NNCofAmk8l8BNx8Pp91HIdQTSSc0iyvADWDp0xmvpZ7+UxHEz8ssw7qjkx+fS+fyfdE+ne7XQlLT+12e4zVguy/Y/9jrVb7iYh6oL+RfwhGmvizYK8/VOGNA64n8Q0WI+WWYgPn4uLic/TsL1A/XoHSycmJCcEJkyC9FFtKzJOrBkvGexZQvIMaQ/i9qCw4JHLPaS9rDL8rK4xeW2Rd4dQWE5ISqoncy1rD77Po/F/8P/IQiCnFR4+nx8dH6nQ6PBdI/ja4w/6H+/v7KyLq6uJr0s82LJlDrDXGgQqu0lsltw1ypVLpdaVS+Qq1438Q8uz09NSE7IT7hKmLzfLIDs0ys7SiriDt+SBwyot7z70gPac2i8zJzYh76OvyG4APgC4+pzu1Wi05F0j5FurNL+j13+Pez0TU2YjfV0mvUv7QhDcOqKLogqe1WpID+cvLy68h6Jfo1h9C6CMIznIzUm5GfhSywJzMQmr5Lsu05wr1cL3H77OQ4ELkh4cHkeAQmeWXH8EsvJSe35PvctIPIfyf+M3V7e3td0TUltJr9WasC//vVppIdP0D0wwIboM80q4Mwd8ied9A2heuW46Xyy65bonS6RQtF2taLEV9EILLTu66LpXLZRZGE3T938yFNTDWSPcZeQ2PWs3WtrNbpkWmpaoO+js1G01qthrUaDSXqDUNCH99c3PzDQ5OXZO+HxB+rn+4RqL/gzVlR4I7oGDb9gdYbx3b+SSXd8qlkksViFs5O6PVEl17heSGGJPZlPIQO1fIUbVSpUrF3Zwbeu/JHcc9WCI7upqESatgssvrvfE8j7yaR37XF+JbqF5JSB+PJSgWj1Edz5sMkt73O+1er3t9d3f3LeT/jYgegQ96OxJ+zUSiP6fgsqaoDn4EHPAXe+8BJ8lVnYt/1TFMznl2Ns7GHLTSKgtFQEggJBGdMGBA+AE22NgYG3g84OEI+BkjQGQlECCUUNYqbc5hZncn55w7d/3POdX3d19Vbc/s8hfW4z2q925NV3dXV9/67rnfibeUaEnTsmXL3l5YVLS5uKiosrq6BrUE7vLyMkuZTCYRjSeJZ0dQWFgEfr1hUSPoRafNLwt3Pq6BCQ1kbooTa8VQ723v0eB3mR1tFhl5rmmU7W/1mmMA6Kuk1+HRz5HR5svOri4B9QSbJmenESbQe73M6X0YGR1GX28fSfh+pkBjxP+Pnzlz5hFSiDsADGvAY0ZxeEVnXnvA/x7ohoOHhwAtwQFU'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= 'CSq6f4MJyAJYyynVatPmTSy1bZFrfq8fNXVV8PuDeOqpp9De1o6W1lM4fbgdRbOVUms8hAgrQeJW3vnGi3H7n9yKXQ+/gsfueUZL8SwQtcvao+zggAlFU3RNlRwRferYQtLbcJSPO9e25tJm1CyrxImXTmOwbYhpynxS20ERNJdWgDFkScaUQMzr94rVZv1Vq4jjD9Js0YL5t4UlvomM7kMt4V2SXHljFXXTdEikO4NdqIw+j4nr//AKXPbmi/HAt3+Olx7ZI5QQyFgRj540xvP6iJYtQfPyFViydAmuueYatr5worvNkajwQ74VMTmPDI8ABlhIHiAhyR7TE9mCSCMXItWNC+TmRQBqCMxb1q5Z8wVKpqikUUe8fCmoEBHIls6cSpmPhHOR1GdTIzsROPRWigsd2n8InsEwgrE89nNKMrEBQyLokoijrLYU2y/biufufwU+6HBVtxQXxdMJJAXyC6YnBnQpuIU6rK65RujGcOcYZidmqMXP1/qh6zKKJcP9t2r5xRGR5uUNpRjrn0BvS7+iD68F6Bc0VaaznN/Q/SVHlM3dtHwTYlO/8vYd2L1rL0b6Ri0PatabHTVnJAs1GYwiVT2LDVvWS5bRZZddSiG+6zDQ1yeYURtbqUoKi3Dk2HGKXD3KodqysuDczMzU0WPHvkNSfzeA1mzlr8nz5erGbyDNF1Gk2ieIh98IAKVlpVymQty+RGdslhZWOlQW0a+feALDoyM4eOAghlvHSZpXSbKBtrIY8kib3C0JfiaKJz/0piU5LEuFsmPbQKx4vc07anuf33HO3OA23HQAocIgbv2Y/Hw8/K9PiplQw/i13fII7G/+82tlcDz0j08gNhP7jWzqadONBdOxGofqM1NLdZ1zahcyNt6uKg6YAAIIyP2xBjRE+Y+ZUfmOybwRlK8sFKzwIsdveMM1bHJkac3URVmfOPGGHUsi1U+daiHhOAoAnBB/oLWl9XtZxbTzQqS650K9oATeasoY2pTNl+J4FZHYEpkYjeolBvnNdMGBgE94+ejYmCwINdw9iki8SCSBD34BucpnNKx0MnE+RKhRp7mkuCJliv8q8KpzuKNW/NofCL8j7DUjTT3T1gW9d+eVGiivKcXBJ46JLfw9X3grLrp5k4OxAsYFtXNv22/eiHd/4VaR5AcePYqKuhKlReQajGJtyuhQXfW3dtwbTg6vPcQ++Lm5AskMO69XocHS+CG+DyMs903VlFT3ygrksO5xfrxYzKrW4meDXKqEgS58Hab8Y+wwjhhPjCvxqEKOA7QS+BKKjarJGkMKspgU2+j/X+piaGmOUpbmFF32keqa6rfBNCR5edXqVdi8aTNfLHMrBrptWZFJOvY0mRPZ8/Xqq69gpj2JgmiZzHtvufMm/OGn34nHf/gMfvI/f2bj447N6bZ2HDfms7DMGwejuL1bcruPGzDE47nlxvXoONaDwTNDKKosRP3Kahx/oRWv9bbm8hXoOTWAiaEpVDWVY9G6ehz89TH2oObwlprzSnlZFkZL8wU9rkJTchgxnQkgcFtlKBH8Flz/7qvwvS/eh1/d+5gcnQqPILzEix07djCYSaq/gXk514Fhc6NtyUnG04GDB0SBnZqcAgBeZ+qVtrNtP9JSHWNaqsP8TSW6Yc8DlWXIt0JLc15JgY39TE9YqVBAl4un0YczrS0E8knJFRztmUBBokQ6JmgEqROuRkFxPq5/x1X45yc/j/WXr2KAzsvHPXZvZ06QW1LIz839uuFXDiYYFgA0lzX5uVLEnFO9KfUMKxpLEYoExP49SSBUIHdXFBBq9Ru3Ey+cxdTQLLz0PeGCIKoWl6OsrkTZs1VzmA5N2YsE1wDnZlOynZlUhlbSdaUyeeaeP5RH2O2Blr3cx7v3/zPe9Ze3IZIfEd9AIOu4K4iXYqJnivHAjiGVrMF4URUEVAy74KqmqkZwpjb6e3nW+lKaxWTgfKS65zwjFKV0BdnJryXvZj1TcIpSZIkuLlu1dKEy'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '4HtfuBfjE+NimiyrLRb7eCAoFbtkAd6ekwOABqaeirnA5+JyDHeNIR3N2CQxPbMBSIFclWLz2cOTFcjtlMfAObOZ/GEfyhtLwNgwcoDZIbEXCA1weX1zPHfzWSEVGVA/lGGsawLJaMpGV9R73elzpoDbI8DQ5kd+KAVV1zBPnTMoKxQOomxRqVjglPlTlbOImTH82ye/qeDD7nwxLizd2og3fvgarNq5As2nlqFnvwVsTwAu61ZGfS8ET9TYNG1YSqj2ikInBEFjM+ey3G6gm/r9aizxEyXROQwgO3WkUvJqIls9iZ4w4GWv3PyXVl6HuCnKhyyYW2xUZGuhBxDDHB78+i8B7T2TfRBhWQzgijsvxrY3b+DXbascR0oi4jCaGpjBXDSmpTn8bkg5nCUpHS8DbVXI2KSyAnxG4GTqCMUUULOynLOHFrSF/5Y2G+Xh6Mxqup6p/hkCetrG4VNIusCuQKyCyUxNYyDwMpJsSFChAbbvUiF3aVh6WN3KSuqHsJO0Sa36PKt6mi1WvXppJZZtaZKVrydHpnTEagK4ouImsbJIqDFhpMQQ7i9mUsETDHFKKp6uK8Rlv8FUex4UCucwbXjOLdEF5xlWSBULkiL6ciKoUtEqXFIsMIa4X6UTs/UVgyhCGcAXLA+fHFP27ZBFYXSGkaP24rKtTSivLyVO12uD7Zl9HeIgScZS6rCL72oroqFMY/aEYTfIVciBLfzU0DRHTjjaPo50KmcJC9uAu+CmKUyuYzaLSPe+AZkhk/GU00KkMnicaXvyef2bDdUrORKpTVeckpldMG2wbVQBzynxlZPJ4bgyzmUYEDyUoIIwU2Llk2Yx4jHnxO5vAR0cd66SonnP+BMaYwqrgNWQdSZZSM/MtxCAqZsYYdOmCZ+FF80zzYy4YdkFq4AuADchI1AuEBDQSGUtt7XF2q64Y4e+Qa563IZkDAmPm5mzWWk473HL9WvlSM9xTt9z8lENcr0t7CkVHgroknIaZAKoyuYSLNpehxNPnHWezx3Xnbso0sLKqpnWBUNzUxwJoV15/RKL454YZuWMoe4QZnBydn1uzYSh9Rn5/tzVA7we1DZXY/mOJhx8/JgCM5rWNaD50iWYHptVw8JWvmnZtsVQmzgX9YBUM7l7fVMjzbgSFKuquumUhbtMOq0SgBTAheIAQnF0NIIN027qIm/KUI97vaaKDhVwWxdlCpeKW6sQCNjD4RB/KQfoyAX64JdlO4IuX5Q9WeCNf/aGeRcU7zjajUd/8qRtndDZIUkqUPmCEq5b1lCK40+dtoE8VyCTOq7AZ8LQFbuUaSsrldZRgc+xrkmMnB6X3x6bjGN6aDaHBDbkueL7SndQC2IZpi70qctNpO2D3MwC0zSzpjZdlUB9l9pPDk9TP8SlipcUOl1RgeLGApx6qkPZIdT7mao5dBcvK33zgd2me6x5w3K2cklCOel6HA5s6wdO5L7lL67DzPicKKruGQHy2tMPPYeRwVGUeaq4j89pJUqYCUsB9gA+n+hsQo1FqKaS7LDkQa0cmAx6BXZFZQS/quWkLhromSRREhvZ12lL4q1SEl2qA6hKuxmPbfqz1VKheBsZJDFzDt/++nepfc9BWeRhe87ALBTeJptM1W0HusXEdeNHr0SVKvDp4OR6yx3Fp+qIZwy7DE4hwYNVVp+74oPbJP9y4Ngweg4PIhNHDsktx201G9NmShReBbgA/PbB4bT5G7BqN5pJucFeE7JXg8DUUl2uo+fAEIob8nHVXTtQ1lSEA/edVDTDZkJMzbugshvsjk1Cct/wwZ2SbN5lFTqV+6AEw/H+w7hl8Xtsn9V6lWk7xoWL/AhkZwiWwO5qAuKT8TCuWPeTZApFlRl3GiseQyVfaFOjpXykNND15rNTFmlpAnrc6SxSmxVrEOcmdTeCQSnwL0BPelKAxAgDO9+6Dduv3yyVVwOhAH75jcdx5JlTzM9VyWdXypUHTieR11WAaLxvEpe+0yrw+aNP/kIV'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= 'Eh7cmN8M+O0ZQAWeIqROg8tmOBauApqvbsIf/eAWWe//6x/6Lk4dPI1yT42S2ArsDqnuBvyF05WFA7zMeZVnM+drS7yrc5SuM5GcTaHI61C2/SaWF67BZHr4vPq4Lm85EDCVUswgF84fDU5humgYtU2VWL1qNftO2LTM95vB7AK5womS6KZWQLtJIArQlTR35YS+9kBfmKuTJv0TyuBuLCjIr1MoSCZZqmfjRzwW8BW9YUfB6dZW5nsS92AtmJrAUEuf8D5PolBXcZqKobl8LSkmo4gVTfPA4AHEkkZs8zTyGeByg4ITBXzDpP62BqSpJLfLrr7y6sV4z91v4pUeBOQnDrag0lMnnlYAucGeo+YX278Lq/IRqQhLcdBwcVAsMYF8P3wBLzw+OlfKRCqRRmKG4DEd5/otspTMzDC1wTkOMzh/kOuYmvnNpg531aw5y1GiOh9zOoFVFesxPjmA2aKJBfo4H8sKV9E1x+U7EpYkl+KyQ/ndKFtShDVr1jBlkViW1tYWSahQAFeOIMBQISQwAYUNzjIab21tfQpA73zc/LUH+sLe0mEABRTE9SyN/LcGAoFItvtFMfUEslF1Xq/iYczhRRk9euwotm/djsWLFwuADyYPkgWjB76pxUCKO8aynBaU5mFT2cVoy5yE2RDn87D7mAHPUkY4ZWbQi9rQUvjnApgYidooh1uhNAmQeXjv3W9GMprCjz7zcwF5haca+UYh3BtcYFdgDOUHUNpUiOKGAhTV5sNMm5gdj2F6YBbjPVMobSwkZbVPAPz2b16DBz7wFHxBH5ouqcFU7yz8eT4U1xWgZn25VWO9bxrj3dMY65hCfCaRiy7pZ26Q4/Z/uw4b39bsPCzOp13fOoB//8K3kOct0PrBSAqlJQXYVnEFWlKHkW6YO2cfpwc9qAkthmfOh7mRCcTMKNvKJSpxuKALRUvDAvLly5ZxTUQcOXpEDA6Apq/K+8lbMpViTKgVr1nYJYghHAHQkwX6cA4v6H8R0LViOpcNlxwkOvIU0ZHlZD7cDtMUlKZYiuuiR7qiEzUG+8T4hHTG1q1bsWLFCuGBx9LHMNzRLfEwyFhu6sHWUdSvrMKWwksxlOzDXGgCqKDz+vyyKnVkrhClZg0ycQOD5EVUUtg7D79+/323icb/7Hd248kHns2aNktylVSzS04DUiKuank5A1kGtJkycfyRNgJ6Bk07atG5u1/OX7WmRK24zH0gs1k6mYa/0IeBZ0fEtLeKUuS6nx4USb9oRw3qNlSiYXMVxrqmMHx6HJO9MzkHn0qEeOYXLyD1YBpjfRMyFL7/FQsTRYFSFPqLsXRnA+o3VqGgMqxnAy0IxNtbvbIc2wovx2CyW8JpTd3HCFMfl2SqkIpl0NM6kDVRJiSRYqioE6ElHqxcuRKrVjWLFeXwoUNSgDajeblNb6N+kH7TmIBJzqQuCsPdnQX6YBZbc0oB/a8Duhvs8eyIGwGQRxaVH3ESNSkgjQrU6TRTGC8nU9NeXLziUIUVrcYVvthuK2Bfs3q1SPaWTAtGOrtRMdmgfhp6Tw3STSpAXf1iRIIReOeyHC+VIcmXxFjvOKaH5oQjK3Ba/7ul+m1fuR6Vy8twelenxEsHEBJeLu+3FwJygl2kb+2aChTW5GFunK71uU4kplO45atX4OD9Vvjv5MAMPH5DQNz6VJdQlnTKVKWdxYJ++mnirck0BzEJdZnomeQuoUUAluDpr+wRClO7vgIrrmnEVP8s+k4MEeCnXSBXiubAi1PWcUdYw5QRRRRpbLilGSX1hRij78m1DZwakQUIGuqWy4JjxpwgSxI+5qbnMNw7KokyCcSoJcTCMljUAV9TmgTVSpbmsqz5nt17JdlZgrIY4HwvDM3PM8zLtQIqVztKMQFkZ38yC/J+wZSFrbgN5K8L0LViOpWNQ8jr6el9hOjLO8kLVgQLz0ilk/B4A9aoJsCrAAdldx/o78fRI0ewYeNGjm6T10+ZLRju6mGwS4CQbEMz'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= 'I5xh763QNm/QQN9wD4ZCXaJoepriaGyuk0JEm4mHNzYuwvjkJA4dPMg1V5iy6Gx87QBiYaNAzq+7bORQuZ6jo1Nn29r3ENCfc5gQR3MV7f+/FehaQdVgT3IjSTBMntBhojF1pKgWao4C1fnMm5mHCjcUyS/okLfZwkBnpmdYmotULy4u4kpRorBWEodHMI2Z4DiikWmxHbef6IYR84htOEGgT1hu76xTKMN7ssRsRLLEmiG0kumYECWzwCWdNYrd0tp9zD0IdMJCNseysDwf1fVV6NzfZx2DpfzFEBU9IkUtQUBs6TqOqaIhDEbaYdbGsWhlA3Hwi7Bx00bpi2g2hugEObhGx8bULCkAh0dAriwqUmFNLfkicSupZJaymcohZg4NDY8QH3+W/CW7tccTfTqDPzcn/7+JurhpjC5JHQFQDKAya2tfRFGL7yEFs5mkuwoZULEx0hRnFy6fFnu70vZdXlVSdlFTU4slSxazlFdSX+hMX28vujq6YY75kB8rQUGsFMFUmG+6CnYSqnH7/7wBr5540QlZAaRSokX4msrbKRCwDogiZ9mTFXLVe6CEIdQH4bKrG/p71Jtx6bor8dO/+jUMWLXQPfygfcI3J2X+pkNjQFkC9YvYIlUv9IRKfXNfsAWFHT/s2JI6O6ayiUP3s5gNPXoGzfavLW4FgPJ2sq7VTdaZxwB0OCIRJ9yLaUnD/91Ad4PdkwV7GEBR1rFUC6CRQgZupZCBLQW8DLUB201g7i6hviJlsgX2paRZmvGgTZUm1LSOUCiUXX1jESoqKvlcHEcjnJRukoB+amQGxnQAkVgBArE8eFM+LN7SgC3vXIVDxw4BpgIu1Kp88lwpjoYFznl5Nkwl/GHzLuqmlFCdDqhMktYe2LJ+Cw7e14qu/f1I+5OIBWcRC08jXRCX5SlrSEdZv3Ydg5vDaIVqDQ+PoLOjDQODw4jHYi5nnGWuZIuK1/J0Wo4grpQsfDwtfDxjI2rTxMfJstJCZshnsgDvykrxEVVwyG4nl4b/d4Du9qD6BOxaSa0GUE8K6k6yolxH68RXG9YGaaJ8+uWmiFVGSXdJzUvJ3nqecQaKSWhpcVExGoif1tZWiyJGlIlLM3C4KUt6kfhTowScaRN3vOt2xLxz/B4n1Vjo+ULvcVlo5C/3e9QTxeYkuC0PhXjgJz+Ft9BEQUkBqqorUV9XL+HN5Hnm94i/gZKN5XeN04COZ72apgAbejaCJ8vFPTBYmgsyJc2RWkqnvlGTHW20ANt4W3v7Huqr/VqKY0ArnQLylNNO/v8e0N2BYD4dMoASAJVKum/cuOmOqqpKpjIhAaxWTqUpOgO9iJiNztgpjaZBpA+oZWd4KUBxY09MTWCgfxA9nd3o6e3G9VRv8PTpM2opcWi3fUbRCZjauKIlMYOUGqAsLNnPGllbOv+Tz6q/7fEwcmr9fYChPMQCTsm4f+IJqnRbV4v6xkaerdhpJrPa6OgID1g2uzJV04FVeuA4Y8YVTVH9pyrbcnNW0UqSI6uL+P2vAXRrKY4h50pxNo/n74Guwe7g7UXaBIl6ckdfTUUvLyGPXQWByDC0h85pGVDgVtGQ6vm5OLxK9BDJTnqBAF+m+0xGrDf0fZJBYyoJa6MXyuuvJ3QleGWvhoeWorJl9HkcfMZNV2wBEoZ+P8foj4yMco6tXL+alQiEDEaVCOH0aJ4rnFY1BWzl4eRmm1no/JM0gI5QaZNXRIJbrT/H4rYa5L8Hek4l1Q8glJXupQAqFeDJPf12AuQKUqzC0Dcul4RnwLqaANYdXqAAwJKeASTKazweZyrDOoE07cZXgNagNp1UxbDrmWqgmDm4ij4soLdHF/Dv0dfKcSg8EFnPYIuRcsErMNt+owPguuk+0hLcLRiYAiVY4aTIxScdAB9SVhW1Hv+CSufvga6vyUFl8rR0RxWAWpbsZDK8jKRtDYHPq0Brn4rdgF9Yyss5cnFrPp+AXe3VTKIVUK2gasrhoDY68EsNAgVq'
	$Graphic_BG_Purplepng &= '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'
	$Graphic_BG_Purplepng &= 'blrjQU6P7sJOu6Yl+LSBym2BHUGPTsAEIvwcU6ZFPKiqRSHA7jgUzDnAHUGP8KulOG/7fKgQ0tArcx6hjqBfpMwWHEkAbgR6e/obY4CSGXwANTwAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Graphic_BG_Purplepng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Graphic_BG_Purple.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Graphic_BG_Purplepng

Func _Button_Leftpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Button_leftpng
	$Button_leftpng &= 'iVBORw0KGgoAAAANSUhEUgAAADAAAAASCAIAAACSBMrtAAAACXBIWXMAAAsSAAALEgHS3X78AAACiUlEQVRIx73Wy1LbMBQG4P/IduxAaMAElykehssUsmuGHd3xFLxdeSFWlDXZcGk7gSSdNJIl65wunDHTIaQ7e6GNv9F/JM0ciQZfBkk7ISIBOp3O5ofu0dHh+kaHQEqpr+fn329vr75dNWYUKQIgAogoIs9cWFu6klkEEkaRMaZJo5RSAAABQEQi3jnHzCIMQRzFhSkaNVXV1UcgZrFFwczMLCJQqFfWjFGEVwSCiJiiWAhAKWWdbdKERAs0n8+11saYra2tIAjyPK9QWZZNmkVBzjljTKfTybJsPp/f3d3Fcby3twdARGojInme53n+8PBwf3+/1KytrV1cXBweHg6Hw+vr66VmRVYICEBFYTc3N3d3d4Mg8N6Px2Ot9WIKkdqcnHzu9/tBEPR6veFwuNRcXl4OBoMkSQ4ODtI0vbm5eWtWZIUgEkivt83MQRAQUTX2ej0AZVmCqDZZltWm2+222+23Znt7O0kSpVSSJGmaLp1nRZaCgIBsZ8c5570XEe89gCzLRERElHo1o9GoNtPpdKmZTCbGGGY2xrxnVmSFIgKQMabf749Go/F4vLGxcXZ2NpvNoiiy1kZRVJtPe/nz83O11fv7+0vN09OP9fX1VqtlrZ1MJt77t2ZFVlgd3s9fv4IwPD09TdOt6fT3y8uLtTZNU+dcGP5jjo+PaxNF0VIDyH/Ne1mhCIsoAh4fH+d/5qQAobAVftzJyrJ0zgVB0KRRItX1IiLi2YtAIOy5sNZ7X5Zlu500acK6PdRj1TettVXVrVbcpFHMXHfz6jcAZi6KoigKrXUcx02aUIQJi0tGqt5FAODLUmuttW6315o0ynuunigAvPcCgKszZqP1bDaL41aT5i9f9a9yJq6Q4AAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Button_leftpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Button_left.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Button_leftpng

Func _Button_Rightpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Button_rightpng
	$Button_rightpng &= 'iVBORw0KGgoAAAANSUhEUgAAADAAAAASCAIAAACSBMrtAAAACXBIWXMAAAsSAAALEgHS3X78AAACj0lEQVRIx73VT07kOBQG8O/ZSeFGglJBdTYIATsEzYYzII7ChTgAR2E1fQmqugUptQgqCEhJ5Y/z/PUiMwwztDTNLOKFJcs/fQvb71kuLy+Pv3z5+sdXMgSGslx9//btOX8uyoIAiLIsLi4uBjNRtVpF1gLUoNppU9eddmKFIAgBbGSHNKaq6iiKAgkihOC9ZwgCAQGAgJFBjWl9G1krJMkQQtO0gRQx+GsIMKQxbduKMQRUNYTQtg0IEfyNzKAmCiEAEBGSWZbNZrOnpyfnHMn19fV+a0gTqSoAksvlcj6ft22bJElZlkVRxHEcx7Ex5q1J03Rra+vk5GSxWKRp6r1/b7IsOzs7293dTdP0+vq6qqrfz4nIP1/UarUCsLOzY62dTCb39/dVVUVxDPKtSZLk4ODAWjudTp1zNzc37835+fnx8bFzbn9/fzKZXF1d/X6O6U+SDNPpVESstf3snNve3hYS8g8zHo9fTZIkvzSbm5vOOWOMc248Hn8ox1gRVQ1kkiQAVJWkqnrvkyShCMC35uXl5dUsl8tfmrIs67oOIdR1XRTFh3KiKI77qy3L8vT0dD6f53m+sbFxeHi4XD4KQPKt2dvbe3x8tNaq6ufP08Xix3vjvb+7uzPGhBCy7L6q6g/k2Cjy3qtqnufe+6Ojo/F4M8+fZ7NZ9pAJEMh/mclk8p+mLMv/lxONRiPvfd/IHx4ebm9vRSSQL/mzCAFR1SFNFMdx13W+83XTdKoQkAyq/f8CEMCQxjjnvPdd17VtC0AgxhgAxhgR6etiSGNGo1FVVW3bNk3T9wm+NgygXw5pzKdP63VdV1XVFyFIgfRIRCDSaTekMWtro6IomqZRDSQpQrAvTpAgGTCk+QnWdVRB5hbAnQAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Button_rightpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Button_right.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_Button_rightpng

Func _ButtonLEDpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $ButtonLEDpng
	$ButtonLEDpng &= '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'
	$ButtonLEDpng &= 'jbx52vQZM2fNHjx3nj/y7Tt3791/8PDR0bOdkaEcEHgpK1fNWbN23b6dm/b7l/L+w+UrV69dv3HzVudSoJyyh9ps275j0a7de7Z2r83jJ0+fPX/x8lVXbaAcs6dir9+wcfXeLb8W++Onz1++/vWz2FCO1wtfr3ePw5+fr946sNDUKB5TCbhcgJLJQ3XlAE0dnmRha6sw2dNhAgNxgZWcPKTFgszjdMNAsF3kdovaQTAg9w0cGQ7tZprh0AAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($ButtonLEDpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Button-LED.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_ButtonLEDpng

Func _Colorpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Colorpng
	$Colorpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAADQ0lEQVR4Xn3TDUzUZRwH8O+fgzu8Ay7uDxhMKY6XzruQiEMzQiYXYCtbLzQic9yYYZvioGtt6dBh04VwGo65AiqsXN5suJ0G5WqJLF8TcuEqKGGuyYvecS9yiPzv/627zY2x5md79vyePfvutz2/PVhMrzfFxcbGR2OBl1fqkBij0OJ/RGARq3XPRy3NZ4drajp3abXJmmWxqphyY9Kh3i3G4ZIsbSoe5LGsIjQ3D9xwHJPZ2RHk9m3fX+mvzLsg77ZQ3lvEL8pXNGKRSNwnIMrNAWMgEJXickuYDdzF+hV4suCKDMEbBJRRyFBq1gHYjYUyczK0O76qazrwW/3ttplq+ZMTg9zTOM6GnaOc/PJD8vlkyhVZlHe9wtHPLf6f+xQ9vb2ZR1rsz1SbTMkaGMyGxCMjrS5HcB8Pz21mz00Hm5pGadt6jr66fM7lKygfLaI8tY3yzWhyLpIyczl1yzpfXJxuQIjVvmFre2C7fMD3Bj8Ye41HT42wvrafYy88wfEt4MzvSyj9AnIMpF+gLIs8c8bwEwAh/AZdtpOHk6Q1ZdlVazfMcwIXxHcxn7Ee54ZEZCxRYSigR4q+ANmRRojSt/CM/XDv2Nee9wEwPMZK08OP14+wpHL/AGr6U1A1EQOLyw6DMIgZTz7a/ngaXdfO4+A/Tnw8/wgOjViGvzmtGULIm+YEfGddeZwNz5K1heSregafUtHz4nJ67TqePJXH1ft+5f5rrfKO66W0eyv5mVTHdxwbO8Jj7Pvbq9tZsqwUKgmIVgIxGgibyhGXdh5B0Y34+M24eFqBl1yvB+PSLwZVSpVKLYhYs85Ytbp0+KAAQKjIFXPLHk20PERlWuFbU28nmClAmgTvqtHpvoSaHh00aiU2rdp7Z2nCDbXCo7s6cfleR2/72S4sEjF0VXmHkpqcjWDgdhpNn04yom2O6naJkWXvtUGA+kF/QR6/lfkjFWbMcjmbHJoTf07MBtLjo7BKBMWgexBEAAv5/X54vV74fD6E2Gx5xZcub7ze0lJY63Q6k56rthUUNTqPV7T2/SXqs5cuyIT3UFAIHTweT6hGTk6OYDablf+F4XK5wit0n5qaquru7g7X09PT95sK/wIxMJR1N/EroAAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Colorpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Color.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Colorpng

Func _Exitpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Exitpng
	$Exitpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsSAAALEgHS3X78AAAC9klEQVQ4y12TTWicVRSGn3Pv/b75yUydZExrpSqVgoEmgggWqaDgrqA7lw1IJCCCvxvFRVeBCoJSFxbFpatSN4K6EEvFhLrQpkUNtbWxmtBJm0k6k5lv5vu597hIKtHnbM7mPe/mOfLr+8e000t6V1a7y/dUoxHVUKiqRwkiaJr75JH9I4dPf7f82qfnVz+zRpwPWrCD0yJlT5nyV7+tf3tm/q+zVnAKCdCPjGSp12vvPHdorlGxtbshBLm7mlwdJWPsR8en3nj7hanZgGRB0aAErwSArJNtVI/tneFo/UkftBARg26PSUJEP/O01zvF688+NP30RPN5oGeNRCoiABcm3P3Lzzw8Nb6nsg+AESpUqVCh4iqhj6UQMcKNv9fZ2hrUAQXU+7D2wPSBE43pw2/2bxXh6CtHPgmz4ZSzTkouxgeP8z7gjBK8ihEQEQXwqnrwpYNzj8889mrRzcJWuGMkZjyqOsQKcWywxLiiKCBkxHGE9wEEAwyqE+UnHp2ZfHljsx02h22No5hyKBUSyho5S0GBJ2CKIlAUSp5maJGDDwGoJkvDi+feOj+74dv5SLlia6aqo7WGa46ORc3GWDQ+OhY1G6ORK7KcUglSL2xoA1tvAkmw1tS6C92z1+f+bE+emPq8Wq3Xe6v9i3eS7q2SK0UlG6tXj9sKJWw2wDnDSk8Y7CiiQb11cl/3Qu9L+eCPuQPvPXXyi5OL7659c/NrsWLVqwdwxXDgs7gQG1IOmYQo6/7rC2Hbg8nbRqKPL51Zu9m5LgCKiIgRwFXCwIY06NC5MExzbMh30qogAcDUTT1Z3JrnUnLF7FJZAbvUSr6faMZHarHZl2ae+Rv9hdVOviCC020T45XN9Orv64PFXhq6KMouzM+rybkPf7h9fDjMeyEErFACxoEHFRpA1upmS61uvrLT+t8Dzkh8uTX46fSP7RdrscEaaQL7gRZwGdgUwciuB9qNDYo3grvaTn/ZO+Lu7aTBXGunp0RY2WkT/te6m38AYnqCtois87wAAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($Exitpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Exit2_16x16.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Exitpng

Func _Resetpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Resetpng
	$Resetpng &= 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACFElEQVQ4jZ2RPU8UURSGn3vni12WZRCCISaymFgQE12jDZLoktgDNtohv0A7S0NpJRb20hhj4+4vwEZojG5jiMGQLcCP5WPusMPuzOzMXAtCQpBo8O1Oznuek/ccMT5XP7e2VN7jhMZmVx7mHGPasqSbZppuNyWOo5rWvGrUKurIJ8bn6h8j/+DuRnVSAVy6tzozNOA8HzlfKAnT4CDMiBNNmkmiTkLg+yoKO/Mb1Ur1CKBzOqqrVnfKts2noxcKj92BPD/2IpIMbMsizSSZ1midIaVBa8/H99RsozZVFeNzdX37ah+rn3bU2MWiK2yL77shg8U8QRDhee1GmumGELi5fE+5t1gAYHvrp/L9YMwE8A4ybl4bdv12xuZOyFB/nu3tlvJUe+Hb24nFo7yXH3yoxFH0bmhk2O0fdN0kiWYkQNPr0miGbO2GuMUems0Wym9PHR8GWH8z+T7uRvOBv0+urxfTtqbl4Smh1UkQUoKW7AdhoxMljZOfAfj6+lZ1vxXUtZBoDFcCWKaJY1sIKfHaGQV3sGQ79nLp/op7GgSha0JoTMdwTYDNX+0/PE6PU47jcBm4frJnWEY9TWOkFMpcWyqLU7f8RaYtFWiQWsmzDh8CjDJpBpLafwEs2xxNdKIMQ1T/C2BYRkXL7MXnlzfOHuHOwnpJGsJFsAhwZkDaTR8JmF99dkX9232KJp58KR+vfwP8bOg/UjrxpAAAAABJRU5ErkJggg=='
	Local $bString = Binary(_Base64Decode($Resetpng))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Reset.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Resetpng

Func _Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_Base64Decode

Func _WinAPI_LZNTDecompress(ByRef $tInput, ByRef $tOutput, $iBufferSize)
	$tOutput = DllStructCreate("byte[" & $iBufferSize & "]")
	If @error Then Return SetError(1, 0, 0)
	Local $aRet = DllCall("ntdll.dll", "uint", "RtlDecompressBuffer", "ushort", 0x0002, "struct*", $tOutput, "ulong", $iBufferSize, "struct*", $tInput, "ulong", DllStructGetSize($tInput), "ulong*", 0)
	If @error Then Return SetError(2, 0, 0)
	If $aRet[0] Then Return SetError(3, $aRet[0], 0)
	Return $aRet[6]
EndFunc   ;==>_WinAPI_LZNTDecompress
#endregion additional embedded files

#region CPU usage
; ===================================================================================================================
; Func _WinAPI_GetPerformanceInfo($iInfo=-1,$bConvertPagesToBytes=False)
;
; Function to return System Performance Information. Win XP/2003+ O/S required.
;	NOTE: To get the sizes in bytes of information returned as 'pages' (elements 0-9), you must multiply the number
;	  by 'Page Size' (4096 avg). To further convert that to KB, you would do Round($iVal*$iPageSz/1024)
;	  $bConvertPagesToBytes=True will do the multiplication for you
;
; $iInfo = Performance Info to Get. Possible values are:
;	-1 = get ALL Performance info, returns an array
;	 0 = Commit Total - # pages committed by the system
;	 1 = Commit Limit - max # of pages that can be committed w/o changing pagefile size
;	 2 = Commit Peak - greatest # pages committed since last boot
;	 3 = Physical Total - total physical memory, in pages
;	 4 = Physical Available - available physical memory, in pages
;	 5 = System Cache - amount of system cache memory, in pages
;	 6 = Kernel Total - total of paged+nonpaged memory pools, in pages
;	 7 = Kernel Paged - amount in paged kernel pool, in pages
;	 8 = Kernel NonPaged - amount in nonpaged kernel pool, in pages
;	 9 = Page Size - size of a page [in bytes]
;	10 = Handle Count - # of currently open handles
;	11 = Process Count - # of processes currently running
;	12 = Thread Count - # of threads currently running
; $bConvertPagesToBytes = If True, convert page values to byte values before returning
;
; Returns:
;	Success: A single value (values are interpreted based on data (see descriptions)), or an array if $iInfo=-1.
;	 	[0] = Commit Total - # pages committed by the system
;	 	[1] = Commit Limit - max # of pages that can be committed w/o changing pagefile size
;	 	[2] = Commit Peak - greatest # pages committed since last boot
;	 	[3] = Physical Total - total physical memory, in pages
;	 	[4] = Physical Available - available physical memory, in pages
;	 	[5] = System Cache - amount of system cache memory, in pages
;	 	[6] = Kernel Total - total of paged+nonpaged memory pools, in pages
;	 	[7] = Kernel Paged - amount in paged kernel pool, in pages
;	 	[8] = Kernel NonPaged - amount in nonpaged kernel pool, in pages
;	 	[9] = Page Size - size of a page [in bytes]
;		[10]= Handle Count - # of currently open handles
;		[11]= Process Count - # of processes currently running
;		[12]= Thread Count - # of threads currently running
;	Failure: -1 with @error set:
;		@error = 1 = invalid parameter
;		@error = 2 = DLL call error, @extended contains DLLCall()'s error code
;		@error = 3 = Function returned False (failure) - check GetLastError code
;
; Author: Ascend4nt
; ===================================================================================================================
Func _WinAPI_GetPerformanceInfo($iInfo = -1, $bConvertPagesToBytes = False)
	If $iInfo > 12 Then Return SetError(1, 0, -1)

	Local Const $tagPERFINFO = "dword Sz;ulong_ptr CommitTotal;ulong_ptr CommitLimit;ulong_ptr CommitPeak;ulong_ptr PhysicalTotal;ulong_ptr PhysicalAvailable;ulong_ptr SystemCache;ulong_ptr KernelTotal;ulong_ptr KernelPaged;ulong_ptr KernelNonpaged;ulong_ptr PageSize;dword HandleCount;dword ProcessCount;dword ThreadCount"
	Local $iPageSz, $stPerfInfo = DllStructCreate($tagPERFINFO)
	; Avoid any conflict with other psapi.dll files floating around. Win2000+ should have the 'good' version located in @SystemDir
	;	It might be a good idea to revise this and bundle a newer version of psapi.dll if using on pre-XP/2003 O/S's though.
	Local $aRet = DllCall(@SystemDir & "\psapi.dll", "bool", "GetPerformanceInfo", "ptr", DllStructGetPtr($stPerfInfo), "dword", DllStructGetSize($stPerfInfo))
	If @error Then Return SetError(2, @error, -1)
	If Not $aRet[0] Then Return SetError(3, 0, -1)
	$iPageSz = DllStructGetData($stPerfInfo, 11)
	; Get ALL info?
	If $iInfo < 0 Then
		Dim $aPerfInfo[13]
		For $i = 0 To 12
			$aPerfInfo[$i] = DllStructGetData($stPerfInfo, $i + 2)
		Next
		If $bConvertPagesToBytes Then
			For $i = 0 To 8
				$aPerfInfo[$i] *= $iPageSz
			Next
		EndIf
		Return $aPerfInfo
	EndIf
	If $bConvertPagesToBytes And $iInfo < 9 Then Return DllStructGetData($stPerfInfo, $iInfo + 2) * $iPageSz
	Return DllStructGetData($stPerfInfo, $iInfo + 2)
EndFunc   ;==>_WinAPI_GetPerformanceInfo

; ==============================================================================================
; Func _CPUGetTotalProcessorTimes()
;
; Gets the total (combined CPUs) system processor times (as FILETIME)
; Note that Kernel Mode time includes Idle Mode time, so a proper calculation of usage time is
;   Kernel + User - Idle
; And percentage (based on two readings):
;  (Kernel_b - Kernel_a) + (User_b - User_a) - (Idle_b - Idle_a) * 100
;	/ (Kernel_b - Kernal_a) + (User_b - User_a)
;
; Returns:
;  Success: Array of info for total (combined CPU's) processor times:
;   [0] = Idle Mode Time
;   [1] = Kernel Mode Time -> NOTE This INCLUDES Idle Time
;   [2] = User Mode Time
;
;  Failure: "" with @error set:
;	 @error = 2: DLLCall error, @extended = error returned from DLLCall
;    @error = 3: API call returned False - call GetLastError for more info
;
; Author: Ascend4nt
; ==============================================================================================
Func _CPUGetTotalProcessorTimes()
	Local $aRet, $stSystemTimes

	$stSystemTimes = DllStructCreate("int64 IdleTime;int64 KernelTime;int64 UserTime;")

	$aRet = DllCall("kernel32.dll", "bool", "GetSystemTimes", "ptr", DllStructGetPtr($stSystemTimes, 1), _
		"ptr", DllStructGetPtr($stSystemTimes, 2), "ptr", DllStructGetPtr($stSystemTimes, 3) )

	If @error Then Return SetError(2, @error, "")
	If Not $aRet[0] Then Return SetError(3, 0, "")

	Dim $aRet[3] = [ _
		DllStructGetData($stSystemTimes, 1), _
		DllStructGetData($stSystemTimes, 2), _
		DllStructGetData($stSystemTimes, 3) ]

	Return $aRet
EndFunc

; ==============================================================================================
; Func _CPUCalculateUsage($aPrevCPUInfo, $aCurCPUInfo)
;
; Calculates CPU usage for the combined processor times based on passed processor times arrays
; This can also be used for individual processor times, but is primarily used with
;  _CPUGetTotalProcessorTimes(), which uses the GetSystemTimes API call
; The array should be in the format returned by _CPUGetTotalProcessorTimes()
; Two arrays are needed for delta info used to calculate percentage
;
; Returns:
;  Success: %CPU Usage
;  Failure: 0 with @error set to 1 for invalid parameters
;
; Author: Ascend4nt
; ==============================================================================================
Func _CPUCalculateUsage($aPrevCPUInfo, $aCurCPUInfo)
	If Not IsArray($aPrevCPUInfo) Or UBound($aPrevCPUInfo) < 3 Then Return SetError(1, 0, 0)
	If Not IsArray($aCurCPUInfo) Or UBound($aCurCPUInfo) < 3 Then Return SetError(1, 0, 0)

	Local $nTotalActive, $nTotal

	$nTotal = ($aCurCPUInfo[1] + $aCurCPUInfo[2]) - ($aPrevCPUInfo[1] + $aPrevCPUInfo[2])
	; Kernel Time includes Idle time, so we need to subtract that
	$nTotalActive = ($aCurCPUInfo[1] + $aCurCPUInfo[2] - $aCurCPUInfo[0]) - ($aPrevCPUInfo[1] + $aPrevCPUInfo[2] - $aPrevCPUInfo[0])

	Return Round($nTotalActive * 100 / $nTotal, 2)
EndFunc
#endregion

#region Network Statistics
; ==============================================================================================
; Func _Network_IPStatistics($bIPv6 = False)
;
; Gets IP Statistics
;
; $bIPv6 = If True/non-zero, return stats for IPv6 Protocol
;
; Returns:
;  Success: Array of IP Stats:
;   [0]  = IP Forwarding Status: [1 = Enabled, 2 = Disabled]
;   [1]  = Default initial time-to-live (TTL) for datagrams
;   [2]  = # Received Datagrams
;   [3]  = # Received Datagrams w/Header errors
;   [4]  = # Received Datagrams w/Address errors
;   [5]  = # Forwarded Datagrams
;   [6]  = # Received Datagrams w/Unknown Protocol
;   [7]  = # Received Datagrams Discarded
;   [8]  = # Received Datagrams Delivered
;   [9]  = # Requested Outgoing Datagrams
;   [10] = # Outgoing Datagrams Discarded
;   [11] = # Transmitted Datagrams Discarded
;   [12] = # Datagrams w/o Routes that were Discarded
;   [13] = TimeOut for Reassembling Incoming Fragmented Datagrams
;   [14] = # Datagrams Requiring Reassembly
;   [15] = # Datagrams Successfully Reassembled
;   [16] = # Datagrams that Failed to be Reassembled
;   [17] = # Datagrams that were Fragmented Successfully
;   [18] = # Datagrams that weren't Fragmented and Discarded
;   [19] = # Fragments created (for Datagrams)
;   [20] = # of Interfaces
;   [21] = # of IP addresses associated with PC
;   [22] = # of Routes in the Routing table
;
;  Failure: "" with @error set:
;	 @error = 2: DLLCall error, @extended = error returned from DLLCall
;    @error = 3: API call returned failure, @extended = API error code
;
; Author: Ascend4nt
; ==============================================================================================
Func _Network_IPStatistics($bIPv6 = False)
	Local $aRet, $nProtocol, $stMIB_IPStats

	; AF_INET = 2, AF_INET6 = 22	; <ws2def.h>
	If $bIPv6 Then
		$nProtocol = 22
	Else
		$nProtocol = 2
	EndIf

	$stMIB_IPStats = DllStructCreate("DWORD dwForwarding;DWORD dwDefaultTTL;DWORD dwInReceives;DWORD dwInHdrErrors;" & _
		"DWORD dwInAddrErrors;DWORD dwForwDatagrams;DWORD dwInUnknownProtos;DWORD dwInDiscards;DWORD dwInDelivers;" & _
		"DWORD dwOutRequests;DWORD dwRoutingDiscards;DWORD dwOutDiscards;DWORD dwOutNoRoutes;DWORD dwReasmTimeout;" & _
		"DWORD dwReasmReqds;DWORD dwReasmOks;DWORD dwReasmFails;DWORD dwFragOks;DWORD dwFragFails;DWORD dwFragCreates;" & _
		"DWORD dwNumIf;DWORD dwNumAddr;DWORD dwNumRoutes;")

	$aRet = DllCall("Iphlpapi.dll", "dword", "GetIpStatisticsEx", "ptr", DllStructGetPtr($stMIB_IPStats), "dword", $nProtocol)
	If @error Then Return SetError(2, @error, "")
	; Something other than NO_ERROR returned is an error code
	If $aRet[0] Then Return SetError(3, $aRet[0], "")

	Dim $aRet[23]
	For $i = 1 To 23
		$aRet[$i - 1] = DllStructGetData($stMIB_IPStats, $i)
	Next

	Return $aRet
EndFunc

; ==============================================================================================
; Func _Network_TCPStatistics($bIPv6 = False)
;
; Gets TCP Statistics
;  NOTE: this doesn't return the # of TCP Packets, but rather the # of Segments
;   See "What's the difference between a TCP segment and a TCP packet?" @
;    http://superuser.com/questions/298087/whats-the-difference-between-a-tcp-segment-and-a-tcp-packet
;   and "Whats the difference between a Packet, Segment and Frame?"
;    http://answers.yahoo.com/question/index?qid=20081211114645AA3VyOK
;
; $bIPv6 = If True/non-zero, return stats for IPv6 Protocol
;
; Returns:
;  Success: Array of TCP Stats:
;   [0]  = Rto Algorithm [Other = 1, Constant Time-out = 2,
;                        MIL-STD-1778 Appendix B = 3, Van Jacobson's Algorithm = 4]
;   [1]  = Min. Rto Value in milliseconds
;   [2]  = Max. Rto Value in milliseconds
;   [3]  = Max # of Connections. If -1 (4294967295 unsigned), it is variable
;   [4]  = # Active Opens  [client initiating connection w/server]
;   [5]  = # Passive Opens [server listening for connection request]
;   [6]  = # Failed Connection Attempts
;   [7]  = # Established Connections that were Reset
;   [8]  = # Currently Established Connections
;   [9]  = # Received Segments
;   [10] = # Sent Segments
;   [11] = # Retransmitted Segments
;   [12] = # Receive Errors
;   [13] = # Sent Segments w/Reset Flag set
;   [14] = # Connections (except Listening Connections)
;
;  Failure: "" with @error set:
;	 @error = 2: DLLCall error, @extended = error returned from DLLCall
;    @error = 3: API call returned failure, @extended = API error code
;
; Author: Ascend4nt
; ==============================================================================================
Func _Network_TCPStatistics($bIPv6 = False)
	Local $aRet, $nProtocol, $stMIB_TCPStats

	; AF_INET = 2, AF_INET6 = 22	; <ws2def.h>
	If $bIPv6 Then
		$nProtocol = 22
	Else
		$nProtocol = 2
	EndIf

	$stMIB_TCPStats = DllStructCreate("DWORD dwRtoAlgorithm;DWORD dwRtoMin;DWORD dwRtoMax;DWORD dwMaxConn;" & _
		"DWORD dwActiveOpens;DWORD dwPassiveOpens;DWORD dwAttemptFails;DWORD dwEstabResets;DWORD dwCurrEstab;" & _
		"DWORD dwInSegs;DWORD dwOutSegs;DWORD dwRetransSegs;DWORD dwInErrs;DWORD dwOutRsts;DWORD dwNumConns;")

	$aRet = DllCall("Iphlpapi.dll", "dword", "GetTcpStatisticsEx", "ptr", DllStructGetPtr($stMIB_TCPStats), "dword", $nProtocol)
	If @error Then Return SetError(2, @error, "")
	; Something other than NO_ERROR returned is an error code
	If $aRet[0] Then Return SetError(3, $aRet[0], "")

	Dim $aRet[15]
	For $i = 1 To 15
		$aRet[$i - 1] = DllStructGetData($stMIB_TCPStats, $i)
	Next

	Return $aRet
EndFunc

; ==============================================================================================
; Func _Network_UDPStatistics($bIPv6 = False)
;
; Gets UDP Statistics
;
; $bIPv6 = If True/non-zero, return stats for IPv6 Protocol
;
; Returns:
;  Success: Array of UDP Stats:
;   [0] = # of Received Datagrams
;   [1] = # Discarded Datagrams due to invalid port specified
;   [2] = # of Received Erroneous Datagrams (doesn't include invalid port datagrams)
;   [3] = # of Sent Datagrams
;   [4] = # of entries in UDP listener Table
;
;  Failure: "" with @error set:
;	 @error = 2: DLLCall error, @extended = error returned from DLLCall
;    @error = 3: API call returned failure, @extended = API error code
;
; Author: Ascend4nt
; ==============================================================================================
Func _Network_UDPStatistics($bIPv6 = False)
	Local $aRet, $nProtocol, $stMIB_UDPStats

	; AF_INET = 2, AF_INET6 = 22	; <ws2def.h>
	If $bIPv6 Then
		$nProtocol = 22
	Else
		$nProtocol = 2
	EndIf

	$stMIB_UDPStats = DllStructCreate("dword dwInDatagrams;dword dwNoPorts;dword dwInErrors;dword dwOutDatagrams;dword dwNumAddrs;")

	$aRet = DllCall("Iphlpapi.dll", "dword", "GetUdpStatisticsEx", "ptr", DllStructGetPtr($stMIB_UDPStats), "dword", $nProtocol)
	If @error Then Return SetError(2, @error, "")
	; Something other than NO_ERROR returned is an error code
	If $aRet[0] Then Return SetError(3, $aRet[0], "")

	Dim $aRet[5]
	For $i = 1 To 5
		$aRet[$i - 1] = DllStructGetData($stMIB_UDPStats, $i)
	Next

	Return $aRet
EndFunc

; ==============================================================================================
; Func _Network_ICMPStatistics($bIPv6 = False)
;
; Gets ICMP Statistics
; These values don't change as often as others. To 'force' a change, do a
; 'ping www.google.com' from the command prompt to see the numbers increase.
;
; $bIPv6 = If True/non-zero, return stats for IPv6 Protocol
;
; Returns:
;  Success: Array of ICMP Stats:
;   [0] = # Incoming ICMP Messages
;   [1] = # Incoming ICMP Errors
;   [2] = # Outgoing ICMP Messages
;   [3] = # Outgoing ICMP Errors
;   [4] = 256-element Array for Incoming 'Type Counts' - MSDN is unclear
;   [5] = 256-element Array for Outgoing 'Type Counts' - MSDN is unclear
;
;  Failure: "" with @error set:
;	 @error = 2: DLLCall error, @extended = error returned from DLLCall
;    @error = 3: API call returned failure, @extended = API error code
;
; Author: Ascend4nt
; ==============================================================================================
Func _Network_ICMPStatistics($bIPv6 = False)
	Local $aRet, $aTmp, $nProtocol, $stMIB_ICMPStats

	; AF_INET = 2, AF_INET6 = 22	; <ws2def.h>
	If $bIPv6 Then
		$nProtocol = 22
	Else
		$nProtocol = 2
	EndIf

	$stMIB_ICMPStats = DllStructCreate("DWORD dwInMsgs;DWORD dwInErrors;DWORD rgdwInTypeCount[256];" & _
		"DWORD dwOutMsgs;DWORD dwOutErrors;DWORD rgdwOutTypeCount[256];")

	$aRet = DllCall("Iphlpapi.dll", "dword", "GetIcmpStatisticsEx", "ptr", DllStructGetPtr($stMIB_ICMPStats), "dword", $nProtocol)
	If @error Then Return SetError(2, @error, "")
	; Something other than NO_ERROR returned is an error code
	If $aRet[0] Then Return SetError(3, $aRet[0], "")

	Dim $aRet[6]
	$aRet[0] = DllStructGetData($stMIB_ICMPStats, 1)
	$aRet[1] = DllStructGetData($stMIB_ICMPStats, 2)
	$aRet[2] = DllStructGetData($stMIB_ICMPStats, 4)
	$aRet[3] = DllStructGetData($stMIB_ICMPStats, 5)

	; rgdwInTypeCount
	Dim $aTmp[256]
	For $i = 1 To 256
		$aTmp[$i - 1] = DllStructGetData($stMIB_ICMPStats, 3, $i)
	Next
	$aRet[4] = $aTmp

	; rgdwOutTypeCount
	For $i = 1 To 256
		$aTmp[$i - 1] = DllStructGetData($stMIB_ICMPStats, 6, $i)
	Next
	$aRet[5] = $aTmp

	Return $aRet
EndFunc
#endregion

#region mus++
Func Init($sSource)
	$sSource = _InitialTidySource($sSource)
	If @error Then Return SetError(1, 0, 0)
	Global $iParts = 8, $aSystems = StringSplit($sSource, @LF & @LF, 1)
	Global $aVoices[$iParts] = ["", "", "", "", "", "", "", ""], $aStaves
	For $i = 1 To $aSystems[0]
		$aStaves = StringSplit($aSystems[$i], @LF)
		If $i = 1 And $aStaves[0] <= 8 Then
			$iParts = $aStaves[0]
			ReDim $aVoices[$iParts]
		ElseIf $iParts <> $aStaves[0] Then
			Return SetError(2, 0, 0) ; Inconsistant number of voices
		EndIf
		For $j = 0 To $iParts - 1
			$aVoices[$j] &= " " & $aStaves[$j + 1]
		Next
	Next

	Global $aTimeLine, $aRepeat[1][11], $iInstance, $vCurrInstrument, $vCurrKey, $sCurrNote, $iCurrOctave, $sLookFor, $sSegnoInstrument, _
			$sSegnoKey, $iSegnoOctave, $sSegnoNote, $iLatestInstrument, $iLatestKey, $iCurrRepeat, $iEndings, $iSegno, $iDalSegno, $iDaCapo, _
			$aAccidentals[7], $sSegnoAccidentals, $sAtTempo, $vCurrTempo, $aNotePart, $sSkipIndex, $sWarnings = "", $sErrors = "", $iTuplet, _
			$bTie, $bRest, $iPitch, $iBound = 1, $aInstrument[$iParts], $iHangCheck, $iRepeats, $iCurrTime, $aMessage[$iParts][1][2] ;==> voice|instance|params=time/msg

	Global Enum $iEntry = 0, $iEntryInstrument, $iEntryKey, $iEntryOctave, $iEntryNote, $iFirstExit, $iFirstExitOctave, _
			$iFirstExitNote, $iFinalExit, $iFinalExitInstrument, $iFinalExitKey

	For $i = 0 To $iParts - 1
		$aInstrument[$i] = 0xC0
	Next

	; Parsing begins here
	For $i = 0 To $iParts - 1
		_ClearAccidentals($aAccidentals)
		$aVoices[$i] = StringStripWS($aVoices[$i], 3)
		StringReplace($aVoices[$i], "|:", "") ; Get loop entry points
		If @extended Then ReDim $aRepeat[@extended + 1][11]

		$iInstance = 0 ; bar repeat sections encountered
		$vCurrInstrument = "<pno>" ; piano
		$vCurrKey = "0#" ; C major / A minor
		$sCurrNote = ";" ; quarter note
		$iCurrOctave = 4
		$sLookFor = "" ; Look for Q or fin within a DC or DS section repeat

		; Bar repeat data
		$aRepeat[$iInstance][$iEntry] = $iInstance
		$aRepeat[$iInstance][$iEntryInstrument] = $vCurrInstrument
		$aRepeat[$iInstance][$iEntryKey] = $vCurrKey
		$aRepeat[$iInstance][$iEntryOctave] = $iCurrOctave
		$aRepeat[$iInstance][$iEntryNote] = $sCurrNote
		$aRepeat[$iInstance][$iFirstExit] = $iInstance
		$aRepeat[$iInstance][$iFirstExitOctave] = $iCurrOctave
		$aRepeat[$iInstance][$iFirstExitNote] = $sCurrNote
		$aRepeat[$iInstance][$iFinalExit] = ""
		$aRepeat[$iInstance][$iFinalExitInstrument] = $vCurrInstrument
		$aRepeat[$iInstance][$iFinalExitKey] = $vCurrKey

		$iCurrRepeat = 1 ; First iteration of a bar repeat sequence
		$iEndings = 1 ; no separate bar repeat endings encountered yet

		$aTimeLine = StringRegExp($aVoices[$i], "[^\h]+", 3)
		$aVoices[$i] = ""

		$sSegnoInstrument = $vCurrInstrument ; Section repeat data
		$sSegnoKey = $vCurrKey ; Section repeat data =>
		$iSegnoOctave = $iCurrOctave
		$sSegnoNote = $sCurrNote
		$sSegnoAccidentals = ",,,,,," ; array is needed when $ occurs after an accidental
		$iLatestInstrument = 0 ; position in timeline
		$iLatestKey = 0 ; position in timeline
		$iSegno = -1 ; position of $
		$iDalSegno = -1 ; position of DS
		$iDaCapo = -1 ; position of DC
		$sAtTempo = -1
		$vCurrTempo = ";=100"
		$sSkipIndex = "|"

		For $j = 0 To UBound($aTimeLine) - 1
			If StringInStr($sSkipIndex, "|" & $j & "|") Then ContinueLoop
			$iHangCheck = $j - 1
			Select
				Case _IsInstrument($aTimeLine[$j])
					If $j > $iLatestInstrument Then $iLatestInstrument = $j
					_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $aTimeLine[$j], $i)
					$aRepeat[$iInstance][$iEntryInstrument] = $vCurrInstrument ; Temporary Patch

				Case _IsKeySig($aTimeLine[$j])
					If $j > $iLatestKey Then $iLatestKey = $j
					_UpdateCurrentAttrib($vCurrKey, $aVoices, $aTimeLine[$j], $i)

				Case _IsTempoMark($aTimeLine[$j])
					If Not StringRegExp($aVoices[$i], "[A-Go\+;\-~\\\?]") Then
						$sAtTempo = $aTimeLine[$j]
					EndIf
					_UpdateCurrentAttrib($vCurrTempo, $aVoices, $aTimeLine[$j], $i)

				Case _IsAtTempo($aTimeLine[$j])
					_UpdateCurrentAttrib($vCurrTempo, $aVoices, $sAtTempo, $i)

				Case _IsSegno($aTimeLine[$j])
					$sSegnoKey = $vCurrKey
					$sSegnoInstrument = $vCurrInstrument
					$iSegnoOctave = $iCurrOctave
					$sSegnoNote = $sCurrNote
					$iSegno = $j
					$sSegnoAccidentals = ""
					For $k = 0 To 5
						$sSegnoAccidentals &= $aAccidentals[$k] & ","
					Next
					$sSegnoAccidentals &= $aAccidentals[6]

				Case _IsBarLine($aTimeLine[$j])
					_ClearAccidentals($aAccidentals)

				Case _IsStartRepeat($aTimeLine[$j])
					_ClearAccidentals($aAccidentals)
					$iInstance += 1
					If $j > $iDaCapo And $j > $iDalSegno Then
						$aRepeat[$iInstance][$iEntry] = $j
						$aRepeat[$iInstance][$iEntryInstrument] = $vCurrInstrument
						$aRepeat[$iInstance][$iEntryKey] = $vCurrKey
						$aRepeat[$iInstance][$iEntryOctave] = $iCurrOctave
						$aRepeat[$iInstance][$iEntryNote] = $sCurrNote
						$iCurrRepeat = 1
						$iEndings = 1
					EndIf

				Case _Is2ndTimeRound($aTimeLine[$j])
					If $j > $iDaCapo And $j > $iDalSegno Then
						If $aRepeat[$iInstance][$iFinalExit] = "" Then
							$aRepeat[$iInstance][$iFirstExit] = $j
							$aRepeat[$iInstance][$iFirstExitOctave] = $iCurrOctave
							$aRepeat[$iInstance][$iFirstExitNote] = $sCurrNote
						EndIf

						$iRepeats = StringTrimRight($aTimeLine[$j], 1) ; string to number
						If $iEndings < $iRepeats Then $iEndings = $iRepeats
						If $iCurrRepeat > $iRepeats Then
							If $vCurrKey <> $aTimeLine[$iLatestKey] Then
								If _IsKeySig($aTimeLine[$iLatestKey]) Then
									$vCurrKey = $aTimeLine[$iLatestKey]
									$aVoices[$i] &= $vCurrKey & " "
								EndIf
							EndIf
							_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $aTimeLine[$iLatestInstrument], $i)
							_ClearAccidentals($aAccidentals)
							$j = $aRepeat[$iInstance][$iFinalExit] ; Go to the next end repeat mark
						EndIf
					Else
						$j = $aRepeat[$iInstance][$iFinalExit] ; Go directly to the last end section
						_ClearAccidentals($aAccidentals)
						_UpdateCurrentAttrib($vCurrKey, $aVoices, $aRepeat[$iInstance][$iFinalExitKey], $i)
						_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $aRepeat[$iInstance][$iFinalExitInstrument], $i)
					EndIf

				Case _IsTie($aTimeLine[$j]) Or _IsStartTuplet($aTimeLine[$j]) Or _IsEndTuplet($aTimeLine[$j])
					$aVoices[$i] &= $aTimeLine[$j] & " "

				Case _IsNote($aTimeLine[$j])
					$aNotePart = _NoteSplit($aTimeLine[$j])
					If $aNotePart[0] <> "" Then
						$sCurrNote = _GetCurrNote($aNotePart[0])
					EndIf
					If $aNotePart[1] <> "" Then
						If StringInStr($aNotePart[1], "'") Then
							$iCurrOctave = _GetOctave($aNotePart[1])
						EndIf
						If StringRegExp($aNotePart[1], "[#bxz]") Then
							_UpdateAccidentals($aAccidentals, $aNotePart[1])
						Else
							_GetAccidental($aAccidentals, $aNotePart[1])
						EndIf
					EndIf
					$aVoices[$i] &= $aNotePart[0] & $aNotePart[1] & " "
					If $sAtTempo = -1 Then $sAtTempo = $vCurrTempo

				Case _IsEndRepeat($aTimeLine[$j])
					If $j > $iDaCapo And $j > $iDalSegno Then
						_ClearAccidentals($aAccidentals)
						If $iCurrRepeat = $iEndings Then
							$aRepeat[$iInstance][$iFinalExit] = $j
							$aRepeat[$iInstance][$iFinalExitInstrument] = $vCurrInstrument
							$aRepeat[$iInstance][$iFinalExitKey] = $vCurrKey
						EndIf
						If $iCurrRepeat <= $iEndings Then ; Go back to the start of the loop
							$j = $aRepeat[$iInstance][$iEntry] ; $j will be incremented on the next pass ^^
							$iCurrRepeat += 1
							_UpdateCurrentAttrib($vCurrKey, $aVoices, $aRepeat[$iInstance][$iEntryKey], $i)
							_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $aRepeat[$iInstance][$iEntryInstrument], $i)
							_UpdateCurrentAttrib($iCurrOctave, $aVoices, $aRepeat[$iInstance][$iEntryOctave], $i, "{", "} ")
							_UpdateCurrentAttrib($sCurrNote, $aVoices, $aRepeat[$iInstance][$iEntryNote], $i, "{", "} ")
						EndIf
					EndIf

				Case _IsDalSegno($aTimeLine[$j])
					If $iDalSegno < $j Then
						If $iSegno = -1 Then
							$sWarnings &= "Voice " & $i + 1 & " Warning => Expected $ sign before DS " & @CRLF
							ConsoleWrite($sWarnings) ; deal with this later
							ExitLoop ; further parsing of this voice is meaningless
						EndIf
						$iDalSegno = $j
						$j = $iSegno
						$sLookFor = "DS"
						_UpdateCurrentAttrib($vCurrKey, $aVoices, $sSegnoKey, $i)
						_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $sSegnoInstrument, $i)
						_UpdateCurrentAttrib($iCurrOctave, $aVoices, $iSegnoOctave, $i, "{", "} ")
						_UpdateCurrentAttrib($sCurrNote, $aVoices, $sSegnoNote, $i, "{", "} ")
						$aAccidentals = StringSplit($sSegnoAccidentals, ",", 2)
						For $iInstance = $iInstance To 0 Step -1
							If $iSegno > $aRepeat[$iInstance][$iEntry] Then ExitLoop
						Next
					EndIf

				Case _IsDaCapo($aTimeLine[$j])
					If $iDaCapo < $j Then
						_ClearAccidentals($aAccidentals)
						$iDaCapo = $j
						$j = -1
						$sLookFor = "DC"
						$iInstance = 0
						_UpdateCurrentAttrib($vCurrKey, $aVoices, $aRepeat[$iInstance][$iEntryKey], $i)
						_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $aRepeat[$iInstance][$iEntryInstrument], $i)
						_UpdateCurrentAttrib($iCurrOctave, $aVoices, $aRepeat[$iInstance][$iEntryOctave], $i, "{", "} ")
						_UpdateCurrentAttrib($sCurrNote, $aVoices, $aRepeat[$iInstance][$iEntryNote], $i, "{", "} ")
					EndIf

				Case _IsCoda($aTimeLine[$j])
					If ($sLookFor = "DS" And $j < $iDalSegno) Or ($sLookFor = "DC" And $j < $iDaCapo) Then
						If $iDalSegno > $iDaCapo Then
							$j = $iDalSegno
						Else
							$j = $iDaCapo
						EndIf
						_UpdateCurrentAttrib($vCurrKey, $aVoices, $aTimeLine[$iLatestKey], $i)
						_UpdateCurrentAttrib($vCurrInstrument, $aVoices, $aTimeLine[$iLatestInstrument], $i)
					EndIf

				Case _IsFin($aTimeLine[$j])
					If ($sLookFor = "DS" And $j < $iDalSegno) Or ($sLookFor = "DC" And $j < $iDaCapo) Then ExitLoop

				Case Else
					If _IsTimeSig($aTimeLine[$j]) Or _IsTechnique($aTimeLine[$j]) Or _IsBarRepeat($aTimeLine[$j]) Or _IsAccel($aTimeLine[$j]) Or _IsDynamicMark($aTimeLine[$j]) Then
						ContinueLoop ; Currently unsupported performance instructions or features
					Else
						$sErrors &= "Voice " & $i + 1 & " Syntax Error => " & $aTimeLine[$j] & @CRLF
						$sSkipIndex &= $j & "|"
						ConsoleWrite("Voice " & $i + 1 & " Syntax Error => " & $aTimeLine[$j] & @LF)
					EndIf
			EndSelect
			If $j = $iHangCheck Then $j += 1 ; Recursion correction
		Next
		;ConsoleWrite($aVoices[$i] & @LF)

		$aTimeLine = StringRegExp($aVoices[$i], "[^\h]+", 3)
		$iInstance = UBound($aTimeLine) * 2 ; upper limit... variable re-usage
		If $iInstance > UBound($aMessage, 2) Then ReDim $aMessage[$iParts][$iInstance][2]

		$vCurrInstrument = 0
		$iLatestInstrument = 0
		$vCurrKey = 0 ; C major / A minor
		$iLatestKey = 0 ; C major / A minor
		$vCurrTempo = 100
		$iCurrOctave = 4
		$sCurrNote = ";"
		$sLookFor = -1 ; variable re-usage
		$bTie = False ; variable re-usage
		$bRest = True
		$iInstance = 0 ; message count
		$iCurrTime = 0
		$iTuplet = 1
		Global $iDuration

		For $j = 0 To UBound($aTimeLine) - 1
			Select
				Case _IsInstrument($aTimeLine[$j])
					$aTimeLine[$j] = StringRegExpReplace($aTimeLine[$j], "(_)(pno|box|org|acc|gtr|bass|tpt|sax|hn|drum|bl)", " " & "$2")
					$iLatestInstrument = _GetInstrument($aTimeLine[$j])
					If @error And Not StringInStr($sErrors, $aTimeLine[$j]) Then
						$sErrors &= "Voice " & $i + 1 & " Instrument not recognized => " & $aTimeLine[$j] & @CRLF
						ConsoleWrite("Voice " & $i + 1 & " Instrument not recognized => " & $aTimeLine[$j] & @LF)
					ElseIf $vCurrInstrument <> $iLatestInstrument Then
						$vCurrInstrument = $iLatestInstrument
						$aMessage[$i][$iInstance][0] = $iCurrTime
						$aMessage[$i][$iInstance][1] = $vCurrInstrument * 256 + 0xC0
						$iInstance += 1
					EndIf
					$aInstrument[$i] = $vCurrInstrument * 256 + 0xC0

				Case _IsKeySig($aTimeLine[$j])
					$vCurrKey = _GetKey($aTimeLine[$j])

				Case _IsTempoMark($aTimeLine[$j])
					$vCurrTempo = _GetQuartNoteBPM($aTimeLine[$j])

				Case _IsTie($aTimeLine[$j])
					$bTie = True

				Case _IsStartTuplet($aTimeLine[$j])
					$iTuplet = StringReplace($aTimeLine[$j], "(", "")
					If $iTuplet = "" Then $iTuplet = 3

				Case _IsOctave($aTimeLine[$j])
					$iCurrOctave = StringRegExpReplace($aTimeLine[$j], "[\{\}]", "")

				Case _IsCurrentNote($aTimeLine[$j])
					$sCurrNote = StringRegExpReplace($aTimeLine[$j], "[\{\}]", "")

				Case _IsNote($aTimeLine[$j])
					$aNotePart = _NoteSplit($aTimeLine[$j])
					If $aNotePart[0] <> "" Then
						$sCurrNote = _GetCurrNote($aNotePart[0])
					Else
						$aNotePart[0] = $sCurrNote
					EndIf
					$iDuration = _GetDuration($aNotePart[0], $vCurrTempo, $iTuplet)

					If $aNotePart[1] <> "" Then
						If StringInStr($aNotePart[1], "'") Then
							$iCurrOctave = _GetOctave($aNotePart[1])
						EndIf
						If Not $bTie Then
							$aMessage[$i][$iInstance][0] = $iCurrTime
							$iPitch = _GetPitch($aNotePart[1], $vCurrKey, $iCurrOctave)
							$aMessage[$i][$iInstance][1] = BitOR(($iPitch + 0x15) * 256, 0x90, 0x400000) ; Midi note on
							$iInstance += 1
						Else
							If Not $bRest And $sLookFor > -1 Then
								$aMessage[$i][$sLookFor][0] += $iDuration
							EndIf
						EndIf
						$bRest = False
					Else
						$bRest = True
					EndIf

					$iCurrTime += $iDuration
					If Not $bRest And Not $bTie Then ; Now turn note off
						$aMessage[$i][$iInstance][0] = $iCurrTime
						$aMessage[$i][$iInstance][1] = BitXOR($aMessage[$i][$iInstance - 1][1], 0x400000) ; Midi note off
						$sLookFor = $iInstance
						$iInstance += 1
					EndIf
					$bTie = False

				Case _IsEndTuplet($aTimeLine[$j])
					$iTuplet = 1
			EndSelect
		Next
		If $iInstance > $iBound Then $iBound = $iInstance
	Next

	ReDim $aMessage[$iParts][$iBound][2]

	;_WalkThrough3D($aMessage) ; Debugging - Requires arratf.au3

	$sLookFor = ""
	For $i = 0 To $iParts - 1
		For $j = 0 To UBound($aMessage, 2) - 1
			If $aMessage[$i][$j][0] == "" Then ExitLoop
			If Not StringInStr($sLookFor, "," & $aMessage[$i][$j][0] & ",") Then
				$sLookFor &= $aMessage[$i][$j][0] & ","
			EndIf
		Next
	Next
	$aTimeLine = StringSplit(StringTrimRight($sLookFor, 1), ",", 2)
	_ArraySortByNumber($aTimeLine)

	If $aTimeLine[1] = 0 Then _ArrayDelete($aTimeLine, 0)

	Global $aGrid[UBound($aTimeLine)][$iParts * 8 + 3]
	For $i = 0 To UBound($aTimeLine) - 1
		$aGrid[$i][0] = 1
		$aGrid[$i][1] = $aTimeLine[$i]
	Next

	For $i = $iParts - 1 To 0 Step -1
		$iInstance = 0
		For $j = 0 To UBound($aMessage, 2) - 1
			If $aMessage[$i][$j][0] == "" Then ExitLoop
			If $aMessage[$i][$j][0] == $aTimeLine[$iInstance] Then

				If BitAND($aMessage[$i][$j][1], 0x400000) = 0x400000 Then
					If $aGrid[$iInstance][$aGrid[$iInstance][0]] <> $aInstrument[$i] Then
						$aGrid[$iInstance][0] += 1
						$aGrid[$iInstance][$aGrid[$iInstance][0]] = $aInstrument[$i]
					EndIf
				EndIf

				$aGrid[$iInstance][0] += 1
				$aGrid[$iInstance][$aGrid[$iInstance][0]] = $aMessage[$i][$j][1]

			ElseIf $aMessage[$i][$j][0] > $aTimeLine[$iInstance] Then
				$iInstance += 1
				If $iInstance > UBound($aTimeLine) - 1 Then ExitLoop
				$j -= 1
			EndIf
		Next
	Next
	$iInstance = 0
EndFunc   ;==>Init

Func Play()
	If TimerDiff($iTimer) > $aGrid[$iInstance][1] - 1 Then
		For $i = 2 To $aGrid[$iInstance][0]
			_MidiOutShortMsg($dOpen, $aGrid[$iInstance][$i])
		Next
		$iInstance += 1
		If $iInstance > (UBound($aGrid) - 1) Then
			$iInstance = 0
			$iTimer = TimerInit()
		EndIf
	EndIf
EndFunc   ;==>Play

#region ; conditionals
Func _IsInstrument($sInstruction)
	Return StringRegExp($sInstruction, "(?i)(\A<[a-z \-_0-9]+>\z)")
EndFunc   ;==>_IsInstrument

Func _IsKeySig($sInstruction)
	Return StringRegExp($sInstruction, "(\A[0-7][#b]\z)")
EndFunc   ;==>_IsKeySig

Func _IsTimeSig($sInstruction) ; Requires accentuation / dynamics
	Return StringRegExp($sInstruction, "(\A\d+/(1|2|4|8|16|32|64)\z)")
EndFunc   ;==>_IsTimeSig

Func _IsTempoMark($sInstruction)
	Return StringRegExp($sInstruction, "(\A[o\+;\-~\\\?]\.?=\d*\.?\d+\z)")
EndFunc   ;==>_IsTempoMark

Func _IsAtTempo($sInstruction)
	Return $sInstruction = "@Tempo" ; not case sensitive
EndFunc   ;==>_IsAtTempo

Func _IsSegno($sInstruction)
	Return $sInstruction = "$"
EndFunc   ;==>_IsSegno

Func _IsBarLine($sInstruction)
	Return $sInstruction = "|"
EndFunc   ;==>_IsBarLine

Func _IsStartRepeat($sInstruction)
	Return $sInstruction = "|:"
EndFunc   ;==>_IsStartRepeat

Func _Is2ndTimeRound($sInstruction)
	Return StringRegExp($sInstruction, "(\A\d+,\z)")
EndFunc   ;==>_Is2ndTimeRound

Func _IsTie($sInstruction)
	Return $sInstruction = "_"
EndFunc   ;==>_IsTie

Func _IsStartTuplet($sInstruction)
	Return StringRegExp($sInstruction, "(\A\d*\(\z)")
EndFunc   ;==>_IsStartTuplet

Func _IsNote($sNote)
	If StringRegExp($sNote, "(\A'*[A-G](#|b|bb|x|z)?'*\z)") Then Return 1
	Return StringRegExp($sNote, "(\A[o\+;\-~\\\?\.]+('*[A-G](#|b|bb|x|z)?'*)?\z)")
EndFunc   ;==>_IsNote

Func _IsEndTuplet($sInstruction)
	Return $sInstruction == ")"
EndFunc   ;==>_IsEndTuplet

Func _IsEndRepeat($sInstruction)
	Return $sInstruction = ":|"
EndFunc   ;==>_IsEndRepeat

Func _IsCoda($sInstruction)
	Return $sInstruction == "Q"
EndFunc   ;==>_IsCoda

Func _IsDalSegno($sInstruction)
	Return $sInstruction == "DS"
EndFunc   ;==>_IsDalSegno

Func _IsDaCapo($sInstruction)
	Return $sInstruction == "DC"
EndFunc   ;==>_IsDaCapo

Func _IsFin($sInstruction)
	Return $sInstruction == "fin"
EndFunc   ;==>_IsFin

Func _IsOctave($sInstruction)
	Return StringRegExp($sInstruction, "\A\{[0-8]\}\z")
EndFunc   ;==>_IsOctave

Func _IsCurrentNote($sInstruction)
	Return StringRegExp($sInstruction, "\A\{[o+;=~\?]\.*\}\z")
EndFunc   ;==>_IsCurrentNote
#endregion ; conditionals

#region ; currently unsupported features
Func _IsTechnique($sInstruction) ; Returns an integer - gliss is currently not supported
	Return StringInStr(" gliss pizz ", " " & $sInstruction & " ", 1)
EndFunc   ;==>_IsTechnique

Func _IsBarRepeat($sInstruction) ; currently unsupported
	Return StringRegExp($sInstruction, "(\A%\d*\z)")
EndFunc   ;==>_IsBarRepeat

Func _IsAccel($sInstruction) ; currently unsupported
	Return StringInStr(" accel rit ", " " & $sInstruction & " ", 1)
EndFunc   ;==>_IsAccel

Func _IsDynamicMark($sInstruction) ; Returns an integer - currently unsupported
	Return StringInStr(" cres dim ppp pp /p mp mf /f ff fff ", " " & $sInstruction & " ", 1)
EndFunc   ;==>_IsDynamicMark
#endregion ; currently unsupported features

#region ; data requests
Func _GetAccidental($aAccidentals, ByRef $sNote)
	Local $sAlpha = StringReplace($sNote, "'", "")
	$sNote = StringReplace($sNote, $sAlpha, $sAlpha & $aAccidentals[Asc($sAlpha) - 65], 0, 1)
EndFunc   ;==>_GetAccidental

Func _GetKey($sKey)
	Local $iSign = 1
	If StringInStr($sKey, "b", 1) Then $iSign = -1
	Return StringRegExpReplace($sKey, "[#b]", "") * $iSign
EndFunc   ;==>_GetKey

Func _GetQuartNoteBPM($sTempo)
	Local $aTempo = StringSplit($sTempo, "=", 2)
	Local $iNote = StringInStr("?\~-;+o", $aTempo[0]) - 5
	Return $aTempo[1] * 2 ^ $iNote
EndFunc   ;==>_GetQuartNoteBPM

Func _GetCurrNote($sNote)
	Local $sCurrChr, $sRhythm = ""
	For $i = StringLen($sNote) To 1 Step -1
		$sCurrChr = StringMid($sNote, $i, 1)
		$sRhythm = $sCurrChr & $sRhythm
		If StringInStr("o+;-~\?", $sCurrChr, 1) Then ExitLoop
	Next
	Return $sRhythm
EndFunc   ;==>_GetCurrNote

Func _GetOctave($sNote)
	Local $iPos, $iOctave = 4
	For $i = 65 To 71
		$iPos = StringInStr($sNote, Chr($i), 1)
		If $iPos Then
			ExitLoop
		EndIf
	Next
	For $i = 1 To $iPos - 1
		If StringMid($sNote, $i, 1) = "'" Then $iOctave -= 1
	Next
	For $i = $iPos + 1 To StringLen($sNote)
		If StringMid($sNote, $i, 1) = "'" Then $iOctave += 1
	Next
	Return $iOctave
EndFunc   ;==>_GetOctave

Func _GetPitch($sName, $iKey = 0, $iOctave = 4)
	Local $iPitch, $sAlpha
	Select
		Case StringInStr($sName, "C", 1)
			$sAlpha = "C"
			$iPitch = 39
		Case StringInStr($sName, "D", 1)
			$sAlpha = "D"
			$iPitch = 41
		Case StringInStr($sName, "E", 1)
			$sAlpha = "E"
			$iPitch = 43
		Case StringInStr($sName, "F", 1)
			$sAlpha = "F"
			$iPitch = 44
		Case StringInStr($sName, "G", 1)
			$sAlpha = "G"
			$iPitch = 46
		Case StringInStr($sName, "A", 1)
			$sAlpha = "A"
			$iPitch = 48
		Case StringInStr($sName, "B", 1)
			$sAlpha = "B"
			$iPitch = 50
	EndSelect

	Select
		Case StringInStr($sName, "bb", 1)
			$iPitch -= 2
		Case StringInStr($sName, "b", 1)
			$iPitch -= 1
		Case StringInStr($sName, "z", 1)
			$iPitch += 0
		Case StringInStr($sName, "#", 1)
			$iPitch += 1
		Case StringInStr($sName, "x", 1)
			$iPitch += 2
		Case $iKey
			If $iKey > 0 Then
				If StringInStr(StringLeft("FCGDAEB", $iKey), $sAlpha) Then $iPitch += 1
			Else
				If StringInStr(StringRight("FCGDAEB", -$iKey), $sAlpha) Then $iPitch -= 1
			EndIf
	EndSelect

	$iOctave -= 4
	$iPitch += $iOctave * 12
	If $iPitch < 0 Or $iPitch > 87 Then Return SetError(2, 0, "") ; Out of range pitch
	Return $iPitch ; values range from 0 to 87
EndFunc   ;==>_GetPitch

Func _GetDuration($sNote, $iTempo = 100, $iTuplet = 1)
	Local $sLen = StringLen($sNote)
	If Not $sLen Then Return Default
	If StringLeft($sNote, 1) = "." Then Return SetError(1, 0, 0) ; Syntax error - Dot not preceeded by a note value
	Local $iDuration = 0, $iDots = 0, $sCurrChr = "", $iID, $iNote = 0
	For $i = 1 To $sLen
		$sCurrChr = StringMid($sNote, $i, 1)
		$iID = StringInStr("?\~-;+o.", $sCurrChr) - 1
		Switch $iID
			Case 0 To 6
				$iDuration += $iNote
				$iNote = 6930 * 2 ^ $iID
			Case 7
				While $sCurrChr = "."
					$iDots += 1
					$i += 1
					$sCurrChr = StringMid($sNote, $i, 1)
				WEnd
				$iNote *= (2 ^ ($iDots + 1) - 1) / 2 ^ $iDots
				$i -= 1
				$iDots = 0
		EndSwitch
	Next
	$iDuration += $iNote
	If $iTuplet > 1 Then
		Switch $iTuplet
			Case 2, 4, 8, 16, 32, 64 ; In mus - only 2 and 4 appear, and then only in compound time
				$iDuration *= 3 / 2 ; it's the same result in all cases
			Case 3 ; triplets are the most common tuplet division
				$iDuration *= 2 / 3
			Case 5 To 7
				$iDuration *= 4 / $iTuplet
			Case 9 To 15 ; In mus - tuplets greater than 12 almost never appear
				$iDuration *= 8 / $iTuplet
			Case 17 To 31
				$iDuration *= 16 / $iTuplet
			Case 33 To 63
				$iDuration *= 32 / $iTuplet
			Case 65 To 127
				$iDuration *= 64 / $iTuplet
			Case Else
				Return SetError(2, 0, 0) ; Unsupported out of range tuplet value
		EndSwitch
	EndIf
	Return $iDuration * 125 / (231 * $iTempo)
EndFunc   ;==>_GetDuration

Func _GetInstrument($vInstrument)
	$vInstrument = StringRegExpReplace($vInstrument, "[<>]", "")
	Local $aMIDIInst[72][4] _ ; A selection of available MIDI imstruments
			 = _ ; Name    , ##,Mn,Mx
			[["pno", 0, 0, 87], _ ; Acoustic Grand Piano ... KEYBOARDS
			["br pno", 1, 0, 87], _ ; Bright Piano
			["e pno", 2, 0, 87], _ ; Electric Grand Piano
			["h-t pno", 3, 0, 87], _ ; Honky-tonk piano
			["hpsd", 6, 0, 87], _ ; Harpsichord
			["clav", 7, 0, 87], _ ; Clavichord
			["cel", 8, 0, 87], _ ; Celesta
			["glock", 9, 0, 87], _ ; Glockenspiel ... PITCHED PERCUSSION
			["mus box", 10, 0, 87], _ ; Music Box
			["vib", 11, 0, 87], _ ; Vibraphone
			["marim", 12, 0, 87], _ ; Marimba
			["xyl", 13, 0, 87], _ ; Xylophone
			["chimes", 14, 0, 87], _ ; Tubular Bells
			["dulc", 15, 0, 87], _ ; Dulcimer
			["ham org", 16, 0, 87], _ ; Drawbar Organ ... ORGAN
			["perc org", 17, 0, 87], _ ; Percussive Organ
			["org", 19, 0, 87], _ ; Church Organ
			["harm", 20, 0, 87], _ ; Harmonium Reed Organ
			["accord", 21, 0, 87], _ ; Accordion
			["mouth org", 22, 0, 87], _ ; Harmonica
			["tango acc", 23, 0, 87], _ ; Bandoneon
			["gtr", 24, 0, 87], _ ; Classical Guitar ... GUITAR
			["a gtr", 25, 0, 87], _ ; Accoustic Guitar
			["jazz gtr", 26, 0, 87], _ ; Jazz Guitar
			["e gtr", 27, 0, 87], _ ; Electric Guitar
			["mut gtr", 28, 0, 87], _ ; Muted Electric Guitar
			["fuzz gtr", 30, 0, 87], _ ; Distortion Guitar
			["a bass", 32, 0, 87], _ ; Acoustic Bass ... BASS
			["e bass", 33, 0, 87], _ ; Electric Bass
			["bass", 34, 0, 87], _ ; Upright Bass
			["f bass", 35, 0, 87], _ ; Fretless Bass
			["sl bass", 36, 0, 87], _ ; Slap Bass
			["vln", 40, 0, 87], _ ; Violin ... STRINGS
			["vla", 41, 0, 87], _ ; Viola
			["vc", 42, 0, 87], _ ; Cello
			["db", 43, 0, 87], _ ; Double Bass
			["hp", 46, 0, 87], _ ; Harp
			["timp", 47, 0, 87], _ ; Timpani (perc)
			["tpt", 56, 0, 87], _ ; Trumpet ... BRASS
			["tbn", 57, 0, 87], _ ; Trombone
			["tba", 58, 0, 87], _ ; Tuba
			["mut tpt", 59, 0, 87], _ ; Muted Trumpet
			["hn", 60, 0, 87], _ ; French Horn
			["s sax", 64, 0, 87], _ ; Soprano Sax ... REED
			["a sax", 65, 0, 87], _ ; Alto Sax
			["sax", 66, 0, 87], _ ; Tenor Sax
			["b sax", 67, 0, 87], _ ; Baritone Sax
			["ob", 68, 0, 87], _ ; Oboe
			["eng hn", 69, 0, 87], _ ; English Horn
			["bsn", 70, 0, 87], _ ; Bassoon
			["cl", 71, 0, 87], _ ; Clarinet
			["picc", 72, 0, 87], _ ; Piccolo ... PIPE
			["fl", 73, 0, 87], _ ; Flute
			["rec", 74, 0, 87], _ ; Recorder
			["pan", 75, 0, 87], _ ; Panpipes
			["bottle", 76, 0, 87], _ ; Bottle
			["shaku", 77, 0, 87], _ ; Shakuhachi
			["whistle", 78, 0, 87], _ ; Whistle
			["oc", 79, 0, 87], _ ; Ocarina
			["sitar", 104, 0, 87], _ ; Sitar ... OTHER
			["banjo", 105, 0, 87], _ ; Banjo
			["shamisen", 106, 0, 87], _ ; Shamisen
			["koto", 107, 0, 87], _ ; Koto
			["kalimba", 108, 0, 87], _ ; Kalimba (perc)
			["bagp", 109, 0, 87], _ ; Bagpipe
			["fiddle", 110, 0, 87], _ ; Fiddle
			["shanai", 111, 0, 87], _ ; Shanai (woodwind)
			["bell", 112, 0, 87], _ ; Tinkle Bell
			["st drum", 114, 0, 87], _ ; Steel Drums
			["w bl", 115, 0, 87], _ ; Woodblock
			["taiko", 116, 0, 87], _ ; Taiko Drum
			["tom-t", 117, 0, 87]] ; Tom-tom

	For $i = 0 To 71
		If $aMIDIInst[$i][0] = $vInstrument Then
			$vInstrument = $aMIDIInst[$i][1]
			ExitLoop
		EndIf
	Next

	$vInstrument = StringRegExpReplace($vInstrument, "[<>]", "")
	If StringRegExp($vInstrument, "[^\d]") Or $vInstrument < 0 Or $vInstrument > 127 Then Return SetError(1, 0, 0) ; returns Grand Piano
	Return $vInstrument ; values range from 0 to 117
EndFunc   ;==>_GetInstrument
#endregion ; data requests

#region ; miscellaneous functions
Func _InitialTidySource($sSource)
	If _IllegalDotCheck($sSource) Then Return SetError(1, 0, 0)
	$sSource = StringReplace($sSource, '"', "''") ; Helmholtz-Wilkinson octaves
	$sSource = StringReplace($sSource, '(', "( ") ; Add spaces after (
	$sSource = StringReplace($sSource, ')', " ) ") ; Add spaces before and after )
	$sSource = StringRegExpReplace($sSource, "(<\h+)", " <") ; Remove spaces after <
	$sSource = StringRegExpReplace($sSource, "(\h+>)", "> ") ; Remove spaces before >
	$sSource = StringReplace($sSource, '_', " _ ") ; Add spaces before and after underscore
	$sSource = StringReplace($sSource, '|:', "|: ") ; Add spaces after start repeats
	$sSource = StringReplace($sSource, ':|', " :|") ; Add spaces before end repeats
	$sSource = StringReplace($sSource, ':|:', ":||:") ; Convert double repeat marks _
	$sSource = StringReplace($sSource, '|', " | ") ; Add spaces before and after bar lines
	$sSource = StringReplace($sSource, '| :', "|:") ; Restore start repeat marks
	$sSource = StringReplace($sSource, ': |', ":|") ; Restore end repeat marks
	$sSource = StringReplace($sSource, ' |  | ', " || ") ; Restore double bar lines
	$sSource = StringRegExpReplace($sSource, "(<[\-\w]+)(\h+)(pno|box|org|acc|gtr|bass|tpt|sax|hn|drum|bl)", "$1" & "_" & "$3")
	$sSource = StringReplace(StringReplace($sSource, @CRLF, @LF), @CR, @LF) ; Replace all breaks with @LF
	$sSource = StringRegExpReplace($sSource, "(\n\h*)", @LF) ; Remove spaces after breaks
	$sSource = StringRegExpReplace($sSource, "[\n]{2,}", @LF & @LF) ; Remove duplicate empty lines
	$sSource = StringRegExpReplace($sSource, "(\A\n*)", "") ; Remove Preceeding breaks
	$sSource = StringRegExpReplace($sSource, "(\n*\z)", "") ; Remove Trailing breaks
	Return $sSource
EndFunc   ;==>_InitialTidySource

Func _UpdateCurrentAttrib(ByRef $vCurrAttrib, ByRef $aVoices, $vNewAttrib, $iIndex, $sPadLeft = "", $sPadRight = " ")
	If $vCurrAttrib <> $vNewAttrib Then
		$vCurrAttrib = $vNewAttrib
		$aVoices[$iIndex] &= $sPadLeft & $vCurrAttrib & $sPadRight
	EndIf
EndFunc   ;==>_UpdateCurrentAttrib

Func _ClearAccidentals(ByRef $aAccidentals)
	For $i = 0 To 6
		$aAccidentals[$i] = ""
	Next
EndFunc   ;==>_ClearAccidentals

Func _UpdateAccidentals(ByRef $aAccidentals, $sNote)
	$sNote = StringReplace($sNote, "'", "")
	Local $sAlpha = StringLeft($sNote, 1)
	$aAccidentals[Asc($sAlpha) - 65] = StringTrimLeft($sNote, 1)
EndFunc   ;==>_UpdateAccidentals

Func _NoteSplit($sNote)
	Local $aNotePart[2] = ["", ""]
	$aNotePart[1] = StringRegExpReplace($sNote, "[o\+;\-~\\\?\.]+", "") ; Remove rhthmic values
	$aNotePart[0] = StringLeft($sNote, StringLen($sNote) - StringLen($aNotePart[1]))
	Return $aNotePart
EndFunc   ;==>_NoteSplit

Func _IllegalDotCheck($sVoo)
	Return StringRegExp($sVoo, "(o\.{7}|\+\.{6}|;\.{5}|\-\.{4}|~\.{3}|\\\.\.|\?\.)")
	; Warning - detected an unsupported number of dots after a note
EndFunc   ;==>_IllegalDotCheck
#endregion ; miscellaneous functions

#region ; MIDI functions
;=======================================================
;Retrieves a MIDI handle and Opens the Device
;Parameters(Optional) - Device ID, Window Callback,
; instance, flags
;Author : Eynstyne
;Library : Microsoft winmm.dll
;=======================================================
Func _MidiOutOpen($devid = 0, $callback = 0, $instance = 0, $flags = 0)
	Local $ret = DllCall("winmm.dll", "long", "midiOutOpen", "handle*", 0, "int", $devid, "dword_ptr", $callback, "dword_ptr", $instance, "long", $flags)
	If @error Then Return SetError(@error, 0, 0)
	If $ret[0] Then Return SetError(-1, $ret[0], 0)
	Return $ret[1]
EndFunc   ;==>_MidiOutOpen

;=======================================================
;Closes Midi Output/Input devices
;Parameters - MidiHandle
;Author : Eynstyne
;Library : Microsoft winmm.dll
;=======================================================
Func _MidiOutClose($hmidiout)
	Local $ret = DllCall("winmm.dll", "long", "midiOutClose", "handle", $hmidiout)
	If @error Then Return SetError(@error, 0, 0)
	If $ret[0] Then Return SetError(-1, $ret[0], 0)
	Return $ret[0]
EndFunc   ;==>_MidiOutClose

;=======================================================
;Gets the Mixer Volume for MIDI
;Parameters - None
;Author : Eynstyne
;Library : Microsoft winmm.dll
;=======================================================
Func _MidiOutGetVolume($devid = 0)
	Local $ret = DllCall("winmm.dll", "long", "midiOutGetVolume", "handle", $devid, "dword*", 0)
	If @error Then Return SetError(@error, 0, 0)
	If $ret[0] Then Return SetError(-1, $ret[0], 0)
	Return $ret[2]
EndFunc   ;==>_MidiOutGetVolume

;=======================================================
;Sets the Mixer Volume for MIDI
;Parameters - Volume (0 - 65535)
;Author : Eynstyne
;Library : Microsoft winmm.dll
;=======================================================
Func _MidiOutSetVolume($iVolume = 65535, $devid = 0)
	Local $iMixVolume = BitAND($iVolume, 0xFFFF) + BitShift(BitAND($iVolume, 0xFFFF), -16) ; From Ascend4nt
	Local $ret = DllCall("winmm.dll", "long", "midiOutSetVolume", "handle", $devid, "int", $iMixVolume)
	If @error Then Return SetError(@error, 0, 0)
	If $ret[0] Then Return SetError(-1, $ret[0], 0)
	Return $ret[0]
EndFunc   ;==>_MidiOutSetVolume

;=======================================================
;MIDI Message Send Function
;Parameters - Message as Hexcode or Constant
;Author : Eynstyne
;Library : Microsoft winmm.dll
;=======================================================
Func _MidiOutShortMsg($hmidiout, $Msg)
	Local $ret = DllCall("winmm.dll", "long", "midiOutShortMsg", "handle", $hmidiout, "long", $Msg)
	If @error Then Return SetError(@error, 0, 0)
	If $ret[0] Then Return SetError(-1, $ret[0], 0)
	Return $ret[0]
EndFunc   ;==>_MidiOutShortMsg
#endregion ; MIDI functions

#region ; functions ripped from arrayf.au3 and stringf.au3
; #FUNCTION# ====================================================================================================================
; Name...........: _ArraySortByNumber
; Description ...: Sorts a 1D array numerically ascending.
; Syntax.........: _ArraySortByNumber(ByRef $avArray [, $bVulgarFrac = False])
; Parameters ....: $avArray     - [ByRef] The array to sort
;                  $bVulgarFrac - [Optional] If set to True, vulgar fractions will be also be sorted numerically
; Return values .: Success   - Returns 1
;                  Failure   - Returns zero and sets @error to the following values:
;                  |@error = 1 : $avArray is not a one dimensional array
; Author ........: czardas
; Modified.......:
; Remarks .......: The array is sorted first by numbers and then by strings.
; Related .......: _ArraySort, _ArraySortByLen
; Link ..........:
; Example .......:
; ===============================================================================================================================

Func _ArraySortByNumber(ByRef $avArray, $bVulgarFrac = False)
	If Not IsArray($avArray) Or UBound($avArray, 0) > 1 Then Return SetError(1, 0, 0)

	Local $iBound = UBound($avArray) - 1
	Local $aTemp[$iBound + 1][2]
	For $i = 0 To $iBound
		$aTemp[$i][0] = $avArray[$i]
		If _StringIsNumber($avArray[$i], $bVulgarFrac) Then
			$aTemp[$i][1] = Execute($avArray[$i])
		Else
			$aTemp[$i][1] = "z" & $avArray[$i]
		EndIf
	Next
	_ArraySort($aTemp, 0, 0, 0, 1)
	For $i = 0 To $iBound
		$avArray[$i] = $aTemp[$i][0]
	Next
	Return 1
EndFunc   ;==>_ArraySortByNumber

; #FUNCTION# ====================================================================================================================
; Name...........: _StringIsNumber
; Description ...: Checks whether a string is a number as recognised by the AutoIt interpreter
; Syntax.........: _StringIsNumber($sString [, $bVulgarFrac])
; Parameters ....: $sString     - The string to test
;                  $bVulgarFrac - [Optional] if set to True, vulgar fractions will also return True
; Return values .: True or False
; Author ........: czardas
; Remarks .......: Returns True for integers, floats, hexadecimal and scientific notation.
; Related .......: StringIsDigit, StringIsFloat, StringIsInt, StringIsXDigit
; Link ..........:
; Example .......: MsgBox(0, "1.2e-300 is a number", _StringIsNumber("1.2e-300"))
; ===============================================================================================================================

Func _StringIsNumber($sString, $bVulgarFrac = False)
	Local $bReturn = False
	If StringIsInt($sString) Or StringIsFloat($sString) Then
		$bReturn = True ; string is integer or float
	ElseIf StringRegExp($sString, "(?i)(\A[\+\-]?0x[A-F\d]+\z)") Then
		$bReturn = True ; string is hexadecimal integer
	ElseIf StringRegExp($sString, "(?i)(\A[\+\-]?\d*\.?\d+e[\+\-]?\d+\z)") Then
		$bReturn = True ; exponential (or scientific notation)
	ElseIf $bVulgarFrac And StringRegExp($sString, "(\A[\+\-]?\d+/\d+\z)") Then
		$bReturn = True ; string is a vulgar fraction
	EndIf
	Return $bReturn
EndFunc   ;==>_StringIsNumber
#endregion ; functions ripped from arrayf.au3 and stringf.au3
#endregion